/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce;

import jmri.NmraPacket;
import jmri.PushbuttonPacket;
import jmri.implementation.AbstractTurnout;
import jmri.jmrix.nce.NceBinaryCommand;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceTurnout
extends AbstractTurnout {
    NceTrafficController tc = null;
    String prefix = "";
    static String[] modeNames = null;
    static int[] modeValues = null;
    private static int numNtTurnouts = 0;
    int _number;
    private static final Logger log = LoggerFactory.getLogger(NceTurnout.class);

    public NceTurnout(NceTrafficController tc, String p, int i) {
        super(String.valueOf(p) + "T" + i);
        this.tc = tc;
        this.prefix = String.valueOf(p) + "T";
        this._number = i;
        if (this._number < 1 || this._number > 2044) {
            throw new IllegalArgumentException("Turnout value: " + this._number + " not in the range " + 1 + " to " + 2044);
        }
        this.initialize();
    }

    private synchronized void initialize() {
        ++numNtTurnouts;
        if (this.tc.getCommandOptions() >= 20 && this.tc.getUsbSystem() == 0) {
            if (modeNames == null) {
                if (this._validFeedbackNames.length != this._validFeedbackModes.length) {
                    log.error("int and string feedback arrays different length");
                }
                modeNames = new String[this._validFeedbackNames.length + 1];
                modeValues = new int[this._validFeedbackNames.length + 1];
                int i = 0;
                while (i < this._validFeedbackNames.length) {
                    NceTurnout.modeNames[i] = this._validFeedbackNames[i];
                    NceTurnout.modeValues[i] = this._validFeedbackModes[i];
                    ++i;
                }
                NceTurnout.modeNames[this._validFeedbackNames.length] = "MONITORING";
                NceTurnout.modeValues[this._validFeedbackNames.length] = 8;
            }
            this._validFeedbackTypes |= 8;
            this._validFeedbackNames = modeNames;
            this._validFeedbackModes = modeValues;
        }
        this._enableCabLockout = true;
        this._enablePushButtonLockout = true;
    }

    public int getNumber() {
        return this._number;
    }

    public static int getNumNtTurnouts() {
        return numNtTurnouts;
    }

    @Override
    protected void forwardCommandChangeToLayout(int newState) {
        if ((newState & 2) != 0) {
            if ((newState & 4) != 0) {
                log.error("Cannot command both CLOSED and THROWN {}", (Object)newState);
                return;
            }
            this.sendMessage(!this.getInverted());
        } else {
            this.sendMessage(this.getInverted());
        }
    }

    @Override
    protected void turnoutPushbuttonLockout(boolean pushButtonLockout) {
        log.debug("Send command to {} Pushbutton {}{}", new Object[]{pushButtonLockout ? "Lock" : "Unlock", this.prefix, this._number});
        byte[] bl = PushbuttonPacket.pushbuttonPkt(this.prefix, this._number, pushButtonLockout);
        NceMessage m = NceMessage.sendPacketMessage(this.tc, bl);
        this.tc.sendNceMessage(m, null);
    }

    synchronized void setCommandedStateFromCS(int state) {
        if (this.getFeedbackMode() != 8) {
            return;
        }
        this.newCommandedState(state);
    }

    synchronized void setKnownStateFromCS(int state) {
        if (this.getFeedbackMode() != 8) {
            return;
        }
        this.newKnownState(state);
    }

    @Override
    public boolean canInvert() {
        return true;
    }

    @Override
    public int getPossibleLockModes() {
        return 3;
    }

    @Override
    public boolean canLock(int turnoutLockout) {
        if (this.tc.getUsbSystem() != 0) {
            return false;
        }
        String dn = this.getDecoderName();
        if ((turnoutLockout & 2) != 0 && this._enablePushButtonLockout && dn != null && !dn.equals("None")) {
            return true;
        }
        return (turnoutLockout & 1) != 0 && this.getFeedbackMode() == 8 && this._enableCabLockout;
    }

    @Override
    public void enableLockOperation(int turnoutLockout, boolean enabled) {
        if ((turnoutLockout & 1) != 0) {
            if (enabled) {
                this._enableCabLockout = true;
            } else {
                this._cabLockout = false;
                this._enableCabLockout = false;
                this._enablePushButtonLockout = true;
            }
        }
        if ((turnoutLockout & 2) != 0) {
            if (enabled) {
                this._enablePushButtonLockout = true;
            } else {
                if (this.getFeedbackMode() != 8) {
                    return;
                }
                if (this._enableCabLockout) {
                    this._enablePushButtonLockout = false;
                }
            }
        }
    }

    protected void sendMessage(boolean closed) {
        if (this.tc.getCommandOptions() >= 20) {
            byte[] bl = NceBinaryCommand.accDecoder(this._number, closed);
            if (log.isDebugEnabled()) {
                log.debug("Command: {} {} {} {} {}", new Object[]{Integer.toHexString(0xFF & bl[0]), Integer.toHexString(0xFF & bl[1]), Integer.toHexString(0xFF & bl[2]), Integer.toHexString(0xFF & bl[3]), Integer.toHexString(0xFF & bl[4])});
            }
            NceMessage m = NceMessage.createBinaryMessage(this.tc, bl);
            this.tc.sendNceMessage(m, null);
        } else {
            byte[] bl = NmraPacket.accDecoderPkt(this._number, closed);
            if (log.isDebugEnabled()) {
                log.debug("packet: {} {} {}", new Object[]{Integer.toHexString(0xFF & bl[0]), Integer.toHexString(0xFF & bl[1]), Integer.toHexString(0xFF & bl[2])});
            }
            NceMessage m = NceMessage.sendPacketMessage(this.tc, bl);
            this.tc.sendNceMessage(m, null);
        }
    }
}

