/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.DccLocoAddress;
import jmri.LocoAddress;
import jmri.NmraPacket;
import jmri.SpeedStepMode;
import jmri.jmrix.AbstractThrottle;
import jmri.jmrix.nce.NceBinaryCommand;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceSystemConnectionMemo;
import jmri.jmrix.nce.NceTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceThrottle
extends AbstractThrottle {
    private boolean sendA2command = true;
    private NceTrafficController tc = null;
    DccLocoAddress address;
    private static final Logger log = LoggerFactory.getLogger(NceThrottle.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NceThrottle(NceSystemConnectionMemo memo, DccLocoAddress address) {
        super(memo);
        this.tc = memo.getNceTrafficController();
        this.setSpeedStepMode(SpeedStepMode.NMRA_DCC_128);
        NceThrottle nceThrottle = this;
        synchronized (nceThrottle) {
            this.speedSetting = 0.0f;
        }
        this.address = address;
        this.isForward = true;
        if (this.tc.getCommandOptions() <= 10) {
            this.sendA2command = false;
        }
    }

    @Override
    public LocoAddress getLocoAddress() {
        return this.address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendFunctionGroup1() {
        NceThrottle nceThrottle = this;
        synchronized (nceThrottle) {
            this.setSpeedSetting(this.speedSetting);
        }
        if (this.sendA2command) {
            int locoAddr = this.address.getNumber();
            if (this.address.isLongAddress()) {
                locoAddr += 49152;
            }
            int data = (this.getFunction(0) ? 16 : 0) | (this.getFunction(1) ? 1 : 0) | (this.getFunction(2) ? 2 : 0) | (this.getFunction(3) ? 4 : 0) | (this.getFunction(4) ? 8 : 0);
            NceMessage m = NceMessage.sendLocoCmd(this.tc, locoAddr, (byte)7, (byte)data);
            this.tc.sendNceMessage(m, null);
        } else {
            byte[] result = NmraPacket.function0Through4Packet(this.address.getNumber(), this.address.isLongAddress(), this.getF0(), this.getF1(), this.getF2(), this.getF3(), this.getF4());
            NceMessage m = NceMessage.sendPacketMessage(this.tc, result);
            this.tc.sendNceMessage(m, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendFunctionGroup2() {
        NceThrottle nceThrottle = this;
        synchronized (nceThrottle) {
            this.setSpeedSetting(this.speedSetting);
        }
        if (this.sendA2command) {
            int locoAddr = this.address.getNumber();
            if (this.address.isLongAddress()) {
                locoAddr += 49152;
            }
            int data = (this.getFunction(8) ? 8 : 0) | (this.getFunction(7) ? 4 : 0) | (this.getFunction(6) ? 2 : 0) | (this.getFunction(5) ? 1 : 0);
            NceMessage m = NceMessage.sendLocoCmd(this.tc, locoAddr, (byte)8, (byte)data);
            this.tc.sendNceMessage(m, null);
        } else {
            byte[] result = NmraPacket.function5Through8Packet(this.address.getNumber(), this.address.isLongAddress(), this.getF5(), this.getF6(), this.getF7(), this.getF8());
            NceMessage m = NceMessage.sendPacketMessage(this.tc, result);
            this.tc.sendNceMessage(m, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendFunctionGroup3() {
        NceThrottle nceThrottle = this;
        synchronized (nceThrottle) {
            this.setSpeedSetting(this.speedSetting);
        }
        if (this.sendA2command) {
            int locoAddr = this.address.getNumber();
            if (this.address.isLongAddress()) {
                locoAddr += 49152;
            }
            int data = (this.getFunction(12) ? 8 : 0) | (this.getFunction(11) ? 4 : 0) | (this.getFunction(10) ? 2 : 0) | (this.getFunction(9) ? 1 : 0);
            NceMessage m = NceMessage.sendLocoCmd(this.tc, locoAddr, (byte)9, (byte)data);
            this.tc.sendNceMessage(m, null);
        } else {
            byte[] result = NmraPacket.function9Through12Packet(this.address.getNumber(), this.address.isLongAddress(), this.getF9(), this.getF10(), this.getF11(), this.getF12());
            NceMessage m = NceMessage.sendPacketMessage(this.tc, result);
            this.tc.sendNceMessage(m, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendFunctionGroup4() {
        NceThrottle nceThrottle = this;
        synchronized (nceThrottle) {
            this.setSpeedSetting(this.speedSetting);
        }
        if (this.sendA2command) {
            int locoAddr = this.address.getNumber();
            if (this.address.isLongAddress()) {
                locoAddr += 49152;
            }
            int data = (this.getFunction(20) ? 128 : 0) | (this.getFunction(19) ? 64 : 0) | (this.getFunction(18) ? 32 : 0) | (this.getFunction(17) ? 16 : 0) | (this.getFunction(16) ? 8 : 0) | (this.getFunction(15) ? 4 : 0) | (this.getFunction(14) ? 2 : 0) | (this.getFunction(13) ? 1 : 0);
            NceMessage m = NceMessage.sendLocoCmd(this.tc, locoAddr, (byte)21, (byte)data);
            this.tc.sendNceMessage(m, null);
        } else {
            byte[] result = NmraPacket.function13Through20Packet(this.address.getNumber(), this.address.isLongAddress(), this.getF13(), this.getF14(), this.getF15(), this.getF16(), this.getF17(), this.getF18(), this.getF19(), this.getF20());
            NceMessage m = NceMessage.sendPacketMessage(this.tc, result);
            this.tc.sendNceMessage(m, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendFunctionGroup5() {
        NceThrottle nceThrottle = this;
        synchronized (nceThrottle) {
            this.setSpeedSetting(this.speedSetting);
        }
        if (this.sendA2command) {
            int locoAddr = this.address.getNumber();
            if (this.address.isLongAddress()) {
                locoAddr += 49152;
            }
            int data = (this.getFunction(28) ? 128 : 0) | (this.getFunction(27) ? 64 : 0) | (this.getFunction(26) ? 32 : 0) | (this.getFunction(25) ? 16 : 0) | (this.getFunction(24) ? 8 : 0) | (this.getFunction(23) ? 4 : 0) | (this.getFunction(22) ? 2 : 0) | (this.getFunction(21) ? 1 : 0);
            NceMessage m = NceMessage.sendLocoCmd(this.tc, locoAddr, (byte)22, (byte)data);
            this.tc.sendNceMessage(m, null);
        } else {
            byte[] result = NmraPacket.function21Through28Packet(this.address.getNumber(), this.address.isLongAddress(), this.getF21(), this.getF22(), this.getF23(), this.getF24(), this.getF25(), this.getF25(), this.getF27(), this.getF28());
            NceMessage m = NceMessage.sendPacketMessage(this.tc, result);
            this.tc.sendNceMessage(m, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
    public void setSpeedSetting(float speed) {
        byte[] bl;
        float oldSpeed;
        NceThrottle nceThrottle = this;
        synchronized (nceThrottle) {
            oldSpeed = this.speedSetting;
            this.speedSetting = speed;
        }
        log.debug("setSpeedSetting= {}", (Object)Float.valueOf(speed));
        if (this.sendA2command) {
            int value;
            int locoAddr = this.address.getNumber();
            if (this.address.isLongAddress()) {
                locoAddr += 49152;
            }
            if ((value = (int)(126.0f * speed)) > 126) {
                value = 126;
            }
            bl = value < 0 ? NceBinaryCommand.nceLocoCmd(locoAddr, this.isForward ? (byte)6 : 5, (byte)0) : (this.speedStepMode == SpeedStepMode.NMRA_DCC_128 ? NceBinaryCommand.nceLocoCmd(locoAddr, this.isForward ? (byte)4 : 3, (byte)value) : NceBinaryCommand.nceLocoCmd(locoAddr, this.isForward ? (byte)2 : 1, (byte)value));
            NceMessage m = NceMessage.createBinaryMessage(this.tc, bl);
            this.tc.sendNceMessage(m, null);
        } else {
            if (this.speedStepMode == SpeedStepMode.NMRA_DCC_128) {
                int value = (int)(126.0f * speed);
                if (value > 0) {
                    ++value;
                }
                if (value > 127) {
                    value = 127;
                }
                if (value < 0) {
                    value = 1;
                }
                bl = NmraPacket.speedStep128Packet(this.address.getNumber(), this.address.isLongAddress(), value, this.isForward);
            } else {
                int value = (int)(28.0f * speed);
                if (value > 0) {
                    ++value;
                }
                if (value > 28) {
                    value = 28;
                }
                if (value < 0) {
                    value = 1;
                }
                bl = NmraPacket.speedStep28Packet(this.address.getNumber(), this.address.isLongAddress(), value, this.isForward);
            }
            NceMessage m = NceMessage.queuePacketMessage(this.tc, bl);
            this.tc.sendNceMessage(m, null);
        }
        nceThrottle = this;
        synchronized (nceThrottle) {
            this.firePropertyChange("SpeedSetting", Float.valueOf(oldSpeed), Float.valueOf(this.speedSetting));
        }
        this.record(speed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIsForward(boolean forward) {
        boolean old = this.isForward;
        this.isForward = forward;
        NceThrottle nceThrottle = this;
        synchronized (nceThrottle) {
            this.setSpeedSetting(this.speedSetting);
        }
        log.debug("setIsForward= {}", (Object)forward);
        this.firePropertyChange("IsForward", old, this.isForward);
    }

    @Override
    public void throttleDispose() {
        this.finishRecord();
    }
}

