/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.nce.Bundle;
import jmri.jmrix.nce.NceAIU;
import jmri.jmrix.nce.NceListener;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceReply;
import jmri.jmrix.nce.NceSensor;
import jmri.jmrix.nce.NceSystemConnectionMemo;
import jmri.managers.AbstractSensorManager;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceSensorManager
extends AbstractSensorManager
implements NceListener {
    private final NceSensorManager mInstance = null;
    NceAIU[] aiuArray = new NceAIU[64];
    int[] activeAIUs = new int[63];
    int activeAIUMax = 0;
    private static final int MINAIU = 1;
    private static final int MAXAIU = 63;
    private static final int MAXPIN = 14;
    volatile Thread pollThread;
    volatile boolean stopPolling = false;
    NceListener listener;
    private final int shortCycleInterval = 200;
    private final int longCycleInterval = 10000;
    private final long maxSilentInterval = 30000L;
    private final int pollTimeout = 20000;
    private int aiuCycleCount;
    private long lastMessageReceived;
    private NceAIU currentAIU;
    private boolean awaitingReply = false;
    private boolean awaitingDelay = false;
    int aiucab = 0;
    int pin = 0;
    int iName = 0;
    private static final Logger log = LoggerFactory.getLogger(NceSensorManager.class);

    public NceSensorManager(NceSystemConnectionMemo memo) {
        super(memo);
        int i = 1;
        while (i <= 63) {
            this.aiuArray[i] = null;
            ++i;
        }
        this.listener = new NceListener(){

            @Override
            public void message(NceMessage m) {
            }

            @Override
            public void reply(NceReply r) {
                if (r.isSensorMessage()) {
                    NceSensorManager.this.mInstance.handleSensorMessage(r);
                }
            }
        };
        memo.getNceTrafficController().addNceListener(this.listener);
    }

    @Override
    @Nonnull
    public NceSystemConnectionMemo getMemo() {
        return (NceSystemConnectionMemo)this.memo;
    }

    @Override
    public void dispose() {
        this.stopPolling = true;
        Thread thread = this.pollThread;
        if (thread != null) {
            try {
                thread.interrupt();
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                log.warn("dispose interrupted");
            }
        }
        this.getMemo().getNceTrafficController().removeNceListener(this.listener);
        super.dispose();
    }

    @Override
    @Nonnull
    protected Sensor createNewSensor(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        int number = 0;
        try {
            number = Integer.parseInt(systemName.substring(this.getSystemPrefix().length() + 1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Unable to convert " + systemName.substring(this.getSystemPrefix().length() + 1) + " to NCE sensor address");
        }
        NceSensor s = new NceSensor(systemName);
        s.setUserName(userName);
        int index = number / 16 + 1;
        if (this.aiuArray[index] == null) {
            this.aiuArray[index] = new NceAIU();
            this.buildActiveAIUs();
        }
        this.aiuArray[index].registerSensor(s, number - (index - 1) * 16);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildActiveAIUs() {
        this.activeAIUMax = 0;
        int a = 1;
        while (a <= 63) {
            if (this.aiuArray[a] != null) {
                this.activeAIUs[this.activeAIUMax++] = a;
            }
            ++a;
        }
        this.aiuCycleCount = 0;
        this.lastMessageReceived = Long.MIN_VALUE;
        if (this.activeAIUMax > 0) {
            if (this.pollThread == null) {
                this.pollThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        NceSensorManager.this.pollManager();
                    }
                });
                this.pollThread.setName("NCE Sensor Poll");
                this.pollThread.setDaemon(true);
                this.pollThread.start();
            } else {
                NceSensorManager nceSensorManager = this;
                synchronized (nceSensorManager) {
                    if (this.awaitingDelay) {
                        this.notify();
                    }
                }
            }
        }
    }

    public NceMessage makeAIUPoll(int aiuNo) {
        if (this.getMemo().getNceTrafficController().getUsbSystem() == 0) {
            return this.makeAIUPoll4ByteReply(aiuNo);
        }
        return this.makeAIUPoll2ByteReply(aiuNo);
    }

    private NceMessage makeAIUPoll4ByteReply(int aiuNo) {
        NceMessage m = new NceMessage(2);
        m.setBinary(true);
        m.setReplyLen(4);
        m.setElement(0, 138);
        m.setElement(1, aiuNo);
        m.setTimeout(20000);
        return m;
    }

    private NceMessage makeAIUPoll2ByteReply(int aiuNo) {
        NceMessage m = new NceMessage(2);
        m.setBinary(true);
        m.setReplyLen(2);
        m.setElement(0, 155);
        m.setElement(1, aiuNo);
        m.setTimeout(20000);
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollManager() {
        while (!this.stopPolling) {
            int a = 0;
            while (a < this.activeAIUMax) {
                int aiuNo = this.activeAIUs[a];
                this.currentAIU = this.aiuArray[aiuNo];
                if (this.currentAIU != null) {
                    NceMessage m = this.makeAIUPoll(aiuNo);
                    NceSensorManager nceSensorManager = this;
                    synchronized (nceSensorManager) {
                        log.debug("queueing poll request for AIU {}", (Object)aiuNo);
                        this.getMemo().getNceTrafficController().sendNceMessage(m, this);
                        this.awaitingReply = true;
                        try {
                            this.wait(20000L);
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                    int delay = 200;
                    if (this.aiuCycleCount >= 2 && this.lastMessageReceived >= System.currentTimeMillis() - 30000L) {
                        delay = 10000;
                    }
                    NceSensorManager nceSensorManager2 = this;
                    synchronized (nceSensorManager2) {
                        if (this.awaitingReply && !this.stopPolling) {
                            log.warn("timeout awaiting poll response for AIU {}", (Object)aiuNo);
                            delay = 20000;
                        }
                        try {
                            try {
                                this.awaitingDelay = true;
                                this.wait(delay);
                            }
                            catch (InterruptedException interruptedException) {
                                Thread.currentThread().interrupt();
                                this.awaitingDelay = false;
                                return;
                            }
                        }
                        finally {
                            this.awaitingDelay = false;
                        }
                    }
                }
                ++a;
            }
            ++this.aiuCycleCount;
        }
    }

    @Override
    public void message(NceMessage r) {
        log.warn("unexpected message");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reply(NceReply r) {
        if (!r.isUnsolicited()) {
            int bits;
            NceSensorManager nceSensorManager = this;
            synchronized (nceSensorManager) {
                bits = r.pollValue();
                this.awaitingReply = false;
                this.notify();
            }
            this.currentAIU.markChanges(bits);
            if (log.isDebugEnabled()) {
                String str = StringUtil.twoHexFromInt(bits >> 4 & 0xF);
                str = String.valueOf(str) + " ";
                str = StringUtil.appendTwoHexFromInt(bits & 0xF, str);
                log.debug("sensor poll reply received: \"{}\"", (Object)str);
            }
        }
    }

    public void handleSensorMessage(AbstractMRReply r) {
        int index = r.getElement(1) - 48;
        int indicator = r.getElement(2);
        if (r.getElement(0) == 97 && r.getElement(1) >= 48 && r.getElement(1) <= 111 && (indicator >= 65 && indicator <= 94 || indicator >= 97 && indicator <= 126)) {
            this.lastMessageReceived = System.currentTimeMillis();
            if (this.aiuArray[index] == null) {
                log.debug("unsolicited message \"{}\" for unused sensor array", (Object)r.toString());
            } else {
                int newState;
                int sensorNo;
                if (indicator >= 96) {
                    sensorNo = indicator - 97;
                    newState = 2;
                } else {
                    sensorNo = indicator - 65;
                    newState = 4;
                }
                Sensor s = this.aiuArray[index].getSensor(sensorNo);
                if (s.getInverted()) {
                    if (newState == 2) {
                        newState = 4;
                    } else if (newState == 4) {
                        newState = 2;
                    }
                }
                if (log.isDebugEnabled()) {
                    String msg = "Handling sensor message \"" + r.toString() + "\" for ";
                    msg = String.valueOf(msg) + s.getSystemName();
                    msg = newState == 2 ? String.valueOf(msg) + ": ACTIVE" : String.valueOf(msg) + ": INACTIVE";
                    log.debug(msg);
                }
                this.aiuArray[index].sensorChange(sensorNo, newState);
            }
        } else {
            log.warn("incorrect sensor message: {}", (Object)r.toString());
        }
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    @Nonnull
    public String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        if (curAddress.contains(":")) {
            int seperator = curAddress.indexOf(":");
            try {
                this.aiucab = Integer.parseInt(curAddress.substring(0, seperator));
                this.pin = Integer.parseInt(curAddress.substring(seperator + 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new JmriException("Unable to convert " + curAddress + " into the cab and pin format of nn:xx");
            }
            this.iName = (this.aiucab - 1) * 16 + this.pin - 1;
        } else {
            try {
                this.iName = Integer.parseInt(curAddress);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JmriException("Hardware Address passed " + curAddress + " should be a number or the cab and pin format of nn:xx");
            }
            this.pin = this.iName % 16 + 1;
            this.aiucab = this.iName / 16 + 1;
        }
        if (this.pin == 0 || this.pin > 14) {
            throw new JmriException("Sensor pin number " + this.pin + " for address " + curAddress + " is out of range; only pin numbers 1 - 14 are valid");
        }
        if (this.aiucab == 0 || this.aiucab > 63) {
            throw new JmriException("AIU number " + this.aiucab + " for address " + curAddress + " is out of range; only AIU 1 - 63 are valid");
        }
        return String.valueOf(prefix) + this.typeLetter() + this.iName;
    }

    @Override
    public String getNextValidAddress(@Nonnull String curAddress, @Nonnull String prefix, boolean ignoreInitialExisting) throws JmriException {
        String tmpSName = this.createSystemName(curAddress, prefix);
        Sensor s = this.getBySystemName(tmpSName);
        if (s != null || ignoreInitialExisting) {
            int x = 1;
            while (x < 10) {
                ++this.iName;
                ++this.pin;
                if (this.pin > 14) {
                    throw new JmriException("Unable to increment " + curAddress + " pin " + this.pin + " is greater than " + 14);
                }
                s = this.getBySystemName(String.valueOf(prefix) + this.typeLetter() + this.iName);
                if (s == null) {
                    return Integer.toString(this.iName);
                }
                ++x;
            }
            throw new JmriException(Bundle.getMessage("InvalidNextValidTenInUse", this.getBeanTypeHandled(true), curAddress, this.iName));
        }
        return Integer.toString(this.iName);
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) {
        int num;
        String[] parts;
        if (name.contains(":")) {
            parts = super.validateSystemNameFormat(name, locale).substring(this.getSystemNamePrefix().length()).split(":");
            if (parts.length != 2) {
                throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameNeedCabAndPin", name), Bundle.getMessage(locale, "InvalidSystemNameNeedCabAndPin", name));
            }
        } else {
            parts = new String[]{"0", "0"};
            try {
                num = Integer.parseInt(super.validateSystemNameFormat(name, locale).substring(this.getSystemNamePrefix().length()));
                parts[0] = Integer.toString(num / 16 + 1);
                parts[1] = Integer.toString(num % 16 + 1);
            }
            catch (NumberFormatException numberFormatException) {
                throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameNeedCabAndPin", name), Bundle.getMessage(locale, "InvalidSystemNameNeedCabAndPin", name));
            }
        }
        try {
            num = Integer.parseInt(parts[0]);
            if (num < 1 || num > 63) {
                throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameBadAIUCab", name), Bundle.getMessage(locale, "InvalidSystemNameBadAIUCab", name));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameBadAIUCab", name), Bundle.getMessage(locale, "InvalidSystemNameBadAIUCab", name));
        }
        try {
            num = Integer.parseInt(parts[1]);
            if (num < 1 || num > 14) {
                throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameBadAIUPin", name), Bundle.getMessage(locale, "InvalidSystemNameBadAIUPin", name));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameBadAIUCab", name), Bundle.getMessage(locale, "InvalidSystemNameBadAIUCab", name));
        }
        return name;
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        if (super.validSystemNameFormat(systemName) == Manager.NameValidity.VALID) {
            try {
                this.validateSystemNameFormat(systemName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (systemName.endsWith(":")) {
                    try {
                        int num = Integer.parseInt(systemName.substring(this.getSystemNamePrefix().length(), systemName.length() - 1));
                        if (num >= 1 && num <= 63) {
                            return Manager.NameValidity.VALID_AS_PREFIX_ONLY;
                        }
                    }
                    catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {}
                }
                return Manager.NameValidity.INVALID;
            }
        }
        return Manager.NameValidity.VALID;
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddInputEntryToolTip");
    }
}

