/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce;

import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.nce.NceTrafficController;
import jmri.jmrix.nce.ncemon.NceMonBinary;

public class NceReply
extends AbstractMRReply {
    NceTrafficController tc;
    private static final NceMonBinary nceMon = new NceMonBinary();

    public NceReply(NceTrafficController tc) {
        this.tc = tc;
    }

    public NceReply(NceTrafficController tc, String s) {
        super(s);
        this.tc = tc;
    }

    public NceReply(NceTrafficController tc, NceReply l) {
        super(l);
        this.tc = tc;
    }

    @Override
    protected int skipPrefix(int index) {
        int len = "COMMAND: ".length();
        if (this.getNumDataElements() >= index + len - 1 && 'C' == (char)this.getElement(index) && 'O' == (char)this.getElement(index + 1) && 'M' == (char)this.getElement(index + 2) && 'M' == (char)this.getElement(index + 3) && 'A' == (char)this.getElement(index + 4) && 'N' == (char)this.getElement(index + 5) && 'D' == (char)this.getElement(index + 6) && ':' == (char)this.getElement(index + 7) && ' ' == (char)this.getElement(index + 8)) {
            index += "COMMAND: ".length();
        }
        return index;
    }

    @Override
    public int value() {
        if (this.isBinary()) {
            return this.getElement(0) & 0xFF;
        }
        return super.value();
    }

    @Override
    public int pollValue() {
        int first = 0xFF & (byte)this.getElement(0);
        int second = 0xFF & (byte)this.getElement(1);
        return first * 256 + second;
    }

    public boolean isSensorMessage() {
        return this.getElement(0) == 97 && this.getElement(1) >= 48 && this.getElement(2) >= 65 && this.getElement(2) <= 111 && this.getNumDataElements() == 3;
    }

    @Override
    public boolean isUnsolicited() {
        if (this.tc.getCommandOptions() >= 20) {
            return false;
        }
        if (this.isSensorMessage()) {
            this.setUnsolicited();
            return true;
        }
        return false;
    }

    @Override
    public String toMonitorString() {
        return nceMon.displayReply(this);
    }
}

