/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.jmrix.AbstractProgrammer;
import jmri.jmrix.nce.NceListener;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceReply;
import jmri.jmrix.nce.NceTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceProgrammer
extends AbstractProgrammer
implements NceListener {
    protected NceTrafficController tc;
    int progState = 0;
    static final int NOTPROGRAMMING = 0;
    static final int COMMANDSENT = 2;
    static final int COMMANDSENT_2 = 4;
    boolean _progRead = false;
    int _val;
    int _cv;
    private ProgListener _usingProgrammer = null;
    private static final Logger log = LoggerFactory.getLogger(NceProgrammer.class);

    public NceProgrammer(NceTrafficController tc) {
        this.tc = tc;
        this.SHORT_TIMEOUT = 4000;
        if (this.getSupportedModes().size() > 0) {
            this.setMode(this.getSupportedModes().get(0));
        }
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        ArrayList<ProgrammingMode> ret = new ArrayList<ProgrammingMode>();
        if (this.tc == null) {
            log.warn("getSupportedModes called with null tc", (Throwable)new Exception("traceback"));
        }
        Objects.requireNonNull(this.tc, "TrafficController reference needed");
        if (this.tc.getUsbSystem() != 0) {
            switch (this.tc.getUsbSystem()) {
                case 1: 
                case 4: {
                    ret.add(ProgrammingMode.DIRECTMODE);
                    ret.add(ProgrammingMode.PAGEMODE);
                    ret.add(ProgrammingMode.REGISTERMODE);
                    return ret;
                }
                case 2: 
                case 3: 
                case 5: {
                    log.trace("no programming modes available for USB {}", (Object)this.tc.getUsbSystem());
                    return ret;
                }
            }
            log.warn("should not have hit default");
            return ret;
        }
        if (this.tc.getCommandOptions() >= 20) {
            ret.add(ProgrammingMode.DIRECTMODE);
        }
        ret.add(ProgrammingMode.PAGEMODE);
        ret.add(ProgrammingMode.REGISTERMODE);
        return ret;
    }

    @Override
    public boolean getCanRead() {
        return this.tc == null || this.tc.getUsbSystem() == 1 || this.tc.getUsbSystem() == 4 || this.tc.getUsbSystem() == 0;
    }

    @Override
    public boolean getCanWrite(String cv) {
        return this.getCanWrite(Integer.parseInt(cv));
    }

    boolean getCanWrite(int cv) {
        return cv <= 256 || this.getMode() != ProgrammingMode.PAGEMODE && this.getMode() != ProgrammingMode.DIRECTMODE && this.getMode() != ProgrammingMode.REGISTERMODE || this.tc == null || this.tc.getCommandOptions() != 0 && this.tc.getCommandOptions() != 10 && this.tc.getCommandOptions() != 20 || this.tc.isPwrProVer060203orLater();
    }

    @Override
    public synchronized void writeCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        if (log.isDebugEnabled()) {
            log.debug("writeCV {} listens {}", (Object)CV, (Object)p);
        }
        this.useProgrammer(p);
        if (!this.getCanWrite(CV)) {
            log.error("Write {} CV {} unsupported by NCE EPROM revision {}", new Object[]{this.getMode(), CV, this.tc.getPwrProVersHexText()});
            this.progState = 0;
            this.cleanup();
            this.notifyProgListenerEnd(this._val, 8);
            return;
        }
        this._progRead = false;
        this.progState = 2;
        this._val = val;
        this._cv = CV;
        try {
            this.startLongTimer();
            this.tc.sendNceMessage(this.progTaskStart(this.getMode(), this._val, this._cv), this);
        }
        catch (ProgrammerException e) {
            this.progState = 0;
            throw e;
        }
    }

    @Override
    public void confirmCV(String CV, int val, ProgListener p) throws ProgrammerException {
        this.readCV(CV, p);
    }

    @Override
    public synchronized void readCV(String CVname, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        if (log.isDebugEnabled()) {
            log.debug("readCV {} listens {}", (Object)CV, (Object)p);
        }
        this.useProgrammer(p);
        this._progRead = true;
        this.progState = 2;
        this._cv = CV;
        try {
            this.startLongTimer();
            this.tc.sendNceMessage(this.progTaskStart(this.getMode(), -1, this._cv), this);
        }
        catch (ProgrammerException e) {
            this.progState = 0;
            throw e;
        }
    }

    protected void useProgrammer(ProgListener p) throws ProgrammerException {
        if (this._usingProgrammer != null && this._usingProgrammer != p) {
            if (log.isInfoEnabled()) {
                log.info("programmer already in use by {}", (Object)this._usingProgrammer);
            }
            throw new ProgrammerException("programmer in use");
        }
        this._usingProgrammer = p;
    }

    protected NceMessage progTaskStart(ProgrammingMode mode, int val, int cvnum) throws ProgrammerException {
        if (val < 0) {
            if (mode == ProgrammingMode.PAGEMODE) {
                return NceMessage.getReadPagedCV(this.tc, cvnum);
            }
            if (mode == ProgrammingMode.DIRECTMODE) {
                return NceMessage.getReadDirectCV(this.tc, cvnum);
            }
            return NceMessage.getReadRegister(this.tc, this.registerFromCV(cvnum));
        }
        if (mode == ProgrammingMode.PAGEMODE) {
            return NceMessage.getWritePagedCV(this.tc, cvnum, val);
        }
        if (mode == ProgrammingMode.DIRECTMODE) {
            return NceMessage.getWriteDirectCV(this.tc, cvnum, val);
        }
        return NceMessage.getWriteRegister(this.tc, this.registerFromCV(cvnum), val);
    }

    @Override
    public void message(NceMessage m) {
        log.error("message received unexpectedly: {}", (Object)m.toString());
    }

    @Override
    public synchronized void reply(NceReply m) {
        if (this.progState == 0) {
            if (log.isDebugEnabled()) {
                log.debug("reply in NOTPROGRAMMING state");
            }
            return;
        }
        if (this.progState == 2) {
            if (log.isDebugEnabled()) {
                log.debug("reply in COMMANDSENT state");
            }
            this.progState = 0;
            if (m.match("NO FEEDBACK DETECTED") >= 0 || m.isBinary() && !this._progRead && m.getElement(0) != NceMessage.NCE_OKAY || m.isBinary() && this._progRead && m.getElement(1) != NceMessage.NCE_OKAY) {
                if (log.isDebugEnabled()) {
                    log.debug("handle NO FEEDBACK DETECTED");
                }
                this.notifyProgListenerEnd(this._val, 2);
            } else {
                if (this._progRead) {
                    this._val = m.value();
                }
                this.notifyProgListenerEnd(this._val, 0);
            }
        } else if (this.progState == 4) {
            if (log.isDebugEnabled()) {
                log.debug("first reply in COMMANDSENT_2 state");
            }
            this.progState = 2;
        } else if (log.isDebugEnabled()) {
            log.debug("reply in un-decoded state");
        }
    }

    @Override
    protected synchronized void timeout() {
        if (this.progState != 0) {
            if (log.isDebugEnabled()) {
                log.debug("timeout!");
            }
            this.progState = 0;
            this.cleanup();
            this.notifyProgListenerEnd(this._val, 128);
        }
    }

    void cleanup() {
    }

    protected void notifyProgListenerEnd(int value, int status) {
        if (log.isDebugEnabled()) {
            log.debug("notifyProgListenerEnd value {} status {}", (Object)value, (Object)status);
        }
        ProgListener temp = this._usingProgrammer;
        this._usingProgrammer = null;
        this.notifyProgListenerEnd(temp, value, status);
    }
}

