/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce;

import jmri.JmriException;
import jmri.jmrix.nce.NceListener;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceReply;
import jmri.jmrix.nce.NceSystemConnectionMemo;
import jmri.jmrix.nce.NceTrafficController;
import jmri.managers.AbstractPowerManager;

public class NcePowerManager
extends AbstractPowerManager<NceSystemConnectionMemo>
implements NceListener {
    boolean waiting = false;
    int onReply = 1;
    NceTrafficController tc = null;

    public NcePowerManager(NceSystemConnectionMemo memo) {
        this(memo.getNceTrafficController(), memo.getSystemPrefix());
    }

    public NcePowerManager(NceTrafficController tc, String p) {
        super(tc.getAdapterMemo());
        this.tc = tc;
        tc.addNceListener(this);
    }

    @Override
    public void setPower(int v) throws JmriException {
        int old = this.power;
        this.power = 1;
        this.checkTC();
        if (v == 2) {
            this.waiting = true;
            this.onReply = 2;
            NceMessage l = NceMessage.getEnableMain(this.tc);
            this.tc.sendNceMessage(l, this);
        } else if (v == 4) {
            this.waiting = true;
            this.onReply = 4;
            this.firePowerPropertyChange(old, this.power);
            NceMessage l = NceMessage.getKillMain(this.tc);
            this.tc.sendNceMessage(l, this);
        }
        this.firePowerPropertyChange(old, this.power);
    }

    @Override
    public void dispose() throws JmriException {
        this.tc.removeNceListener(this);
        this.tc = null;
    }

    private void checkTC() throws JmriException {
        if (this.tc == null) {
            throw new JmriException("attempt to use NcePowerManager after dispose");
        }
    }

    @Override
    public void reply(NceReply m) {
        if (this.waiting) {
            int old = this.power;
            this.power = this.onReply;
            this.firePowerPropertyChange(old, this.power);
        }
        this.waiting = false;
    }

    @Override
    public void message(NceMessage m) {
        if (m.isKillMain()) {
            this.waiting = true;
            this.onReply = 4;
        } else if (m.isEnableMain()) {
            this.waiting = true;
            this.onReply = 2;
        }
    }
}

