/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.AddressedProgrammer;
import jmri.NmraPacket;
import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.jmrix.nce.NceBinaryCommand;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceProgrammer;
import jmri.jmrix.nce.NceTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceOpsModeProgrammer
extends NceProgrammer
implements AddressedProgrammer {
    int mAddress;
    boolean mLongAddr;
    private static final Logger log = LoggerFactory.getLogger(NceOpsModeProgrammer.class);

    public NceOpsModeProgrammer(NceTrafficController tc, int pAddress, boolean pLongAddr) {
        super(tc);
        log.debug("NCE ops mode programmer {} {}", (Object)pAddress, (Object)pLongAddr);
        this.mAddress = pAddress;
        this.mLongAddr = pLongAddr;
        this.setMode(ProgrammingMode.OPSBYTEMODE);
    }

    @Override
    public synchronized void writeCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        NceMessage msg;
        int CV = Integer.parseInt(CVname);
        if (log.isDebugEnabled()) {
            log.debug("write CV={} val={}", (Object)CV, (Object)val);
        }
        if (this.tc.getUsbSystem() == 1 || this.tc.getUsbSystem() == 2 || this.tc.getUsbSystem() == 5 || this.tc.getUsbSystem() == 4) {
            int locoAddr = this.mAddress;
            if (this.mLongAddr) {
                locoAddr += 49152;
            }
            byte[] bl = NceBinaryCommand.usbOpsModeLoco(this.tc, locoAddr, CV, val);
            msg = NceMessage.createBinaryMessage(this.tc, bl);
        } else {
            byte[] contents = NmraPacket.opsCvWriteByte(this.mAddress, this.mLongAddr, CV, val);
            if (contents == null) {
                throw new ProgrammerException();
            }
            msg = NceMessage.sendPacketMessage(this.tc, contents, 5);
        }
        this.useProgrammer(p);
        this._progRead = false;
        this.progState = 4;
        this._val = val;
        this._cv = CV;
        this.startShortTimer();
        this.tc.sendNceMessage(msg, this);
        this.tc.sendNceMessage(msg, this);
    }

    @Override
    public synchronized void readCV(String CVname, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        if (log.isDebugEnabled()) {
            log.debug("read CV={}", (Object)CV);
        }
        log.error("readCV not available in this protocol");
        throw new ProgrammerException();
    }

    @Override
    public synchronized void confirmCV(String CV, int val, ProgListener p) throws ProgrammerException {
        if (log.isDebugEnabled()) {
            log.debug("confirm CV={}", (Object)CV);
        }
        log.error("confirmCV not available in this protocol");
        throw new ProgrammerException();
    }

    @Override
    protected void notifyProgListenerEnd(int value, int status) {
        if (log.isDebugEnabled()) {
            log.debug("NceOpsModeProgrammer adds 200mSec delay to response");
        }
        try {
            this.wait(200L);
        }
        catch (InterruptedException e) {
            log.debug("unexpected exception {}", (Throwable)e);
        }
        super.notifyProgListenerEnd(value, status);
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        ArrayList<ProgrammingMode> ret = new ArrayList<ProgrammingMode>();
        ret.add(ProgrammingMode.OPSBYTEMODE);
        return ret;
    }

    @Override
    public boolean getCanRead() {
        return false;
    }

    @Override
    void cleanup() {
    }

    @Override
    public boolean getLongAddress() {
        return this.mLongAddr;
    }

    @Override
    public int getAddressNumber() {
        return this.mAddress;
    }

    @Override
    public String getAddress() {
        return this.getAddressNumber() + " " + this.getLongAddress();
    }
}

