/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce;

import jmri.JmriException;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceMessageCheck {
    private static final Logger log = LoggerFactory.getLogger(NceMessageCheck.class);

    public static void checkMessage(NceSystemConnectionMemo memo, NceMessage m) throws JmriException {
        if (m != null) {
            switch (m.getOpCode()) {
                case 157: {
                    NceMessageCheck.checkSerial_CMD(memo, m);
                    break;
                }
                case 143: {
                    NceMessageCheck.checkSerial_CMD(memo, m);
                    break;
                }
                case 142: {
                    NceMessageCheck.checkSerial_CMD(memo, m);
                    break;
                }
                case 151: {
                    NceMessageCheck.checkSerial_CMD(memo, m);
                    break;
                }
                case 152: {
                    NceMessageCheck.checkSerial_CMD(memo, m);
                    break;
                }
                case 153: {
                    NceMessageCheck.checkSerial_CMD(memo, m);
                    break;
                }
                case 154: {
                    NceMessageCheck.checkSerial_CMD(memo, m);
                    break;
                }
                case 131: {
                    NceMessageCheck.checkSerial_CMD(memo, m);
                    break;
                }
                case 132: {
                    NceMessageCheck.checkSerial_CMD(memo, m);
                    break;
                }
                case 133: {
                    NceMessageCheck.checkSerial_CMD(memo, m);
                    break;
                }
                case 134: {
                    NceMessageCheck.checkSerial_CMD(memo, m);
                    break;
                }
                case 135: {
                    NceMessageCheck.checkSerial_CMD(memo, m);
                    break;
                }
                case 174: {
                    NceMessageCheck.checkOPS_PROG_CMD(memo, m);
                    break;
                }
                case 175: {
                    NceMessageCheck.checkOPS_PROG_CMD(memo, m);
                    break;
                }
                case 179: {
                    NceMessageCheck.checkUsbMem_CMD(memo, m);
                    break;
                }
                case 181: {
                    NceMessageCheck.checkUsbMem_CMD(memo, m);
                    break;
                }
                case 180: {
                    NceMessageCheck.checkUsbMem_CMD(memo, m);
                    break;
                }
            }
        }
    }

    private static void checkSerial_CMD(NceSystemConnectionMemo memo, NceMessage m) throws JmriException {
        if (memo.getNceUsbSystem() != 0) {
            String txt = "attempt to send unsupported binary command to NCE USB: " + Integer.toHexString(m.getOpCode()).toUpperCase();
            log.debug(txt);
            throw new JmriException(txt);
        }
    }

    private static void checkOPS_PROG_CMD(NceSystemConnectionMemo memo, NceMessage m) throws JmriException {
        if (memo.getNceUsbSystem() != 0 && (memo.getNceCmdGroups() & 0x10L) != 0L) {
            return;
        }
        String txt = "attempt to send unsupported binary command: " + Integer.toHexString(m.getOpCode()).toUpperCase();
        log.debug(txt);
        throw new JmriException(txt);
    }

    private static void checkUsbMem_CMD(NceSystemConnectionMemo memo, NceMessage m) throws JmriException {
        if (memo.getNceUsbSystem() != 0 && (memo.getNceCmdGroups() & 8L) != 0L) {
            return;
        }
        String txt = "attempt to send unsupported binary command: " + Integer.toHexString(m.getOpCode()).toUpperCase();
        log.debug(txt);
        throw new JmriException(txt);
    }
}

