/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce;

import jmri.NmraPacket;
import jmri.implementation.AbstractLight;
import jmri.jmrix.nce.NceBinaryCommand;
import jmri.jmrix.nce.NceLightManager;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceLight
extends AbstractLight {
    transient NceTrafficController tc;
    NceLightManager mgr;
    int mBit = 0;
    private static final Logger log = LoggerFactory.getLogger(NceLight.class);

    public NceLight(String systemName, NceTrafficController tc, NceLightManager mgr) {
        super(systemName);
        this.tc = tc;
        this.mgr = mgr;
        this.initializeLight(systemName);
    }

    public NceLight(String systemName, String userName, NceTrafficController tc, NceLightManager mgr) {
        super(systemName, userName);
        this.tc = tc;
        this.mgr = mgr;
        this.initializeLight(systemName);
    }

    private void initializeLight(String systemName) {
        this.mBit = this.mgr.getBitFromSystemName(systemName);
        this.setState(4);
    }

    @Override
    protected void doNewState(int oldState, int newState) {
        boolean state = true;
        if (newState == 4) {
            state = false;
        }
        if (this.tc.getCommandOptions() >= 20) {
            byte[] bl = NceBinaryCommand.accDecoder(this.mBit, state);
            if (log.isDebugEnabled()) {
                log.debug("Command: {} {} {} {} {}", new Object[]{Integer.toHexString(0xFF & bl[0]), Integer.toHexString(0xFF & bl[1]), Integer.toHexString(0xFF & bl[2]), Integer.toHexString(0xFF & bl[3]), Integer.toHexString(0xFF & bl[4])});
            }
            NceMessage m = NceMessage.createBinaryMessage(this.tc, bl);
            this.tc.sendNceMessage(m, null);
        } else {
            byte[] bl = NmraPacket.accDecoderPkt(this.mBit, state);
            if (log.isDebugEnabled()) {
                log.debug("packet: {} {} {}", new Object[]{Integer.toHexString(0xFF & bl[0]), Integer.toHexString(0xFF & bl[1]), Integer.toHexString(0xFF & bl[2])});
            }
            NceMessage m = NceMessage.sendPacketMessage(this.tc, bl);
            this.tc.sendNceMessage(m, null);
        }
    }
}

