/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce;

import jmri.Consist;
import jmri.DccLocoAddress;
import jmri.LocoAddress;
import jmri.implementation.AbstractConsistManager;
import jmri.jmrix.ConnectionStatus;
import jmri.jmrix.JmrixConfigPane;
import jmri.jmrix.nce.NceConsist;
import jmri.jmrix.nce.NceSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceConsistManager
extends AbstractConsistManager {
    private NceSystemConnectionMemo memo = null;
    private static final Logger log = LoggerFactory.getLogger(NceConsistManager.class);

    public NceConsistManager(NceSystemConnectionMemo m) {
        this.memo = m;
    }

    @Override
    public void requestUpdateFromLayout() {
        if (this.shouldRequestUpdateFromLayout()) {
            this.startConsistReader();
        }
    }

    @Override
    public boolean isCommandStationConsistPossible() {
        return false;
    }

    @Override
    public boolean csConsistNeedsSeperateAddress() {
        return false;
    }

    @Override
    public Consist addConsist(LocoAddress locoAddress) {
        if (!(locoAddress instanceof DccLocoAddress)) {
            throw new IllegalArgumentException("locoAddress is not a DccLocoAddress object");
        }
        if (this.consistTable.containsKey(locoAddress)) {
            return (Consist)this.consistTable.get(locoAddress);
        }
        log.debug("Add consist, address {}", (Object)locoAddress);
        NceConsist consist = new NceConsist((DccLocoAddress)locoAddress, this.memo);
        this.consistTable.put(locoAddress, consist);
        return consist;
    }

    private void addConsist(NceConsist consist) {
        log.debug("Add consist {}", (Object)consist.getConsistAddress());
        this.consistTable.put(consist.getConsistAddress(), consist);
    }

    @Override
    public Consist getConsist(LocoAddress locoAddress) {
        log.debug("Requesting NCE consist {}", (Object)locoAddress);
        NceConsist consist = (NceConsist)super.getConsist(locoAddress);
        return consist;
    }

    @Override
    public void delConsist(LocoAddress locoAddress) {
        NceConsist consist = (NceConsist)this.getConsist(locoAddress);
        consist.dispose();
        super.delConsist(locoAddress);
    }

    public void startConsistReader() {
        if (this.memo.getNceUsbSystem() == 0 && !this.memo.getNceTrafficController().getPortName().equals(JmrixConfigPane.NONE_SELECTED) && this.memo.getNceTrafficController().getCommandOptions() > 0) {
            new NceConsistReader().start();
        }
    }

    static /* synthetic */ NceSystemConnectionMemo access$0(NceConsistManager nceConsistManager) {
        return nceConsistManager.memo;
    }

    static /* synthetic */ Logger access$1() {
        return log;
    }

    static /* synthetic */ void access$2(NceConsistManager nceConsistManager, NceConsist nceConsist) {
        nceConsistManager.addConsist(nceConsist);
    }

    public class NceConsistReader
    extends Thread {
        int _consistNum = 127;

        NceConsistReader() {
            this.setName("Initialize NCE consists");
        }

        @Override
        public void run() {
            this.searchNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void searchNext() {
            var1_1 = this;
            synchronized (var1_1) {
                while (true) {
                    while (true) {
                        block16: {
                            if (!ConnectionStatus.instance().getConnectionState(NceConsistManager.access$0(NceConsistManager.this).getUserName(), NceConsistManager.access$0(NceConsistManager.this).getNceTrafficController().getPortName()).equals("Connected")) break block16;
                            // MONITOREXIT @DISABLED, blocks:[0, 4, 10, 11] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
                            if (true) ** GOTO lbl38
                        }
                        NceConsistManager.access$1().debug("Waiting for NCE connected");
                        try {
                            this.wait(2000L);
                        }
                        catch (InterruptedException v0) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    break;
                }
                catch (Throwable v1) {
                    throw v1;
                }
            }
            do {
                if (NceConsistManager.access$1().isDebugEnabled()) {
                    NceConsistManager.access$1().debug("Reading consist from command station: {}", (Object)this._consistNum);
                }
                consist = new NceConsist(this._consistNum, NceConsistManager.access$0(NceConsistManager.this));
                while (!consist.isValid()) {
                    var2_2 = this;
                    synchronized (var2_2) {
                        try {
                            this.wait(100L);
                        }
                        catch (InterruptedException v2) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                if (consist.getConsistList().size() > 0) {
                    NceConsistManager.access$2(NceConsistManager.this, consist);
                }
                --this._consistNum;
lbl38:
                // 2 sources

            } while (this._consistNum >= 1);
            NceConsistManager.this.notifyConsistListChanged();
        }
    }
}

