/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce;

import javax.swing.JOptionPane;
import jmri.jmrix.ConnectionStatus;
import jmri.jmrix.nce.NceListener;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceReply;
import jmri.jmrix.nce.NceTrafficController;
import jmri.jmrix.nce.serialdriver.ConnectionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceConnectionStatus
implements NceListener {
    private static final boolean JOptPane_ERROR_MESSAGES_ENABLED = true;
    private static final boolean JOptPane_WARNING_MESSAGES_ENABLED = false;
    private static final int INIT_STATE = 0;
    private static final int WAIT_STATE = 1;
    private static final int CHECK_STATE = 2;
    private static final int CHECK_OK = 3;
    private static final int NORMAL_STATE = 4;
    private static final int WARN1_STATE = 8;
    private static final int WARN2_STATE = 9;
    private static final int ERROR1_STATE = 16;
    private static final int ERROR2_STATE = 17;
    private static final int ERROR4_STATE = 19;
    private static final int ERROR5_STATE = 20;
    private static final int ERROR6_STATE = 21;
    private static final int ERROR7_STATE = 22;
    private static final int ERROR8_STATE = 23;
    private int epromState = 0;
    private boolean epromChecked = false;
    private static final int VV_1999 = 4;
    private static final int MM_1999 = 0;
    private static final int mm_1999 = 1;
    private static final int VV_2004 = 6;
    private static final int MM_2004 = 0;
    private static final int mm_2004 = 0;
    private static final int VV_2007 = 6;
    private static final int MM_2007 = 2;
    private static final int mm_2007 = 0;
    private static final int mm_2007a = 1;
    private static final int mm_2008 = 2;
    private static final int mm_2021 = 3;
    private static final int VV_2012 = 7;
    private static final int MM_2012 = 2;
    private static final int VV_USB_V6 = 6;
    private static final int VV_USB_V7 = 7;
    private static final int MM_USB = 3;
    private static final int mm_USB_V6_PwrCab = 0;
    private static final int mm_USB_V6_SB3 = 1;
    private static final int mm_USB_V6_PH = 2;
    private static final int mm_USB_V6_ALL = 3;
    private static final int mm_USB_V6_PC161 = 4;
    private static final int mm_USB_V6_SB161 = 5;
    private static final int mm_USB_V7_PC_128_A = 0;
    private static final int mm_USB_V7_SB5_165_A = 1;
    private static final int mm_USB_V7_SB5_165_B = 2;
    private static final int mm_USB_V7_PC_165 = 3;
    private static final int mm_USB_V7_PC_128_B = 4;
    private static final int mm_USB_V7_SB3 = 5;
    private static final int mm_USB_V7_PH = 6;
    private static final int mm_USB_V7_ALL = 7;
    private NceTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(NceConnectionStatus.class);

    public NceConnectionStatus(NceTrafficController tc) {
        this.tc = tc;
    }

    public NceMessage nceEpromPoll() {
        if (this.tc.getCommandOptions() <= 0) {
            return null;
        }
        if (this.epromState == 4) {
            if (this.tc.hasTimeouts()) {
                this.epromState = 0;
            } else {
                return null;
            }
        }
        if (this.epromState == 2) {
            if (this.tc.getCommandOptions() > 10) {
                return NceMessage.sendLocoCmd(this.tc, 0, (byte)0, (byte)0);
            }
            this.epromState = 3;
        }
        if (this.epromState == 3) {
            ConnectionStatus.instance().setConnectionState(this.tc.getUserName(), this.tc.getPortName(), "Connected");
            this.epromState = 4;
            return null;
        }
        if (this.epromState != 0) {
            ConnectionStatus.instance().setConnectionState(this.tc.getUserName(), this.tc.getPortName(), "Not Connected");
        }
        if (this.epromState == 1) {
            log.warn("Incorrect or no response from NCE command station");
            this.epromState = 8;
        } else if (this.epromState == 8) {
            log.warn("No response from NCE command station");
        }
        if (this.epromState == 16) {
            JOptionPane.showMessageDialog(null, "Wrong revision of Command Station EPROM selected in Preferences \nChange the Command Station EPROM selection to \"2004 or earlier\"", "Error", 0);
            this.epromState = 4;
            return null;
        }
        if (this.epromState == 17) {
            JOptionPane.showMessageDialog(null, "Wrong revision of Command Station EPROM selected in Preferences \nChange the Command Station EPROM selection to \"2006 or later\"", "Error", 0);
            this.epromState = 4;
            return null;
        }
        if (this.epromState == 9) {
            log.warn("Detected 2007 March EPROM which doesn't provide reliable MONITORING feedback for turnouts");
            ConnectionStatus.instance().setConnectionState(this.tc.getUserName(), this.tc.getPortName(), "Connected");
            this.epromState = 4;
            return null;
        }
        if (this.epromState == 19) {
            JOptionPane.showMessageDialog(null, "Wrong NCE System Connection selected in Preferences. Change the System Connection to \"" + ConnectionConfig.NAME + "\" or \"" + "Network Interface" + "\".", "Error", 0);
            this.epromState = 4;
            return null;
        }
        if (this.epromState == 20) {
            JOptionPane.showMessageDialog(null, "Wrong NCE System Connection selected in Preferences. The System Connection \"NCE USB\" should change the system to \"Power Cab\".", "Error", 0);
            this.epromState = 4;
            return null;
        }
        if (this.epromState == 21) {
            JOptionPane.showMessageDialog(null, "Wrong NCE System Connection selected in Preferences. The System Connection \"NCE USB\" should change the system to \"Smart Booster SB3\".", "Error", 0);
            this.epromState = 4;
            return null;
        }
        if (this.epromState == 22) {
            JOptionPane.showMessageDialog(null, "Wrong NCE System Connection selected in Preferences. The System Connection \"NCE USB\" should change the system to \"Power Pro\".", "Error", 0);
            this.epromState = 4;
            return null;
        }
        if (this.epromState == 23) {
            JOptionPane.showMessageDialog(null, "Wrong NCE System Connection selected in Preferences. The System Connection \"NCE USB\" should change the system to \"SB5\".", "Error", 0);
            this.epromState = 4;
            return null;
        }
        if (this.epromState != 8) {
            this.epromState = 1;
        }
        return NceMessage.getEpromVersion(this.tc);
    }

    @Override
    public void message(NceMessage m) {
        if (log.isDebugEnabled()) {
            log.debug("unexpected message");
        }
    }

    @Override
    public void reply(NceReply r) {
        if (r.getNumDataElements() == 1 && this.epromState == 2) {
            if (r.getElement(0) == NceMessage.NCE_OKAY) {
                log.info("Connected to NCE command station");
                this.epromState = 3;
            } else {
                log.warn("Not connected to NCE command station");
                this.epromState = 0;
            }
        } else if (r.getNumDataElements() == 3) {
            byte VV = (byte)r.getElement(0);
            byte MM = (byte)r.getElement(1);
            byte mm = (byte)r.getElement(2);
            this.tc.setPwrProVers(VV, MM, mm);
            if (VV != 7 && VV != 6 && VV != 4) {
                log.error("Wrong major revision: {}", (Object)Integer.toHexString(VV & 0xFF));
                log.info("NCE EPROM revision = {}", (Object)this.tc.getPwrProVersHexText());
                return;
            }
            this.epromState = 2;
            if (!this.epromChecked) {
                this.checkEPROM(VV, MM, mm);
                this.epromChecked = true;
            }
        } else {
            log.warn("wrong number of read bytes for revision check");
        }
    }

    private void checkEPROM(byte VV, byte MM, byte mm) {
        boolean eprom2007orNewer;
        log.info("NCE EPROM revision = {}", (Object)this.tc.getPwrProVersHexText());
        if (VV == 6 && MM == 2 && mm == 0) {
            this.tc.setNceEpromMarch2007(true);
            this.epromState = 9;
        }
        if (VV == 6 && MM == 2 && mm >= 3) {
            this.tc.setPwrProVer060203orLater(true);
        }
        if (VV <= 6 && MM < 2 && this.tc.getCommandOptions() >= 20) {
            log.error("Wrong revision ({}) of the NCE Command Station EPROM selected in Preferences", (Object)this.tc.getPwrProVersHexText());
            this.epromState = 16;
        }
        boolean bl = eprom2007orNewer = VV == 6 && MM >= 2;
        if ((VV > 6 || eprom2007orNewer) && this.tc.getCommandOptions() < 20) {
            log.error("Wrong revision ({}) of the NCE Command Station EPROM selected in Preferences", (Object)this.tc.getPwrProVersHexText());
            this.epromState = 17;
        }
        if ((VV == 4 || VV == 6 && MM == 0 || VV == 6 && MM == 2 || VV == 7 && MM == 2) && this.tc.getUsbSystem() != 0) {
            log.error("System Connection is incorrect, detected Power Pro");
            this.epromState = 19;
        }
        if (VV == 6 && MM == 3) {
            if (mm == 0 && this.tc.getUsbSystem() != 1) {
                log.error("System Connection is incorrect, detected USB connected to a PowerCab");
                this.epromState = 20;
            }
            if (mm == 1 && this.tc.getUsbSystem() != 2) {
                log.error("System Connection is incorrect, detected USB connected to a Smart Booster SB3");
                this.epromState = 21;
            }
            if (mm == 2 && this.tc.getUsbSystem() != 3) {
                log.error("System Connection is incorrect, detected USB connected to a Power Pro");
                this.epromState = 22;
            }
        }
        if (VV == 7 && MM == 3) {
            if ((mm == 0 || mm == 4) && this.tc.getUsbSystem() != 1) {
                log.error("System Connection is incorrect, detected USB connected to a PowerCab");
                this.epromState = 20;
            }
            if (mm == 5 && this.tc.getUsbSystem() != 2) {
                log.error("System Connection is incorrect, detected USB connected to a Smart Booster SB3");
                this.epromState = 21;
            }
            if (mm == 6 && this.tc.getUsbSystem() != 3) {
                log.error("System Connection is incorrect, detected USB connected to a Power Pro");
                this.epromState = 22;
            }
            if ((mm == 1 || mm == 2) && this.tc.getUsbSystem() != 5) {
                log.error("System Connection is incorrect, detected USB connected to a Smart Booster SB5");
                this.epromState = 23;
            }
        }
    }
}

