/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce;

import javax.swing.JOptionPane;
import jmri.jmrix.ConnectionStatus;
import jmri.jmrix.nce.NceBinaryCommand;
import jmri.jmrix.nce.NceListener;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceReply;
import jmri.jmrix.nce.NceTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceAIUChecker
implements NceListener {
    private static final int MEM_AIU = 56341;
    private static final int REPLY_LEN = 1;
    private boolean EXPECT_REPLY = false;
    private NceTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(NceAIUChecker.class);

    public NceAIUChecker(NceTrafficController t) {
        this.tc = t;
    }

    public NceMessage nceAiuPoll() {
        if (this.tc.getCommandOptions() <= 0) {
            return null;
        }
        if (this.tc.getUsbSystem() != 0) {
            return null;
        }
        byte[] bl = NceBinaryCommand.accMemoryRead1(56341);
        NceMessage m = NceMessage.createBinaryMessage(this.tc, bl, 1);
        this.EXPECT_REPLY = true;
        return m;
    }

    @Override
    public void message(NceMessage m) {
        if (log.isDebugEnabled()) {
            log.debug("unexpected message");
        }
    }

    @Override
    public void reply(NceReply r) {
        if (!this.EXPECT_REPLY && log.isDebugEnabled()) {
            log.debug("Unexpected reply in AIU broadcast checker");
            return;
        }
        this.EXPECT_REPLY = false;
        if (r.getNumDataElements() == 1) {
            byte AIUstatus = (byte)r.getElement(0);
            if (AIUstatus > 1) {
                log.warn("AIU check broadcast return value is out of range");
            }
            if (AIUstatus == 1) {
                log.warn("AIU broadcasts are enabled");
                ConnectionStatus.instance().setConnectionState(this.tc.getUserName(), this.tc.getPortName(), "Not Connected");
                JOptionPane.showMessageDialog(null, "JMRI has detected that AIU broadcasts are enabled. \nYou must disable AIU broadcasts for proper operation of this program. \nFor more information, see Setup Command Station in your NCE System Reference Manual.", "Warning", 1);
            }
        } else {
            log.warn("wrong number of read bytes for revision check");
        }
    }
}

