/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce;

import jmri.JmriException;
import jmri.Sensor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceAIU {
    Sensor[] sensorArray = new Sensor[15];
    int[] sensorLastSetting = new int[15];
    int lastAIUValue = 49152;
    private static final Logger log = LoggerFactory.getLogger(NceAIU.class);

    public NceAIU() {
        int i = 0;
        while (i < 15) {
            this.sensorArray[i] = null;
            this.sensorLastSetting[i] = 1;
            ++i;
        }
    }

    public void markChanges(int bits) {
        if (bits != this.lastAIUValue) {
            if (log.isDebugEnabled()) {
                log.debug("sensor array change from {} to {}", (Object)Integer.toHexString(this.lastAIUValue), (Object)Integer.toHexString(bits));
            }
            this.lastAIUValue = bits;
            int i = 0;
            while (i < 14) {
                if (this.sensorArray[i] != null) {
                    boolean value = (bits & 1) == 0 ^ this.sensorArray[i].getInverted();
                    if (value) {
                        this.sensorChange(i, 2);
                    } else {
                        this.sensorChange(i, 4);
                    }
                }
                bits /= 2;
                ++i;
            }
        }
    }

    public void sensorChange(int offset, int newState) {
        if (this.sensorArray[offset] != null && this.sensorLastSetting[offset] != newState) {
            this.sensorLastSetting[offset] = newState;
            if (log.isDebugEnabled()) {
                String newStateStr = "Active";
                if (newState == 4) {
                    newStateStr = "Inactive";
                }
                log.debug("setting sensor {}: {}", (Object)this.sensorArray[offset].getSystemName(), (Object)newStateStr);
            }
            try {
                this.sensorArray[offset].setKnownState(newState);
            }
            catch (JmriException e) {
                log.error("exception in sensorChange: {}", (Throwable)e);
            }
        }
    }

    public void registerSensor(Sensor s, int i) {
        this.sensorArray[i] = s;
    }

    public Sensor getSensor(int index) {
        return this.sensorArray[index];
    }
}

