/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mrc.swing.packetgen;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrix.mrc.MrcMessage;
import jmri.jmrix.mrc.MrcSystemConnectionMemo;
import jmri.jmrix.mrc.MrcTrafficController;
import jmri.jmrix.mrc.swing.MrcNamedPaneAction;
import jmri.jmrix.mrc.swing.MrcPanel;
import jmri.jmrix.mrc.swing.packetgen.Bundle;
import jmri.util.StringUtil;
import jmri.util.swing.sdi.JmriJFrameInterface;

public class MrcPacketGenPanel
extends MrcPanel {
    JLabel jLabel1 = new JLabel();
    JButton sendButton = new JButton();
    JTextField packetTextField = new JTextField(20);
    private MrcTrafficController tc = null;

    @Override
    public void initContext(Object context) {
        if (context instanceof MrcSystemConnectionMemo) {
            this.initComponents((MrcSystemConnectionMemo)context);
        }
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.mrc.swing.packetgen.MrcPacketGenPanel";
    }

    @Override
    public String getTitle() {
        StringBuilder x = new StringBuilder();
        if (this.memo != null) {
            x.append(this.memo.getUserName());
        } else {
            x.append("MRC_");
        }
        x.append(": ");
        x.append(Bundle.getMessage("Title"));
        return x.toString();
    }

    @Override
    public void initComponents(MrcSystemConnectionMemo m) {
        this.memo = m;
        this.tc = m.getMrcTrafficController();
        this.jLabel1.setText(Bundle.getMessage("MrcPacketGenLabelCommand"));
        this.jLabel1.setVisible(true);
        this.sendButton.setText(Bundle.getMessage("MrcPacketGenButtonSend"));
        this.sendButton.setVisible(true);
        this.sendButton.setToolTipText(Bundle.getMessage("MrcPacketGenTipSend"));
        this.packetTextField.setText("");
        this.packetTextField.setToolTipText(Bundle.getMessage("MrcPacketGenTipText"));
        this.packetTextField.setMaximumSize(new Dimension(this.packetTextField.getMaximumSize().width, this.packetTextField.getPreferredSize().height));
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.jLabel1);
        this.add(this.packetTextField);
        this.add(this.sendButton);
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MrcPacketGenPanel.this.sendButtonActionPerformed(e);
            }
        });
    }

    public void sendButtonActionPerformed(ActionEvent e) {
        String input = this.packetTextField.getText();
        MrcMessage m = new MrcMessage(input.length());
        int i = 0;
        while (i < input.length()) {
            m.setElement(i, input.charAt(i));
            ++i;
        }
        this.tc.sendMrcMessage(m);
    }

    MrcMessage createPacket(String s) {
        byte[] b;
        try {
            b = StringUtil.bytesFromHexString(s);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        if (b.length == 0) {
            return null;
        }
        MrcMessage m = new MrcMessage(b.length);
        int i = 0;
        while (i < b.length) {
            m.setElement(i, b[i]);
            ++i;
        }
        return m;
    }

    public static class Default
    extends MrcNamedPaneAction {
        public Default() {
            super("Open MRC Send Binary Command", new JmriJFrameInterface(), MrcPacketGenPanel.class.getName(), InstanceManager.getDefault(MrcSystemConnectionMemo.class));
        }
    }
}

