/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mrc.swing.monitor;

import java.util.Date;
import javax.swing.JCheckBox;
import jmri.InstanceManager;
import jmri.jmrix.AbstractMonPane;
import jmri.jmrix.mrc.MrcMessage;
import jmri.jmrix.mrc.MrcSystemConnectionMemo;
import jmri.jmrix.mrc.MrcTrafficListener;
import jmri.jmrix.mrc.swing.MrcNamedPaneAction;
import jmri.jmrix.mrc.swing.MrcPanelInterface;
import jmri.jmrix.mrc.swing.monitor.Bundle;
import jmri.util.StringUtil;
import jmri.util.swing.sdi.JmriJFrameInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MrcMonPanel
extends AbstractMonPane
implements MrcTrafficListener,
MrcPanelInterface {
    MrcSystemConnectionMemo memo;
    JCheckBox includePoll = new JCheckBox(Bundle.getMessage("MrcMonPanelCheckIncPoll"));
    private int trafficFilter = -1;
    MrcMessage previousPollMessage;
    Date previousTimeStamp;
    private static final Logger log = LoggerFactory.getLogger(MrcMonPanel.class);

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.mrc.swing.monitor.MrcMonPanel";
    }

    @Override
    public String getTitle() {
        return Bundle.getMessage("MrcMonPanelName");
    }

    @Override
    public void dispose() {
        if (this.memo.getMrcTrafficController() != null) {
            this.memo.getMrcTrafficController().removeTrafficListener(this.trafficFilter, this);
        }
        super.dispose();
    }

    @Override
    public void init() {
    }

    @Override
    public void initContext(Object context) {
        if (context instanceof MrcSystemConnectionMemo) {
            this.initComponents((MrcSystemConnectionMemo)context);
        }
    }

    @Override
    public void initComponents(MrcSystemConnectionMemo memo) {
        this.memo = memo;
        this.add(this.includePoll);
        if (memo.getMrcTrafficController() == null) {
            log.error("No traffic controller is available");
            return;
        }
        memo.getMrcTrafficController().addTrafficListener(this.trafficFilter, this);
    }

    @Override
    public synchronized void notifyXmit(Date timestamp, MrcMessage m) {
        if (!this.includePoll.isSelected() && (m.getMessageClass() & 0x40) == 64) {
            return;
        }
        this.logMessage(timestamp, m, Bundle.getMessage("MrcMonPanelTextXmit"));
    }

    @Override
    public synchronized void notifyFailedXmit(Date timestamp, MrcMessage m) {
        this.logMessage(timestamp, m, Bundle.getMessage("MrcMonPanelTextFailed"));
    }

    @Override
    public synchronized void notifyRcv(Date timestamp, MrcMessage m) {
        String prefix = Bundle.getMessage("MrcMonPanelTextRecv");
        if (!this.includePoll.isSelected() && (m.getMessageClass() & 0x40) == 64 && m.getElement(1) == 1) {
            this.previousPollMessage = m;
            return;
        }
        if (this.previousPollMessage != null) {
            if ((m.getMessageClass() & 0x40) == 64) {
                this.previousPollMessage = null;
                return;
            }
            prefix = Bundle.getMessage("MrcMonPanelTextRxCab", Integer.toString(this.previousPollMessage.getElement(0)));
            this.previousPollMessage = null;
        }
        this.logMessage(timestamp, m, prefix);
    }

    private void logMessage(Date timestamp, MrcMessage m, String src) {
        String raw = "";
        int i = 0;
        while (i < m.getNumDataElements()) {
            if (i > 0) {
                raw = String.valueOf(raw) + " ";
            }
            raw = StringUtil.appendTwoHexFromInt(m.getElement(i) & 0xFF, raw);
            ++i;
        }
        this.nextLineWithTime(timestamp, String.valueOf(src) + " " + m.toString() + "\n", raw);
    }

    public static class Default
    extends MrcNamedPaneAction {
        public Default() {
            super("Mrc Command Monitor", new JmriJFrameInterface(), MrcMonPanel.class.getName(), InstanceManager.getDefault(MrcSystemConnectionMemo.class));
        }
    }
}

