/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mrc;

import java.util.Date;
import jmri.implementation.AbstractTurnout;
import jmri.jmrix.mrc.MrcMessage;
import jmri.jmrix.mrc.MrcTrafficController;
import jmri.jmrix.mrc.MrcTrafficListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MrcTurnout
extends AbstractTurnout
implements MrcTrafficListener {
    int _number;
    MrcTrafficController tc = null;
    String prefix = "";
    private static final Logger log = LoggerFactory.getLogger(MrcTurnout.class);

    public MrcTurnout(int number, MrcTrafficController tc, String p) {
        super(String.valueOf(p) + "T" + number);
        this._number = number;
        if (this._number < 1 || this._number > 2044) {
            throw new IllegalArgumentException("Turnout value: " + this._number + " not in the range " + 1 + " to " + 2044);
        }
        this.tc = tc;
        this.prefix = String.valueOf(p) + "T";
        tc.addTrafficListener(4, this);
    }

    public int getNumber() {
        return this._number;
    }

    @Override
    public boolean canInvert() {
        return true;
    }

    @Override
    protected void forwardCommandChangeToLayout(int newState) {
        if ((newState & 2) != 0) {
            if ((newState & 4) != 0) {
                log.error("Cannot command both CLOSED and THROWN {}", (Object)newState);
                return;
            }
            this.forwardToCommandStation(!this.getInverted());
        } else {
            this.forwardToCommandStation(this.getInverted());
        }
    }

    void forwardToCommandStation(boolean state) {
        MrcMessage m = null;
        m = this._number < 1000 ? MrcMessage.getSwitchMsg(this._number, state) : MrcMessage.getRouteMsg(this._number - 1000, state);
        this.tc.sendMrcMessage(m);
    }

    @Override
    public void notifyRcv(Date timestamp, MrcMessage m) {
        if (m.getMessageClass() != 4) {
            return;
        }
        if (m.getAccAddress() != this.getNumber()) {
            if (m.getElement(0) == 195 && m.getElement(4) + 1000 == this.getNumber()) {
                if (m.getElement(6) == 0) {
                    this.newKnownState(4);
                } else if (m.getElement(6) == 128) {
                    this.newKnownState(2);
                } else {
                    this.newKnownState(1);
                }
            }
            return;
        }
        this.newKnownState(m.getAccState());
    }

    @Override
    public void notifyXmit(Date timestamp, MrcMessage m) {
    }

    @Override
    public void notifyFailedXmit(Date timestamp, MrcMessage m) {
    }

    @Override
    protected void turnoutPushbuttonLockout(boolean pushButtonLockout) {
    }
}

