/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mrc;

import java.util.Date;
import java.util.Vector;
import jmri.jmrix.mrc.MrcInterface;
import jmri.jmrix.mrc.MrcMessage;
import jmri.jmrix.mrc.MrcSystemConnectionMemo;
import jmri.jmrix.mrc.MrcTrafficListener;
import jmri.jmrix.mrc.MrcTrafficListenerFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MrcTrafficController
implements MrcInterface {
    int cabAddress = 0;
    protected Vector<MrcTrafficListenerFilter> trafficListeners = new Vector();
    protected int receivedMsgCount = 0;
    protected int receivedByteCount = 0;
    protected int transmittedMsgCount = 0;
    MrcSystemConnectionMemo adaptermemo;
    private static final Logger log = LoggerFactory.getLogger(MrcTrafficController.class);

    public void setCabNumber(int x) {
        this.cabAddress = x;
    }

    public int getCabNumber() {
        return this.cabAddress;
    }

    @Override
    public abstract boolean status();

    @Override
    public abstract void sendMrcMessage(MrcMessage var1);

    @Override
    public synchronized void addTrafficListener(int mask, MrcTrafficListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        MrcTrafficListenerFilter adapter = new MrcTrafficListenerFilter(mask, l);
        if (!this.trafficListeners.contains(adapter)) {
            this.trafficListeners.addElement(adapter);
        }
    }

    @Override
    public synchronized void removeTrafficListener(int mask, MrcTrafficListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        MrcTrafficListenerFilter filter = new MrcTrafficListenerFilter(mask, l);
        if (this.trafficListeners.contains(filter)) {
            this.trafficListeners.remove(this.trafficListeners.indexOf(filter)).setFilter(mask);
        }
    }

    @Override
    public synchronized void changeTrafficListener(int mask, MrcTrafficListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        MrcTrafficListenerFilter filter = new MrcTrafficListenerFilter(mask, l);
        if (this.trafficListeners.contains(filter)) {
            this.trafficListeners.get(this.trafficListeners.indexOf(filter)).setFilter(mask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRcv(Date timestamp, MrcMessage m) {
        Vector v;
        MrcTrafficController mrcTrafficController = this;
        synchronized (mrcTrafficController) {
            v = (Vector)this.trafficListeners.clone();
        }
        if (log.isDebugEnabled()) {
            log.debug("notify of incoming Mrc packet: {}", (Object)m.toString());
        }
        for (MrcTrafficListenerFilter adapter : v) {
            adapter.fireRcv(timestamp, m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyXmit(Date timestamp, MrcMessage m) {
        Vector v;
        MrcTrafficController mrcTrafficController = this;
        synchronized (mrcTrafficController) {
            v = (Vector)this.trafficListeners.clone();
        }
        if (log.isDebugEnabled()) {
            log.debug("notify of send Mrc packet: {}", (Object)m.toString());
        }
        for (MrcTrafficListenerFilter adapter : v) {
            adapter.fireXmit(timestamp, m);
        }
    }

    public abstract boolean isXmtBusy();

    public void resetStatistics() {
        this.receivedMsgCount = 0;
        this.transmittedMsgCount = 0;
        this.receivedByteCount = 0;
    }

    public int getReceivedMsgCount() {
        return this.receivedMsgCount;
    }

    public int getReceivedByteCount() {
        return this.receivedByteCount;
    }

    public int getTransmittedMsgCount() {
        return this.transmittedMsgCount;
    }

    public MrcSystemConnectionMemo getAdapterMemo() {
        return this.adaptermemo;
    }

    public void setAdapterMemo(MrcSystemConnectionMemo memo) {
        this.adaptermemo = memo;
    }

    public String getUserName() {
        if (this.adaptermemo == null) {
            return "MRC";
        }
        return this.adaptermemo.getUserName();
    }

    public String getSystemPrefix() {
        if (this.adaptermemo == null) {
            return "M";
        }
        return this.adaptermemo.getSystemPrefix();
    }
}

