/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mrc;

import java.util.EnumSet;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.ThrottleListener;
import jmri.jmrix.AbstractThrottleManager;
import jmri.jmrix.mrc.MrcSystemConnectionMemo;
import jmri.jmrix.mrc.MrcThrottle;
import jmri.jmrix.mrc.MrcTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MrcThrottleManager
extends AbstractThrottleManager {
    MrcTrafficController tc = null;
    String prefix = "";
    private static final Logger log = LoggerFactory.getLogger(MrcThrottleManager.class);

    public MrcThrottleManager(MrcSystemConnectionMemo memo) {
        super(memo);
        this.tc = memo.getMrcTrafficController();
        this.prefix = memo.getSystemPrefix();
    }

    @Override
    public void requestThrottleSetup(LocoAddress a, boolean control) {
        if (!(a instanceof DccLocoAddress)) {
            log.error("{} is not a DccLocoAddress", (Object)a);
            this.failedThrottleRequest(a, "LocoAddress " + a + " is not a DccLocoAddress");
            return;
        }
        DccLocoAddress address = (DccLocoAddress)a;
        log.debug("new MrcThrottle for {}", (Object)address);
        this.notifyThrottleKnown(new MrcThrottle((MrcSystemConnectionMemo)this.adapterMemo, address), address);
    }

    @Override
    public boolean canBeLongAddress(int address) {
        return address >= 0 && address <= 10239;
    }

    @Override
    public boolean canBeShortAddress(int address) {
        return address >= 1 && address <= 127;
    }

    @Override
    public boolean addressTypeUnique() {
        return false;
    }

    @Override
    public EnumSet<SpeedStepMode> supportedSpeedModes() {
        return EnumSet.of(SpeedStepMode.NMRA_DCC_128, SpeedStepMode.NMRA_DCC_28);
    }

    @Override
    public boolean disposeThrottle(DccThrottle t, ThrottleListener l) {
        if (super.disposeThrottle(t, l) && t instanceof MrcThrottle) {
            MrcThrottle nct = (MrcThrottle)t;
            nct.throttleDispose();
            return true;
        }
        return false;
    }
}

