/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mrc;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.jmrix.AbstractProgrammer;
import jmri.jmrix.mrc.Bundle;
import jmri.jmrix.mrc.MrcMessage;
import jmri.jmrix.mrc.MrcPackets;
import jmri.jmrix.mrc.MrcSystemConnectionMemo;
import jmri.jmrix.mrc.MrcTrafficListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MrcProgrammer
extends AbstractProgrammer
implements MrcTrafficListener {
    protected MrcSystemConnectionMemo memo;
    int PACKET_TIMEOUT = 5000;
    int PACKET_READTIMEOUT = 650000;
    static final ProgrammingMode AUTOMATICMODE = new ProgrammingMode("Automatic", Bundle.getMessage("MrcAutomaticMode"));
    int progState = 0;
    static final int NOTPROGRAMMING = 0;
    static final int READCOMMANDSENT = 2;
    static final int WRITECOMMANDSENT = 4;
    static final int POMCOMMANDSENT = 6;
    boolean _progRead = false;
    int _val;
    int _cv;
    private ProgListener _usingProgrammer = null;
    private static final Logger log = LoggerFactory.getLogger(MrcProgrammer.class);

    public MrcProgrammer(MrcSystemConnectionMemo memo) {
        this.memo = memo;
        this.SHORT_TIMEOUT = 15000;
        this.LONG_TIMEOUT = 700000;
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        ArrayList<ProgrammingMode> retval = new ArrayList<ProgrammingMode>();
        retval.add(AUTOMATICMODE);
        return retval;
    }

    @Override
    public boolean getCanRead() {
        return true;
    }

    @Override
    public boolean getCanWrite() {
        return true;
    }

    @Override
    public boolean getCanWrite(String cv) {
        return Integer.parseInt(cv) <= 1024;
    }

    @Override
    public synchronized void writeCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        log.debug("writeCV {} listens {}", (Object)CV, (Object)p);
        this.useProgrammer(p);
        this._progRead = false;
        this.progState = 4;
        this._val = val;
        this._cv = CV;
        try {
            this.startShortTimer();
            this.memo.getMrcTrafficController().addTrafficListener(2, this);
            this.memo.getMrcTrafficController().sendMrcMessage(this.progTaskStart(this.getMode(), this._val, this._cv));
        }
        catch (ProgrammerException e) {
            this.progState = 0;
            throw e;
        }
    }

    @Override
    public void confirmCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        this.readCV(CVname, p);
    }

    @Override
    public synchronized void readCV(String CVname, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        log.debug("readCV {} listens {}", (Object)CV, (Object)p);
        this.useProgrammer(p);
        this._progRead = true;
        this.progState = 2;
        this._cv = CV;
        try {
            this.startLongTimer();
            this.memo.getMrcTrafficController().addTrafficListener(2, this);
            this.memo.getMrcTrafficController().sendMrcMessage(this.progTaskStart(this.getMode(), -1, this._cv));
        }
        catch (ProgrammerException e) {
            this.progState = 0;
            throw e;
        }
    }

    protected void useProgrammer(ProgListener p) throws ProgrammerException {
        if (this._usingProgrammer != null && this._usingProgrammer != p) {
            if (log.isInfoEnabled()) {
                log.info("programmer already in use by {}", (Object)this._usingProgrammer);
            }
            throw new ProgrammerException("programmer in use");
        }
        this._usingProgrammer = p;
    }

    protected MrcMessage progTaskStart(ProgrammingMode mode, int val, int cvnum) throws ProgrammerException {
        MrcMessage m = val < 0 ? MrcMessage.getReadCV(cvnum) : MrcMessage.getWriteCV(cvnum, val);
        m.setTimeout(this.PACKET_TIMEOUT);
        m.setSource(this);
        return m;
    }

    @Override
    public synchronized void notifyXmit(Date timestamp, MrcMessage m) {
    }

    @Override
    public synchronized void notifyFailedXmit(Date timestamp, MrcMessage m) {
        if (this.progState == 0 && m.getMessageClass() != 2) {
            return;
        }
        this.timeout();
    }

    @Override
    public synchronized void notifyRcv(Date timestamp, MrcMessage m) {
        if (this.progState == 0) {
            log.debug("reply in NOTPROGRAMMING state");
            return;
        }
        if (m.getMessageClass() != 2) {
            return;
        }
        if (MrcPackets.startsWith(m, MrcPackets.PROGCMDSENT)) {
            this.progState = 0;
            this.notifyProgListenerEnd(this._val, 0);
        } else if (MrcPackets.startsWith(m, MrcPackets.READCVHEADERREPLY) && this.progState == 2) {
            this.progState = 0;
            if (this._progRead) {
                log.debug("prog Read {}", (Object)this._cv);
                this._val = m.value();
            }
            log.debug("Has value {}", (Object)this._val);
            this.notifyProgListenerEnd(this._val, 0);
        } else {
            log.debug("reply in un-decoded state cv:{} {}", (Object)this._cv, (Object)m.toString());
        }
    }

    @Override
    protected synchronized void timeout() {
        if (this.progState != 0) {
            log.debug("timeout!{}", (Object)this._cv);
            this.progState = 0;
            this.cleanup();
            this.notifyProgListenerEnd(this._val, 128);
        }
    }

    void cleanup() {
    }

    protected void notifyProgListenerEnd(int value, int status) {
        log.debug("notifyProgListenerEnd value {} status {}", (Object)value, (Object)status);
        this.memo.getMrcTrafficController().removeTrafficListener(2, this);
        ProgListener temp = this._usingProgrammer;
        this._usingProgrammer = null;
        this.notifyProgListenerEnd(temp, value, status);
    }
}

