/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mrc;

import java.util.Date;
import jmri.JmriException;
import jmri.jmrix.mrc.MrcMessage;
import jmri.jmrix.mrc.MrcSystemConnectionMemo;
import jmri.jmrix.mrc.MrcTrafficController;
import jmri.jmrix.mrc.MrcTrafficListener;
import jmri.managers.AbstractPowerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MrcPowerManager
extends AbstractPowerManager<MrcSystemConnectionMemo>
implements MrcTrafficListener {
    MrcTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(MrcPowerManager.class);

    public MrcPowerManager(MrcSystemConnectionMemo memo) {
        super(memo);
        if (memo.getMrcTrafficController() == null) {
            log.error("PowerManager Created, yet there is no Traffic Controller");
            return;
        }
        this.tc = memo.getMrcTrafficController();
        this.tc.addTrafficListener(16, this);
    }

    @Override
    public void setPower(int v) throws JmriException {
        int old = this.power;
        this.checkTC();
        if (v == 2) {
            MrcMessage l = MrcMessage.setPowerOn();
            this.tc.sendMrcMessage(l);
        } else if (v == 4) {
            MrcMessage l = MrcMessage.setPowerOff();
            this.tc.sendMrcMessage(l);
        }
        this.power = v;
        this.firePowerPropertyChange(old, this.power);
    }

    public boolean isPowerOn() {
        return this.power == 2;
    }

    public boolean isPowerOff() {
        return this.power == 4;
    }

    public boolean isPowerUnknown() {
        return this.power == 1;
    }

    @Override
    public void dispose() {
        if (this.tc != null) {
            this.tc.removeTrafficListener(16, this);
        }
        this.tc = null;
    }

    private void checkTC() throws JmriException {
        if (this.tc == null) {
            throw new JmriException("Use power manager after dispose");
        }
    }

    @Override
    public void notifyRcv(Date timestamp, MrcMessage m) {
    }

    @Override
    public void notifyXmit(Date timestamp, MrcMessage m) {
    }

    @Override
    public void notifyFailedXmit(Date timestamp, MrcMessage m) {
    }
}

