/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mrc;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.text.DecimalFormat;
import jmri.jmrix.mrc.Bundle;
import jmri.jmrix.mrc.MrcMessage;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MrcPackets {
    private static final Logger log = LoggerFactory.getLogger(MrcPackets.class);
    public static final int THROTTLEPACKETCMD = 37;
    static final int[] THROTTLEPACKETHEADER;
    static final int THROTTLEPACKETLENGTH = 10;
    public static final int FUNCTIONGROUP1PACKETCMD = 52;
    static final int[] FUNCTIONGROUP1PACKETHEADER;
    public static final int FUNCTIONGROUP2PACKETCMD = 68;
    static final int[] FUNCTIONGROUP2PACKETHEADER;
    public static final int FUNCTIONGROUP3PACKETCMD = 84;
    static final int[] FUNCTIONGROUP3PACKETHEADER;
    public static final int FUNCTIONGROUP4PACKETCMD = 116;
    static final int[] FUNCTIONGROUP4PACKETHEADER;
    public static final int FUNCTIONGROUP5PACKETCMD = 132;
    static final int[] FUNCTIONGROUP5PACKETHEADER;
    public static final int FUNCTIONGROUP6PACKETCMD = 164;
    static final int[] FUNCTIONGROUP6PACKETHEADER;
    static final int FUNCTIONGROUPLENGTH = 8;
    public static final int ADDTOCONSISTPACKETCMD = 100;
    static final int[] ADDTOCONSISTPACKETHEADER;
    static final int ADDTOCONSISTPACKETLENGTH = 4;
    public static final int CLEARCONSISTPACKETCMD = 98;
    static final int[] CLEARCONSISTPACKETHEADER;
    static final int CLEARCONSISTPACKETLENGTH = 4;
    public static final int ROUTECONTROLPACKETCMD = 195;
    static final int[] ROUTECONTROLPACKETHEADER;
    static final int ROUTECONTROLPACKETLENGTH = 6;
    public static final int CLEARROUTEPACKETCMD = 210;
    static final int[] CLEARROUTEPACKETHEADER;
    static final int CLEARROUTEPACKETLENGTH = 4;
    public static final int ADDTOROUTEPACKETCMD = 211;
    static final int[] ADDTOROUTEPACKETHEADER;
    static final int ADDTOROUTEPACKETLENGTH = 6;
    public static final int ACCESSORYPACKETCMD = 115;
    static final int[] ACCESSORYPACKETHEADER;
    static final int ACCESSORYPACKETLENGTH = 6;
    public static final int WRITECVPOMCMD = 86;
    static final int[] WRITECVPOMHEADER;
    private static final int WRITECVPOMLENGTH = 12;
    public static final int WRITECVPROGCMD = 36;
    static final int[] WRITECVPROGHEADER;
    private static final int WRITECVPROGLENGTH = 8;
    public static final int READDECODERADDRESSCMD = 66;
    static final int[] READDECODERADDRESS;
    public static final int READCVCMD = 67;
    static final int[] READCVHEADER;
    private static final int READCVLENGTH = 6;
    public static final int PROGCMDSENTCODE = 51;
    static final int[] PROGCMDSENT;
    public static final int READCVHEADERREPLYCODE = 102;
    static final int[] READCVHEADERREPLY;
    static final int READCVPACKETLENGTH = 4;
    public static final int SETCLOCKRATIOCMD = 18;
    static final int[] SETCLOCKRATIOHEADER;
    private static final int SETCLOCKRATIOLENGTH = 4;
    public static final int SETCLOCKTIMECMD = 19;
    static final int[] SETCLOCKTIMEHEADER;
    private static final int SETCLOCKTIMELENGTH = 6;
    public static final int SETCLOCKAMPMCMD = 50;
    static final int[] SETCLOCKAMPMHEADER;
    private static final int SETCLOCKAMPMLENGTH = 4;
    public static final int LOCOSOLECONTROLCODE = 34;
    static final int[] LOCOSOLECONTROL;
    public static final int LOCODBLCONTROLCODE = 221;
    static final int[] LOCODBLCONTROL;
    public static final int GOODCMDRECEIVEDCODE = 85;
    static final int[] GOODCMDRECEIVED;
    public static final int BADCMDRECEIVEDCODE = 238;
    static final int[] BADCMDRECEIVED;
    public static final int POWERONCMD = 130;
    static final int[] POWERON;
    public static final int POWEROFFCMD = 146;
    static final int[] POWEROFF;
    private static final DecimalFormat TWO_DIGITS;
    private static final String TXT_ON;
    private static final String TXT_OFF;

    static {
        int[] nArray = new int[4];
        nArray[0] = 37;
        nArray[2] = 37;
        THROTTLEPACKETHEADER = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 52;
        nArray2[2] = 52;
        FUNCTIONGROUP1PACKETHEADER = nArray2;
        int[] nArray3 = new int[4];
        nArray3[0] = 68;
        nArray3[2] = 68;
        FUNCTIONGROUP2PACKETHEADER = nArray3;
        int[] nArray4 = new int[4];
        nArray4[0] = 84;
        nArray4[2] = 84;
        FUNCTIONGROUP3PACKETHEADER = nArray4;
        int[] nArray5 = new int[4];
        nArray5[0] = 116;
        nArray5[2] = 116;
        FUNCTIONGROUP4PACKETHEADER = nArray5;
        int[] nArray6 = new int[4];
        nArray6[0] = 132;
        nArray6[2] = 132;
        FUNCTIONGROUP5PACKETHEADER = nArray6;
        int[] nArray7 = new int[4];
        nArray7[0] = 164;
        nArray7[2] = 164;
        FUNCTIONGROUP6PACKETHEADER = nArray7;
        int[] nArray8 = new int[4];
        nArray8[0] = 100;
        nArray8[2] = 100;
        ADDTOCONSISTPACKETHEADER = nArray8;
        int[] nArray9 = new int[4];
        nArray9[0] = 98;
        nArray9[2] = 98;
        CLEARCONSISTPACKETHEADER = nArray9;
        int[] nArray10 = new int[4];
        nArray10[0] = 195;
        nArray10[2] = 195;
        ROUTECONTROLPACKETHEADER = nArray10;
        int[] nArray11 = new int[4];
        nArray11[0] = 210;
        nArray11[2] = 210;
        CLEARROUTEPACKETHEADER = nArray11;
        int[] nArray12 = new int[4];
        nArray12[0] = 211;
        nArray12[2] = 211;
        ADDTOROUTEPACKETHEADER = nArray12;
        int[] nArray13 = new int[4];
        nArray13[0] = 115;
        nArray13[2] = 115;
        ACCESSORYPACKETHEADER = nArray13;
        int[] nArray14 = new int[4];
        nArray14[0] = 86;
        nArray14[2] = 86;
        WRITECVPOMHEADER = nArray14;
        int[] nArray15 = new int[4];
        nArray15[0] = 36;
        nArray15[2] = 36;
        WRITECVPROGHEADER = nArray15;
        int[] nArray16 = new int[6];
        nArray16[0] = 66;
        nArray16[2] = 66;
        nArray16[4] = 66;
        READDECODERADDRESS = nArray16;
        int[] nArray17 = new int[4];
        nArray17[0] = 67;
        nArray17[2] = 67;
        READCVHEADER = nArray17;
        int[] nArray18 = new int[4];
        nArray18[0] = 51;
        nArray18[2] = 51;
        PROGCMDSENT = nArray18;
        int[] nArray19 = new int[4];
        nArray19[0] = 102;
        nArray19[2] = 102;
        READCVHEADERREPLY = nArray19;
        int[] nArray20 = new int[4];
        nArray20[0] = 18;
        nArray20[2] = 18;
        SETCLOCKRATIOHEADER = nArray20;
        int[] nArray21 = new int[4];
        nArray21[0] = 19;
        nArray21[2] = 19;
        SETCLOCKTIMEHEADER = nArray21;
        int[] nArray22 = new int[4];
        nArray22[0] = 50;
        nArray22[2] = 50;
        SETCLOCKAMPMHEADER = nArray22;
        int[] nArray23 = new int[4];
        nArray23[0] = 34;
        nArray23[2] = 34;
        LOCOSOLECONTROL = nArray23;
        int[] nArray24 = new int[4];
        nArray24[0] = 221;
        nArray24[2] = 221;
        LOCODBLCONTROL = nArray24;
        int[] nArray25 = new int[4];
        nArray25[0] = 85;
        nArray25[2] = 85;
        GOODCMDRECEIVED = nArray25;
        int[] nArray26 = new int[4];
        nArray26[0] = 238;
        nArray26[2] = 238;
        BADCMDRECEIVED = nArray26;
        int[] nArray27 = new int[8];
        nArray27[0] = 130;
        nArray27[2] = 130;
        nArray27[4] = 130;
        nArray27[6] = 130;
        POWERON = nArray27;
        int[] nArray28 = new int[8];
        nArray28[0] = 146;
        nArray28[2] = 146;
        nArray28[4] = 146;
        nArray28[6] = 146;
        POWEROFF = nArray28;
        TWO_DIGITS = new DecimalFormat("00");
        TXT_ON = Bundle.getMessage("MrcPacketsFunctionOn");
        TXT_OFF = Bundle.getMessage("MrcPacketsFunctionOff");
    }

    public static int getAddToConsistPacketLength() {
        return ADDTOCONSISTPACKETHEADER.length + 4;
    }

    public static int getClearConsistPacketLength() {
        return CLEARCONSISTPACKETHEADER.length + 4;
    }

    public static int getRouteControlPacketLength() {
        return ROUTECONTROLPACKETHEADER.length + 6;
    }

    public static int getClearRoutePacketLength() {
        return CLEARROUTEPACKETHEADER.length + 4;
    }

    public static int getAddToRoutePacketLength() {
        return ADDTOROUTEPACKETHEADER.length + 6;
    }

    public static int getAccessoryPacketLength() {
        return ACCESSORYPACKETHEADER.length + 6;
    }

    public static int getWriteCVPROGPacketLength() {
        return WRITECVPROGHEADER.length + 8;
    }

    public static int getWriteCVPOMPacketLength() {
        return WRITECVPOMHEADER.length + 12;
    }

    public static int getSetClockRatioPacketLength() {
        return SETCLOCKRATIOHEADER.length + 4;
    }

    public static int getSetClockAmPmPacketLength() {
        return SETCLOCKAMPMHEADER.length + 4;
    }

    public static int getFunctionPacketLength() {
        return FUNCTIONGROUP1PACKETHEADER.length + 8;
    }

    public static int getReadDecoderAddressLength() {
        return READDECODERADDRESS.length;
    }

    public static int getSetClockTimePacketLength() {
        return SETCLOCKTIMEHEADER.length + 6;
    }

    public static int getThrottlePacketLength() {
        return THROTTLEPACKETHEADER.length + 10;
    }

    public static int getReadCVPacketLength() {
        return READCVHEADER.length + 6;
    }

    public static int getReadCVPacketReplyLength() {
        return READCVHEADERREPLY.length + 4;
    }

    public static int getPowerOnPacketLength() {
        return POWERON.length;
    }

    public static int getPowerOffPacketLength() {
        return POWERON.length;
    }

    public static boolean startsWith(MrcMessage source, int[] match) {
        if (match.length > source.getNumDataElements()) {
            return false;
        }
        int i = 0;
        while (i < match.length) {
            if ((source.getElement(i) & 0xFF) != (match[i] & 0xFF)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String toString(MrcMessage m) {
        StringBuilder txt = new StringBuilder();
        if (m.getNumDataElements() < 4 || m.getNumDataElements() >= 4 && m.getElement(0) != m.getElement(2) && m.getElement(1) != 1) {
            if (m.getNumDataElements() < 4) {
                txt.append(Bundle.getMessage("MrcPacketsShort"));
            } else {
                txt.append(Bundle.getMessage("MrcPacketsError"));
            }
            int i = 0;
            while (i < m.getNumDataElements()) {
                txt.append(" ");
                txt.append(StringUtil.twoHexFromInt(m.getElement(i) & 0xFF));
                ++i;
            }
        } else {
            block0 : switch (m.getElement(0) & 0xFF) {
                case 18: {
                    txt.append(Bundle.getMessage("MrcPacketsSetClockRatio")).append(m.getElement(4));
                    break;
                }
                case 19: {
                    txt.append(Bundle.getMessage("MrcPacketsSetClockTime")).append(m.getElement(4)).append(Bundle.getMessage("MrcPacketsClockTimeSep")).append(m.getElement(6));
                    break;
                }
                case 50: {
                    txt.append(Bundle.getMessage("MrcPacketsSetClockMode"));
                    break;
                }
                case 37: {
                    if (m.getElement(4) != 0) {
                        txt.append(Bundle.getMessage("MrcPacketsLoco")).append(" ").append(Bundle.getMessage("MrcPacketsLocoLong")).append(" ");
                    } else {
                        txt.append(Bundle.getMessage("MrcPacketsLoco")).append(" ").append(Bundle.getMessage("MrcPacketsLocoShort")).append(" ");
                    }
                    txt.append(Integer.toString(m.getLocoAddress()));
                    if (m.getElement(10) == 2) {
                        txt.append(" ").append(Bundle.getMessage("MrcPackets128ss"));
                        if ((m.getElement(8) & 0x80) == 128) {
                            txt.append(" ").append(Bundle.getMessage("MrcPacketsForward"));
                        } else {
                            txt.append(" ").append(Bundle.getMessage("MrcPacketsReverse"));
                        }
                        txt.append(" ").append(Bundle.getMessage("MrcPacketsSpeed"));
                        int speed = (m.getElement(8) & 0x7F) - 1;
                        switch (speed) {
                            case 0: {
                                txt.append(" ").append(Bundle.getMessage("MrcPacketsEStop"));
                                break block0;
                            }
                            case -1: {
                                txt.append(" ").append(Bundle.getMessage("MrcPacketsStop"));
                                break block0;
                            }
                        }
                        txt.append(" ").append(Integer.toString(speed));
                        break;
                    }
                    if (m.getElement(10) == 0) {
                        int value = m.getElement(8);
                        txt.append(" ").append(Bundle.getMessage("MrcPackets28ss"));
                        if ((m.getElement(8) & 0x60) == 96) {
                            value -= 96;
                            txt.append(" ").append(Bundle.getMessage("MrcPacketsForward"));
                        } else {
                            value -= 64;
                            txt.append(" ").append(Bundle.getMessage("MrcPacketsReverse"));
                        }
                        if ((value >> 4 & 1) == 1) {
                            value -= 16;
                            value = (value << 1) + 1;
                        } else {
                            value <<= 1;
                        }
                        if ((value -= 3) == -1) {
                            txt.append(" ").append(Bundle.getMessage("MrcPacketsEStop"));
                            break;
                        }
                        if (value < 0) {
                            value = 0;
                        }
                        txt.append(" ").append(Bundle.getMessage("MrcPacketsSpeed")).append(" ").append(Integer.toString(value));
                    }
                    break;
                }
                case 52: {
                    txt.append(Bundle.getMessage("MrcPacketsLoco")).append(" ").append(Integer.toString(m.getLocoAddress())).append(" ").append(Bundle.getMessage("MrcPacketsGroup1"));
                    txt.append(" F0 ").append((m.getElement(8) & 0x10) != 0 ? TXT_ON : TXT_OFF);
                    txt.append(" F1 ").append((m.getElement(8) & 1) != 0 ? TXT_ON : TXT_OFF);
                    txt.append(" F2 ").append((m.getElement(8) & 2) != 0 ? TXT_ON : TXT_OFF);
                    txt.append(" F3 ").append((m.getElement(8) & 4) != 0 ? TXT_ON : TXT_OFF);
                    txt.append(" F4 ").append((m.getElement(8) & 8) != 0 ? TXT_ON : TXT_OFF);
                    break;
                }
                case 68: {
                    txt.append(Bundle.getMessage("MrcPacketsLoco")).append(" ").append(Integer.toString(m.getLocoAddress())).append(" ").append(Bundle.getMessage("MrcPacketsGroup2"));
                    txt.append(" F5 ").append((m.getElement(8) & 1) != 0 ? TXT_ON : TXT_OFF);
                    txt.append(" F6 ").append((m.getElement(8) & 2) != 0 ? TXT_ON : TXT_OFF);
                    txt.append(" F7 ").append((m.getElement(8) & 4) != 0 ? TXT_ON : TXT_OFF);
                    txt.append(" F8 ").append((m.getElement(8) & 8) != 0 ? TXT_ON : TXT_OFF);
                    break;
                }
                case 84: {
                    txt.append(Bundle.getMessage("MrcPacketsLoco")).append(" ").append(Integer.toString(m.getLocoAddress())).append(" ").append(Bundle.getMessage("MrcPacketsGroup3"));
                    txt.append(" F9 ").append((m.getElement(8) & 1) != 0 ? TXT_ON : TXT_OFF);
                    txt.append(" F10 ").append((m.getElement(8) & 2) != 0 ? TXT_ON : TXT_OFF);
                    txt.append(" F11 ").append((m.getElement(8) & 4) != 0 ? TXT_ON : TXT_OFF);
                    txt.append(" F12 ").append((m.getElement(8) & 8) != 0 ? TXT_ON : TXT_OFF);
                    break;
                }
                case 116: {
                    txt.append(Bundle.getMessage("MrcPacketsLoco")).append(" ").append(Integer.toString(m.getLocoAddress())).append(" ").append(Bundle.getMessage("MrcPacketsGroup4"));
                    txt.append(" F13 ").append((m.getElement(8) & 1) != 0 ? TXT_ON : TXT_OFF);
                    txt.append(" F14 ").append((m.getElement(8) & 2) != 0 ? TXT_ON : TXT_OFF);
                    txt.append(" F15 ").append((m.getElement(8) & 4) != 0 ? TXT_ON : TXT_OFF);
                    txt.append(" F16 ").append((m.getElement(8) & 8) != 0 ? TXT_ON : TXT_OFF);
                    break;
                }
                case 132: {
                    txt.append(Bundle.getMessage("MrcPacketsLoco")).append(" ").append(Integer.toString(m.getLocoAddress())).append(" ").append(Bundle.getMessage("MrcPacketsGroup5"));
                    txt.append(" F17 ").append((m.getElement(8) & 1) != 0 ? TXT_ON : TXT_OFF);
                    txt.append(" F18 ").append((m.getElement(8) & 2) != 0 ? TXT_ON : TXT_OFF);
                    txt.append(" F19 ").append((m.getElement(8) & 4) != 0 ? TXT_ON : TXT_OFF);
                    txt.append(" F20 ").append((m.getElement(8) & 8) != 0 ? TXT_ON : TXT_OFF);
                    break;
                }
                case 164: {
                    txt.append(Bundle.getMessage("MrcPacketsLoco")).append(" ").append(Integer.toString(m.getLocoAddress())).append(" ").append(Bundle.getMessage("MrcPacketsGroup6"));
                    txt.append(" F21 ").append((m.getElement(8) & 1) != 0 ? TXT_ON : TXT_OFF);
                    txt.append(" F22 ").append((m.getElement(8) & 2) != 0 ? TXT_ON : TXT_OFF);
                    txt.append(" F23 ").append((m.getElement(8) & 4) != 0 ? TXT_ON : TXT_OFF);
                    txt.append(" F24 ").append((m.getElement(8) & 8) != 0 ? TXT_ON : TXT_OFF);
                    txt.append(" F25 ").append((m.getElement(8) & 0x10) != 0 ? TXT_ON : TXT_OFF);
                    txt.append(" F26 ").append((m.getElement(8) & 0x20) != 0 ? TXT_ON : TXT_OFF);
                    txt.append(" F27 ").append((m.getElement(8) & 0x40) != 0 ? TXT_ON : TXT_OFF);
                    txt.append(" F28 ").append((m.getElement(8) & 0x80) != 0 ? TXT_ON : TXT_OFF);
                    break;
                }
                case 67: {
                    int cv = ((m.getElement(4) & 0xFF) << 8) + (m.getElement(6) & 0xFF);
                    txt.append(Bundle.getMessage("MrcPacketsReadCv")).append(Integer.toString(cv));
                    break;
                }
                case 66: {
                    txt.append(Bundle.getMessage("MrcPacketsReadLocoAddr"));
                    break;
                }
                case 86: {
                    txt.append(Bundle.getMessage("MrcPacketsWriteOpsCvLoco")).append(" ").append(Integer.toString(m.getLocoAddress()));
                    txt.append(" ").append(Integer.toString((m.getElement(10) & 0xFF) + 1));
                    txt.append("=");
                    txt.append(Integer.toString(m.getElement(12) & 0xFF));
                    break;
                }
                case 36: {
                    txt.append(Bundle.getMessage("MrcPacketsWriteSvrCv"));
                    txt.append(" ").append(Integer.toString(m.getElement(4) << 8)).append(m.getElement(6));
                    txt.append("=");
                    txt.append(Integer.toString(m.getElement(8) & 0xFF));
                    break;
                }
                case 102: {
                    txt.append(Bundle.getMessage("MrcPacketsReadCvValue"));
                    txt.append(Integer.toString(m.value()));
                    break;
                }
                case 238: {
                    txt.append(Bundle.getMessage("MrcPacketBadCmdAck"));
                    break;
                }
                case 85: {
                    txt.append(Bundle.getMessage("MrcPacketGoodCmdAck"));
                    break;
                }
                case 51: {
                    txt.append(Bundle.getMessage("MrcPacketsPgmCmdSent"));
                    break;
                }
                case 34: {
                    txt.append(Bundle.getMessage("MrcPacketsSingleThrottle"));
                    break;
                }
                case 221: {
                    txt.append(Bundle.getMessage("MrcPacketsMultipleThrottle"));
                    break;
                }
                case 130: {
                    txt.append(Bundle.getMessage("MrcPacketsTrkPwrOn"));
                    break;
                }
                case 146: {
                    txt.append(Bundle.getMessage("MrcPacketsTrkPwrOff"));
                    break;
                }
                case 100: {
                    txt.append(Bundle.getMessage("MrcPacketsLocoAddConsist"));
                    break;
                }
                case 98: {
                    txt.append(Bundle.getMessage("MrcPacketsClearedConsist"));
                    break;
                }
                case 195: {
                    txt.append(Bundle.getMessage("MrcPacketsRoute"));
                    txt.append(" ").append(Integer.toString(m.getElement(4)));
                    txt.append(" ").append(Bundle.getMessage("MrcPacketsRouteSet"));
                    break;
                }
                case 210: {
                    txt.append(Bundle.getMessage("MrcPacketsClearedRoute"));
                    break;
                }
                case 211: {
                    txt.append(Bundle.getMessage("MrcPacketsAddedRoute"));
                    break;
                }
                case 115: {
                    txt.append(Bundle.getMessage("MrcPacketsAccy"));
                    txt.append(" ").append(Integer.toString(m.getAccAddress())).append(" ");
                    switch (m.getAccState()) {
                        case 2: {
                            txt.append(Bundle.getMessage("MrcPacketsAccyClosed"));
                            break block0;
                        }
                        case 4: {
                            txt.append(Bundle.getMessage("MrcPacketsAccyThrown"));
                            break block0;
                        }
                    }
                    txt.append(Bundle.getMessage("MrcPacketsAccyUnk"));
                    break;
                }
                default: {
                    if (m.getNumDataElements() == 6) {
                        if (m.getElement(0) == m.getElement(2) && m.getElement(0) == m.getElement(4)) {
                            txt.append(Bundle.getMessage("MrcPacketsPollToCab")).append(" ");
                            txt.append(m.getElement(0));
                            break;
                        }
                        if (m.getElement(0) == 0 && m.getElement(1) == 1) {
                            txt.append(Bundle.getMessage("MrcPacketsClockUpdate")).append(" ");
                            MrcPackets.appendClockMessage(m, txt);
                            txt.append(" ");
                        }
                    } else {
                        if (m.getNumDataElements() == 4 && m.getElement(0) == 0 && m.getElement(1) == 0) {
                            txt.append("No Data From Last Cab");
                            break;
                        }
                        txt.append("Unk Cmd Code:");
                        int i = 0;
                        while (i < m.getNumDataElements()) {
                            txt.append(" ");
                            txt.append(StringUtil.twoHexFromInt(m.getElement(i) & 0xFF));
                            ++i;
                        }
                    }
                    break;
                }
            }
        }
        return txt.toString();
    }

    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"}, justification="covers all possible values")
    static void appendClockMessage(MrcMessage m, StringBuilder txt) {
        int clockModeBits = m.getElement(2) & 0xC0;
        switch (clockModeBits) {
            case 0: {
                txt.append(m.getElement(2) & 0x1F).append(Bundle.getMessage("MrcPacketsClockTimeSep")).append(TWO_DIGITS.format(m.getElement(4))).append(Bundle.getMessage("MrcPacketsClockModeAm"));
                break;
            }
            case 64: {
                txt.append(m.getElement(2) & 0x1F).append(Bundle.getMessage("MrcPacketsClockTimeSep")).append(TWO_DIGITS.format(m.getElement(4))).append(Bundle.getMessage("MrcPacketsClockModePm"));
                break;
            }
            case 128: {
                txt.append(TWO_DIGITS.format(m.getElement(2) & 0x1F)).append(Bundle.getMessage("MrcPacketsClockTimeSep")).append(TWO_DIGITS.format(m.getElement(4))).append(Bundle.getMessage("MrcPacketsClockMode24"));
                break;
            }
            case 192: {
                txt.append(TWO_DIGITS.format(m.getElement(2) & 0x1F)).append(Bundle.getMessage("MrcPacketsClockTimeSep")).append(TWO_DIGITS.format(m.getElement(4))).append(Bundle.getMessage("MrcPacketsClockModeUnk"));
                break;
            }
            default: {
                log.warn("Unhandled clock mode code: {}", (Object)clockModeBits);
            }
        }
    }

    public static boolean validCheckSum(MrcMessage m) {
        if (m.getNumDataElements() > 6) {
            int result = 0;
            int i = 4;
            while (i < m.getNumDataElements() - 2) {
                result = m.getElement(i) & 0xFF ^ result;
                ++i;
            }
            if (result == (m.getElement(m.getNumDataElements() - 2) & 0xFF)) {
                return true;
            }
        }
        return false;
    }
}

