/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mrc;

import jmri.NmraPacket;
import jmri.jmrix.mrc.MrcPackets;
import jmri.jmrix.mrc.MrcTrafficListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MrcMessage {
    MrcTrafficListener source = null;
    int msgClass = -1;
    boolean replyExpected = true;
    int SHORT_TIMEOUT = 150;
    int SHORT_PROG_TIMEOUT = 4000;
    int timeout = this.SHORT_TIMEOUT;
    int retries = 3;
    boolean inError = false;
    protected static final int LONG_TIMEOUT = 65000;
    byte[] byteStream;
    private int _nDataChars = 0;
    private int[] _dataChars = null;
    private static final Logger log = LoggerFactory.getLogger(MrcMessage.class);

    public MrcMessage(int len) {
        if (len < 1) {
            log.error("invalid length in call to ctor: {}", (Object)len);
        }
        this._nDataChars = len;
        this._dataChars = new int[len];
    }

    public MrcMessage(MrcMessage original) {
        this(original._dataChars);
    }

    public MrcMessage(int[] contents) {
        this(contents.length);
        int i = 0;
        while (i < contents.length) {
            this.setElement(i, contents[i]);
            ++i;
        }
    }

    public MrcMessage(byte[] contents) {
        this(contents.length);
        int i = 0;
        while (i < contents.length) {
            this.setElement(i, contents[i] & 0xFF);
            ++i;
        }
    }

    public void setSource(MrcTrafficListener s) {
        this.source = s;
    }

    public MrcTrafficListener getSource() {
        return this.source;
    }

    void setMessageClass(int i) {
        this.msgClass = i;
    }

    public int getMessageClass() {
        return this.msgClass;
    }

    public void replyNotExpected() {
        this.replyExpected = false;
    }

    public boolean isReplyExpected() {
        return this.replyExpected;
    }

    void setTimeout(int i) {
        this.timeout = i;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int i) {
        this.retries = i;
    }

    public void setMessageInError() {
        this.inError = true;
    }

    public boolean isPacketInError() {
        return this.inError;
    }

    int putHeader(int[] insert) {
        int i = 0;
        i = 0;
        while (i < insert.length) {
            this.setElement(i, insert[i]);
            ++i;
        }
        return i;
    }

    public String toString() {
        return MrcPackets.toString(this);
    }

    public static MrcMessage getSendSpeed128(int addressLo, int addressHi, int speed) {
        MrcMessage m = new MrcMessage(MrcPackets.getThrottlePacketLength());
        m.setMessageClass(1);
        int i = m.putHeader(MrcPackets.THROTTLEPACKETHEADER);
        m.setElement(i++, addressHi);
        m.setElement(i++, 0);
        m.setElement(i++, addressLo);
        m.setElement(i++, 0);
        m.setElement(i++, speed);
        m.setElement(i++, 0);
        m.setElement(i++, 2);
        m.setElement(i++, 0);
        m.setElement(i++, MrcMessage.getCheckSum(addressHi, addressLo, speed, 2));
        m.setElement(i++, 0);
        return m;
    }

    public static MrcMessage getSendSpeed28(int addressLo, int addressHi, int speed, boolean fwd) {
        MrcMessage m = new MrcMessage(MrcPackets.getThrottlePacketLength());
        m.setMessageClass(1);
        int i = m.putHeader(MrcPackets.THROTTLEPACKETHEADER);
        int speedC = (speed & 0x1E) >> 1;
        int c = (speed & 1) << 4;
        speedC += c;
        speedC = (fwd ? 96 : 64) | speedC;
        m.setElement(i++, addressHi);
        m.setElement(i++, 0);
        m.setElement(i++, addressLo);
        m.setElement(i++, 0);
        m.setElement(i++, speedC);
        m.setElement(i++, 0);
        m.setElement(i++, 0);
        m.setElement(i++, 0);
        m.setElement(i++, MrcMessage.getCheckSum(addressHi, addressLo, speedC, 0));
        m.setElement(i++, 0);
        return m;
    }

    public static MrcMessage getSendFunction(int group, int addressLo, int addressHi, int data) {
        MrcMessage m = new MrcMessage(MrcPackets.getFunctionPacketLength());
        m.setMessageClass(1);
        m.replyNotExpected();
        int i = 0;
        switch (group) {
            case 1: {
                i = m.putHeader(MrcPackets.FUNCTIONGROUP1PACKETHEADER);
                break;
            }
            case 2: {
                i = m.putHeader(MrcPackets.FUNCTIONGROUP2PACKETHEADER);
                break;
            }
            case 3: {
                i = m.putHeader(MrcPackets.FUNCTIONGROUP3PACKETHEADER);
                break;
            }
            case 4: {
                i = m.putHeader(MrcPackets.FUNCTIONGROUP4PACKETHEADER);
                break;
            }
            case 5: {
                i = m.putHeader(MrcPackets.FUNCTIONGROUP5PACKETHEADER);
                break;
            }
            case 6: {
                i = m.putHeader(MrcPackets.FUNCTIONGROUP6PACKETHEADER);
                break;
            }
            default: {
                log.error("Invalid function group: {}", (Object)group);
                return null;
            }
        }
        m.setElement(i++, addressHi);
        m.setElement(i++, 0);
        m.setElement(i++, addressLo);
        m.setElement(i++, 0);
        m.setElement(i++, data);
        m.setElement(i++, 0);
        m.setElement(i++, MrcMessage.getCheckSum(addressHi, addressLo, data, 0));
        m.setElement(i++, 0);
        return m;
    }

    static int getCheckSum(int addressHi, int addressLo, int data1, int data2) {
        int address = addressHi ^ addressLo;
        int data = data1 ^ data2;
        return address ^ data;
    }

    public static MrcMessage getReadCV(int cv) {
        int cvLo = cv;
        int cvHi = cv >> 8;
        MrcMessage m = new MrcMessage(MrcPackets.getReadCVPacketLength());
        m.setMessageClass(2);
        m.setTimeout(65000);
        int i = m.putHeader(MrcPackets.READCVHEADER);
        m.setElement(i++, cvHi);
        m.setElement(i++, 0);
        m.setElement(i++, cvLo);
        m.setElement(i++, 0);
        m.setElement(i++, MrcMessage.getCheckSum(0, 0, cvHi, cvLo));
        m.setElement(i++, 0);
        return m;
    }

    public static MrcMessage getPOM(int addressLo, int addressHi, int cv, int val) {
        MrcMessage m = new MrcMessage(MrcPackets.getWriteCVPOMPacketLength());
        m.setMessageClass(2);
        int i = m.putHeader(MrcPackets.WRITECVPOMHEADER);
        --cv;
        m.setElement(i++, addressHi);
        m.setElement(i++, 0);
        m.setElement(i++, addressLo);
        m.setElement(i++, 0);
        m.setElement(i++, 236);
        m.setElement(i++, 0);
        m.setElement(i++, cv);
        m.setElement(i++, 0);
        m.setElement(i++, val);
        m.setElement(i++, 0);
        int checksum = MrcMessage.getCheckSum(addressHi, addressLo, 236, cv);
        checksum = MrcMessage.getCheckSum(checksum, val, 0, 0);
        m.setElement(i++, checksum);
        return m;
    }

    public static MrcMessage getWriteCV(int cv, int val) {
        MrcMessage m = new MrcMessage(MrcPackets.getWriteCVPROGPacketLength());
        m.setMessageClass(2);
        int i = m.putHeader(MrcPackets.WRITECVPROGHEADER);
        int cvLo = cv;
        int cvHi = cv >> 8;
        m.setElement(i++, cvHi);
        m.setElement(i++, 0);
        m.setElement(i++, cvLo);
        m.setElement(i++, 0);
        m.setElement(i++, val);
        m.setElement(i++, 0);
        m.setElement(i++, MrcMessage.getCheckSum(cvHi, cvLo, val, 0));
        return m;
    }

    public boolean validCheckSum() {
        if (this.getNumDataElements() > 6) {
            int result = 0;
            int i = 4;
            while (i < this.getNumDataElements() - 2) {
                result = this.getElement(i) & 0xFF ^ result;
                ++i;
            }
            if (result == (this.getElement(this.getNumDataElements() - 2) & 0xFF)) {
                return true;
            }
        }
        return false;
    }

    public int value() {
        int val = -1;
        if (MrcPackets.startsWith(this, MrcPackets.READCVHEADERREPLY)) {
            if (this.getElement(4) == this.getElement(6)) {
                val = this.getElement(4) & 0xFF;
            } else {
                log.error("Error in format of the returned CV value");
            }
        } else {
            log.error("Not a CV Read formated packet");
        }
        return val;
    }

    public int getLocoAddress() {
        if (this.getMessageClass() != 1 && this.getMessageClass() != 2) {
            return -1;
        }
        int hi = this.getElement(4);
        int lo = this.getElement(6);
        if (hi == 0) {
            return lo;
        }
        hi = (hi & 0xFF) - 192 << 8;
        return hi += lo & 0xFF;
    }

    public int getAccAddress() {
        if (this.getMessageClass() != 4) {
            return -1;
        }
        int lowbyte = this.getElement(4) & 0xFF & 0x3F;
        int highbyte = (this.getElement(6) & 0xFF & 0x70) >> 4;
        highbyte = (~highbyte & 7) << 6;
        int address = (lowbyte + highbyte - 1 << 2) + 1;
        return address += (this.getElement(6) & 0xFF & 7) >> 1;
    }

    public int getAccState() {
        if ((this.getElement(6) & 7 & 1) == 1) {
            return 2;
        }
        return 4;
    }

    public static MrcMessage setClockRatio(int ratio) {
        if (ratio < 0 || ratio > 60) {
            log.error("ratio number too large: {}", (Object)ratio);
        }
        MrcMessage m = new MrcMessage(MrcPackets.getSetClockRatioPacketLength());
        m.setMessageClass(32);
        int i = m.putHeader(MrcPackets.SETCLOCKRATIOHEADER);
        m.setElement(i++, ratio);
        m.setElement(i++, 0);
        m.setElement(i++, MrcMessage.getCheckSum(ratio, 0, 0, 0));
        m.replyNotExpected();
        return m;
    }

    public static MrcMessage setClockTime(int hour, int minute) {
        if (hour < 0 || hour > 23) {
            log.error("hour number out of range : {}", (Object)hour);
        }
        if (minute < 0 || minute > 59) {
            log.error("minute number out of range : {}", (Object)minute);
        }
        MrcMessage m = new MrcMessage(MrcPackets.getSetClockTimePacketLength());
        m.setMessageClass(32);
        int i = m.putHeader(MrcPackets.SETCLOCKTIMEHEADER);
        m.setElement(i++, hour);
        m.setElement(i++, 0);
        m.setElement(i++, minute);
        m.setElement(i++, 0);
        m.setElement(i++, MrcMessage.getCheckSum(hour, 0, minute, 0));
        m.replyNotExpected();
        return m;
    }

    public static MrcMessage setClockAmPm() {
        MrcMessage m = new MrcMessage(MrcPackets.getSetClockAmPmPacketLength());
        m.setMessageClass(32);
        int i = m.putHeader(MrcPackets.SETCLOCKAMPMHEADER);
        m.setElement(i++, 50);
        m.setElement(i++, 0);
        m.setElement(i++, MrcMessage.getCheckSum(50, 0, 0, 0));
        m.replyNotExpected();
        return m;
    }

    public static MrcMessage setPowerOff() {
        MrcMessage m = new MrcMessage(MrcPackets.getPowerOffPacketLength());
        m.setMessageClass(16);
        m.putHeader(MrcPackets.POWEROFF);
        m.replyNotExpected();
        return m;
    }

    public static MrcMessage setPowerOn() {
        MrcMessage m = new MrcMessage(MrcPackets.getPowerOffPacketLength());
        m.setMessageClass(16);
        m.putHeader(MrcPackets.POWERON);
        m.replyNotExpected();
        return m;
    }

    static MrcMessage getSwitchMsg(int address, boolean closed) {
        MrcMessage m = new MrcMessage(MrcPackets.getAccessoryPacketLength());
        m.setMessageClass(4);
        m.putHeader(MrcPackets.ACCESSORYPACKETHEADER);
        byte[] packet = NmraPacket.accDecoderPkt(address, closed);
        if (packet == null) {
            return null;
        }
        m.setElement(4, packet[0]);
        m.setElement(5, 0);
        m.setElement(6, packet[1]);
        m.setElement(7, 0);
        m.setElement(8, packet[2]);
        m.setElement(9, 0);
        m.setRetries(2);
        m.replyNotExpected();
        m.setByteStream();
        return m;
    }

    static MrcMessage getRouteMsg(int address, boolean closed) {
        MrcMessage m = new MrcMessage(MrcPackets.getRouteControlPacketLength());
        m.setMessageClass(4);
        m.putHeader(MrcPackets.ROUTECONTROLPACKETHEADER);
        int i = m.putHeader(MrcPackets.ROUTECONTROLPACKETHEADER);
        m.setElement(i++, address);
        m.setElement(i++, 0);
        int state = closed ? 128 : 0;
        m.setElement(i++, state);
        m.setElement(i++, 0);
        m.setElement(i++, MrcMessage.getCheckSum(address, 0, state, 0));
        m.setElement(i++, 0);
        m.setRetries(2);
        m.replyNotExpected();
        m.setByteStream();
        return m;
    }

    public static MrcMessage setNoData() {
        MrcMessage m = new MrcMessage(4);
        m.setMessageClass(64);
        m.setElement(0, 0);
        m.setElement(1, 0);
        m.setElement(2, 0);
        m.setElement(3, 0);
        m.setTimeout(0);
        m.setRetries(0);
        m.setByteStream();
        return m;
    }

    void setByteStream() {
        int len = this.getNumDataElements();
        this.byteStream = new byte[len];
        int i = 0;
        while (i < len) {
            this.byteStream[i] = (byte)this.getElement(i);
            ++i;
        }
    }

    byte[] getByteStream() {
        return this.byteStream;
    }

    public int getElement(int n) {
        return this._dataChars[n];
    }

    public int getNumDataElements() {
        return this._nDataChars;
    }

    public void setElement(int n, int v) {
        this._dataChars[n] = v;
    }
}

