/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mrc;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.Date;
import javax.swing.Timer;
import jmri.InstanceManager;
import jmri.Timebase;
import jmri.implementation.DefaultClockControl;
import jmri.jmrix.mrc.Bundle;
import jmri.jmrix.mrc.MrcMessage;
import jmri.jmrix.mrc.MrcTrafficController;
import jmri.jmrix.mrc.MrcTrafficListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MrcClockControl
extends DefaultClockControl
implements MrcTrafficListener {
    private MrcTrafficController tc = null;
    private static final boolean DEBUG_SHOW_PUBLIC_CALLS = true;
    private static final boolean DEBUG_SHOW_SYNC_CALLS = false;
    public static final int CS_CLOCK_SCALE = 0;
    public static final int CS_CLOCK_MINUTES = 3;
    public static final int CS_CLOCK_HOURS = 4;
    public static final int CS_CLOCK_AMPM = 5;
    public static final int CS_CLOCK_1224 = 6;
    public static final int CS_CLOCK_STATUS = 13;
    public static final int CMD_CLOCK_SET_TIME_SIZE = 3;
    public static final int CMD_CLOCK_SET_PARAM_SIZE = 2;
    public static final int CMD_CLOCK_SET_RUN_SIZE = 1;
    public static final int CMD_CLOCK_SET_REPLY_SIZE = 1;
    public static final int CMD_MEM_SET_REPLY_SIZE = 1;
    public static final int MAX_ERROR_ARRAY = 4;
    public static final double TARGET_SYNC_DELAY = 55.0;
    public static final int SYNCMODE_OFF = 0;
    public static final int SYNCMODE_MRC_MASTER = 1;
    public static final int SYNCMODE_INTERNAL_MASTER = 2;
    public static final int WAIT_CMD_EXECUTION = 1000;
    DecimalFormat fiveDigits = new DecimalFormat("0.00000");
    DecimalFormat fourDigits = new DecimalFormat("0.0000");
    DecimalFormat threeDigits = new DecimalFormat("0.000");
    DecimalFormat twoDigits = new DecimalFormat("0.00");
    private int clockMode = 0;
    private MrcMessage lastClockReadPacket = null;
    private int mrcLastHour;
    private int mrcLastMinute;
    private int mrcLastRatio;
    private boolean mrcLastAmPm;
    private boolean mrcLast1224;
    private int mrcSyncInitStateCounter = 0;
    private int mrcSyncRunStateCounter = 0;
    Timebase internalClock;
    Timer alarmSyncUpdate = null;
    PropertyChangeListener minuteChangeListener;
    private static final Logger log = LoggerFactory.getLogger(MrcClockControl.class);

    public MrcClockControl(MrcTrafficController tc, String prefix) {
        this.tc = tc;
        this.internalClock = InstanceManager.getNullableDefault(Timebase.class);
        if (this.internalClock == null) {
            log.error("No Internal Timebase Instance");
            return;
        }
        this.minuteChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                MrcClockControl.this.newInternalMinute();
            }
        };
        this.internalClock.addMinuteChangeListener(this.minuteChangeListener);
        tc.addTrafficListener(32, this);
    }

    public void message(MrcMessage r) {
        if ((r.getMessageClass() & 0x20) != 32) {
            return;
        }
        if (r.getNumDataElements() != 6 || r.getElement(0) != 0 || r.getElement(1) != 1 || r.getElement(3) != 0 || r.getElement(5) != 0) {
            return;
        }
        log.debug("MrcReply(len {})", (Object)r.getNumDataElements());
        this.readClockPacket(r);
    }

    @Override
    public synchronized void notifyXmit(Date timestamp, MrcMessage m) {
    }

    @Override
    public synchronized void notifyFailedXmit(Date timestamp, MrcMessage m) {
    }

    @Override
    public synchronized void notifyRcv(Date timestamp, MrcMessage m) {
        this.message(m);
    }

    @Override
    public String getHardwareClockName() {
        log.debug("getHardwareClockName");
        return Bundle.getMessage("MrcClockName");
    }

    @Override
    public boolean canCorrectHardwareClock() {
        log.debug("getHardwareClockName");
        return false;
    }

    @Override
    public boolean canSet12Or24HourClock() {
        log.debug("canSet12Or24HourClock");
        return true;
    }

    @Override
    public void setRate(double newRate) {
        log.debug("setRate: {}", (Object)newRate);
        int newRatio = (int)newRate;
        if (newRatio < 1 || newRatio > 60) {
            log.error("Mrc clock ratio out of range:");
        } else {
            this.issueClockRatio(newRatio);
        }
    }

    @Override
    public boolean requiresIntegerRate() {
        log.debug("requiresIntegerRate");
        return true;
    }

    @Override
    public double getRate() {
        log.debug("getRate: {}", (Object)this.mrcLastRatio);
        return this.mrcLastRatio;
    }

    @Override
    public void setTime(Date now) {
        log.debug("setTime: {}", (Object)now);
        this.issueClockTime(now.getHours(), now.getMinutes());
    }

    @Override
    public Date getTime() {
        Date now = this.internalClock.getTime();
        if (this.lastClockReadPacket != null) {
            if (this.mrcLast1224) {
                now.setHours(this.mrcLastHour);
            } else if (this.mrcLastAmPm) {
                now.setHours(this.mrcLastHour);
            } else {
                now.setHours(this.mrcLastHour + 12);
            }
            now.setMinutes(this.mrcLastMinute);
            now.setSeconds(0);
        }
        log.debug("getTime returning: {}", (Object)now);
        return now;
    }

    @Override
    public void startHardwareClock(Date now) {
        log.debug("startHardwareClock: {}", (Object)now);
        this.issueClockTime(now.getHours(), now.getMinutes());
    }

    @Override
    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"}, justification="testing for any change from previous value")
    public void initializeHardwareClock(double rate, Date now, boolean getTime) {
        boolean setInternal;
        boolean synchronizeWithInternalClock = this.internalClock.getSynchronize();
        boolean correctFastClock = this.internalClock.getCorrectHardware();
        boolean bl = setInternal = !this.internalClock.getInternalMaster();
        if (!(setInternal || synchronizeWithInternalClock || correctFastClock)) {
            return;
        }
        int newRate = (int)rate;
        if ((double)newRate != this.getRate()) {
            this.setRate(rate);
        }
        if (!getTime) {
            this.setTime(now);
        }
    }

    public void dispose() {
        if (this.minuteChangeListener != null) {
            this.internalClock.removeMinuteChangeListener(this.minuteChangeListener);
            this.minuteChangeListener = null;
        }
    }

    public void newInternalMinute() {
        if (this.clockMode == 2) {
            Date now = this.internalClock.getTime();
            this.setTime(now);
        }
    }

    private void readClockPacket(MrcMessage r) {
        this.lastClockReadPacket = r;
        this.mrcLastHour = r.getElement(2) & 0x1F;
        this.mrcLastMinute = r.getElement(4) & 0xFF;
        this.mrcLast1224 = (r.getElement(2) & 0xC0) == 128;
        this.mrcLastAmPm = (r.getElement(2) & 0xC0) == 0;
        Date now = this.internalClock.getTime();
        if (this.mrcLast1224) {
            now.setHours(this.mrcLastHour);
        } else if (this.mrcLastAmPm) {
            now.setHours(this.mrcLastHour);
        } else {
            now.setHours(this.mrcLastHour + 12);
        }
        now.setMinutes(this.mrcLastMinute);
        now.setSeconds(0);
        if (this.clockMode == 1) {
            this.internalClock.userSetTime(now);
        }
    }

    private void issueClockRatio(int r) {
        log.debug("sending ratio {} to mrc cmd station", (Object)r);
        MrcMessage cmdMrc = MrcMessage.setClockRatio(r);
        this.tc.sendMrcMessage(cmdMrc);
    }

    private void issueClockTime(int hh, int mm) {
        MrcMessage cmdMrc = MrcMessage.setClockTime(hh, mm);
        this.tc.sendMrcMessage(cmdMrc);
    }
}

