/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mqtt;

import javax.annotation.Nonnull;
import jmri.Turnout;
import jmri.implementation.AbstractTurnout;
import jmri.jmrix.mqtt.MqttAdapter;
import jmri.jmrix.mqtt.MqttContentParser;
import jmri.jmrix.mqtt.MqttEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttTurnout
extends AbstractTurnout
implements MqttEventListener {
    private final MqttAdapter mqttAdapter;
    private final String sendTopic;
    private final String rcvTopic;
    MqttContentParser<Turnout> parser = new MqttContentParser<Turnout>(){
        public static final String closedText = "CLOSED";
        public static final String thrownText = "THROWN";
        public static final String unknownText = "UNKNOWN";
        public static final String inconsistentText = "INCONSISTENT";

        int stateFromString(String payload) {
            switch (payload) {
                case "CLOSED": {
                    return 2;
                }
                case "THROWN": {
                    return 4;
                }
                case "UNKNOWN": {
                    return 1;
                }
                case "INCONSISTENT": {
                    return 8;
                }
            }
            log.warn("Unknown state : {}, substitute UNKNOWN", (Object)payload);
            return 1;
        }

        @Override
        public void beanFromPayload(@Nonnull Turnout bean, @Nonnull String payload, @Nonnull String topic) {
            int state = this.stateFromString(payload);
            boolean couldBeSendMessage = topic.endsWith(MqttTurnout.this.sendTopic);
            boolean couldBeRcvMessage = topic.endsWith(MqttTurnout.this.rcvTopic);
            if (couldBeSendMessage) {
                MqttTurnout.this.newCommandedState(state);
                if (MqttTurnout.this.getFeedbackMode() == 1 || MqttTurnout.this.getFeedbackMode() == 8) {
                    MqttTurnout.this.newKnownState(state);
                }
                return;
            }
            if (couldBeRcvMessage) {
                if (MqttTurnout.this.getFeedbackMode() == 1 || MqttTurnout.this.getFeedbackMode() == 8) {
                    MqttTurnout.this.newKnownState(state);
                }
                return;
            }
            log.warn("expected failure to decode topic {} {}", (Object)topic, (Object)payload);
        }

        @Override
        @Nonnull
        public String payloadFromBean(@Nonnull Turnout bean, int newState) {
            String text = "";
            try {
                text = MqttTurnout.this.stateChangeCheck(newState) ? closedText : thrownText;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.error("new state invalid, Turnout not set");
            }
            return text;
        }
    };
    private static final Logger log = LoggerFactory.getLogger(MqttTurnout.class);

    MqttTurnout(MqttAdapter ma, String systemName, String sendTopic, String rcvTopic) {
        super(systemName);
        this.sendTopic = sendTopic;
        this.rcvTopic = rcvTopic;
        this.mqttAdapter = ma;
        this.mqttAdapter.subscribe(rcvTopic, this);
        this._validFeedbackNames = new String[]{"DIRECT", "ONESENSOR", "TWOSENSOR", "DELAYED", "MONITORING"};
        this._validFeedbackModes = new int[]{1, 16, 32, 128, 8};
        this._validFeedbackTypes = 185;
    }

    public void setParser(MqttContentParser<Turnout> parser) {
        this.parser = parser;
    }

    @Override
    public boolean canInvert() {
        return true;
    }

    @Override
    protected void forwardCommandChangeToLayout(int s) {
        String payload = this.parser.payloadFromBean(this, s);
        this.sendMessage(payload);
    }

    private void sendMessage(String c) {
        this.mqttAdapter.publish(this.sendTopic, c);
    }

    @Override
    public void notifyMqttMessage(String receivedTopic, String message) {
        if (!receivedTopic.endsWith(this.rcvTopic) && !receivedTopic.endsWith(this.sendTopic)) {
            log.error("Got a message whose topic ({}) wasn't for me ({})", (Object)receivedTopic, (Object)this.rcvTopic);
            return;
        }
        this.parser.beanFromPayload(this, message, receivedTopic);
    }

    @Override
    protected void turnoutPushbuttonLockout(boolean _pushButtonLockout) {
        log.warn("Send command to {} Pushbutton in {} not yet coded", (Object)(_pushButtonLockout ? "Lock" : "Unlock"), (Object)this.getSystemName());
    }
}

