/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mqtt;

import java.util.Comparator;
import java.util.ResourceBundle;
import jmri.InstanceManager;
import jmri.LightManager;
import jmri.NamedBean;
import jmri.SensorManager;
import jmri.TurnoutManager;
import jmri.jmrix.ConfiguringSystemConnectionMemo;
import jmri.jmrix.DefaultSystemConnectionMemo;
import jmri.jmrix.mqtt.MqttAdapter;
import jmri.jmrix.mqtt.MqttLightManager;
import jmri.jmrix.mqtt.MqttSensorManager;
import jmri.jmrix.mqtt.MqttTurnoutManager;
import jmri.util.NamedBeanComparator;

public class MqttSystemConnectionMemo
extends DefaultSystemConnectionMemo
implements ConfiguringSystemConnectionMemo {
    private MqttAdapter mqttAdapter;

    public MqttSystemConnectionMemo() {
        super("M", "MQTT");
        InstanceManager.store(this, MqttSystemConnectionMemo.class);
    }

    @Override
    public void configureManagers() {
        InstanceManager.setTurnoutManager(this.getTurnoutManager());
        InstanceManager.setSensorManager(this.getSensorManager());
        InstanceManager.setLightManager(this.getLightManager());
        this.register();
    }

    @Override
    protected ResourceBundle getActionModelResourceBundle() {
        return null;
    }

    @Override
    public <B extends NamedBean> Comparator<B> getNamedBeanComparator(Class<B> type) {
        return new NamedBeanComparator();
    }

    public MqttTurnoutManager getTurnoutManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (MqttTurnoutManager)this.classObjectMap.computeIfAbsent(TurnoutManager.class, c -> {
            MqttTurnoutManager t = new MqttTurnoutManager(this);
            t.setSendTopicPrefix(this.getMqttAdapter().getOptionState("10.3"));
            t.setRcvTopicPrefix(this.getMqttAdapter().getOptionState("10.5"));
            return t;
        });
    }

    public MqttSensorManager getSensorManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (MqttSensorManager)this.classObjectMap.computeIfAbsent(SensorManager.class, c -> {
            MqttSensorManager t = new MqttSensorManager(this);
            t.setSendTopicPrefix(this.getMqttAdapter().getOptionState("11.3"));
            t.setRcvTopicPrefix(this.getMqttAdapter().getOptionState("11.5"));
            return t;
        });
    }

    public MqttLightManager getLightManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (MqttLightManager)this.classObjectMap.computeIfAbsent(LightManager.class, c -> {
            MqttLightManager t = new MqttLightManager(this);
            t.setSendTopicPrefix(this.getMqttAdapter().getOptionState("12.3"));
            t.setRcvTopicPrefix(this.getMqttAdapter().getOptionState("12.5"));
            return t;
        });
    }

    void setMqttAdapter(MqttAdapter ma) {
        this.mqttAdapter = ma;
    }

    public MqttAdapter getMqttAdapter() {
        return this.mqttAdapter;
    }
}

