/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.marklin.swing.monitor;

import jmri.jmrix.marklin.MarklinReply;
import jmri.jmrix.marklin.swing.monitor.Bundle;

public class MarklinMon {
    public static String displayReply(MarklinReply r) {
        StringBuffer sb = new StringBuffer();
        sb.append("Priority ");
        switch (r.getPriority()) {
            case 0: {
                sb.append("1, Stop/Go/Short");
                break;
            }
            case 1: {
                sb.append("2, Feedback");
                break;
            }
            case 2: {
                sb.append("3, Engine Stop");
                break;
            }
            case 3: {
                sb.append("4, Engine/accessory command");
                break;
            }
            default: {
                sb.append(Bundle.getMessage("StateUnknown"));
            }
        }
        sb.append(" Command: ");
        int command = r.getCommand();
        if (command == 0) {
            sb.append("System");
        } else if (command >= 1 && command <= 10) {
            switch (r.getCommand()) {
                case 5: {
                    sb.append("Change of direction " + r.getElement(9));
                    break;
                }
                case 4: {
                    sb.append("Change of speed " + ((r.getElement(9) & 0xFF00) + (r.getElement(10) & 0xFF)));
                    break;
                }
                case 6: {
                    sb.append("Function: " + r.getElement(9) + " state: " + r.getElement(10));
                    break;
                }
                default: {
                    sb.append("Management");
                    break;
                }
            }
        } else if (command >= 11 && command <= 13) {
            sb.append("Accessory");
            switch (r.getElement(9)) {
                case 0: {
                    sb.append(Bundle.getMessage("SetTurnoutState", Bundle.getMessage("TurnoutStateThrown")));
                    break;
                }
                case 1: {
                    sb.append(Bundle.getMessage("SetTurnoutState", Bundle.getMessage("TurnoutStateClosed")));
                    break;
                }
                default: {
                    sb.append("Unknown state command " + r.getElement(9));
                    break;
                }
            }
        } else if (command >= 24 && command <= 28) {
            sb.append("Software");
        } else if (command >= 32 && command <= 34) {
            sb.append("GUI");
        } else if (command >= 48 && command <= 255) {
            sb.append("Automation");
        } else if (command >= 16 && command <= 18) {
            sb.append("Feedback");
        }
        if (r.isResponse()) {
            sb.append(" " + Bundle.getMessage("ReplyMessage"));
        } else {
            sb.append(" " + Bundle.getMessage("RequestMessage"));
        }
        long addr = r.getAddress();
        if (addr >= 0L && addr <= 1023L) {
            if (addr == 0L) {
                sb.append(" Broadcast");
            } else {
                sb.append(" " + Bundle.getMessage("MonTrafToLocoAddress", addr));
            }
        } else if (addr >= 4096L && addr <= 5119L) {
            sb.append(" to MM Function decoder " + (addr -= 4096L));
        } else if (addr >= 8192L && addr <= 9215L) {
            sb.append(" " + Bundle.getMessage("MonTrafToLocoAddress", addr -= 8192L));
        } else if (addr >= 2048L && addr <= 3071L) {
            sb.append(" to SX Address " + (addr -= 2048L));
        } else if (addr >= 10240L && addr <= 11263L) {
            sb.append(" to SX Accessory Address " + (addr -= 10240L));
        } else if (addr >= 12288L && addr <= 13311L) {
            sb.append(" to MM Accessory Address " + (addr -= 12288L));
        } else if (addr >= 14336L && addr <= 16383L) {
            sb.append(" to DCC Accessory Address " + (addr -= 14336L));
        } else if (addr >= 16384L && addr <= 32767L) {
            sb.append(" to MFX Address " + (addr -= 16384L));
        } else if (addr >= 32768L && addr <= 49151L) {
            sb.append(" to SX2 Address " + (addr -= 32768L));
        } else if (addr >= 49152L && addr <= 65535L) {
            sb.append(" to DCC Address " + (addr -= 49152L));
        }
        sb.append("0x" + Integer.toHexString(r.getCanData()[0]));
        int i = 1;
        while (i < r.getCanData().length) {
            sb.append(", 0x" + Integer.toHexString(r.getCanData()[i]));
            ++i;
        }
        return sb.toString();
    }
}

