/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.marklin.swing;

import javax.swing.JMenu;
import javax.swing.JSeparator;
import jmri.InstanceManager;
import jmri.jmrit.beantable.ListedTableFrame;
import jmri.jmrix.marklin.MarklinSystemConnectionMemo;
import jmri.jmrix.marklin.swing.Bundle;
import jmri.jmrix.marklin.swing.MarklinNamedPaneAction;
import jmri.util.swing.sdi.JmriJFrameInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarklinMenu
extends JMenu {
    Item[] panelItems = new Item[]{new Item("MenuItemMarklinMonitor", "jmri.jmrix.marklin.swing.monitor.MarklinMonPane"), new Item("MenuItemSendPacket", "jmri.jmrix.marklin.swing.packetgen.PacketGenPanel")};
    private static final Logger log = LoggerFactory.getLogger(MarklinMenu.class);

    public MarklinMenu(MarklinSystemConnectionMemo memo) {
        if (memo != null) {
            this.setText(memo.getUserName());
        } else {
            this.setText(Bundle.getMessage("MenuMarklin"));
        }
        JmriJFrameInterface wi = new JmriJFrameInterface();
        Item[] itemArray = this.panelItems;
        int n = this.panelItems.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            if (item == null) {
                this.add(new JSeparator());
            } else {
                this.add(new MarklinNamedPaneAction(Bundle.getMessage(item.name), wi, item.load, memo));
            }
            ++n2;
        }
        if (InstanceManager.getNullableDefault(ListedTableFrame.class) == null) {
            try {
                new ListedTableFrame();
            }
            catch (NullPointerException nullPointerException) {
                log.error("Unable to register Marklin table");
            }
        }
    }

    static class Item {
        String name;
        String load;

        Item(String name, String load) {
            this.name = name;
            this.load = load;
        }
    }
}

