/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.marklin.networkdriver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramSocket;
import jmri.jmrix.ConnectionStatus;
import jmri.jmrix.marklin.MarklinPortController;
import jmri.jmrix.marklin.MarklinSystemConnectionMemo;
import jmri.jmrix.marklin.MarklinTrafficController;
import jmri.util.com.rbnb.UDPInputStream;
import jmri.util.com.rbnb.UDPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkDriverAdapter
extends MarklinPortController {
    protected DatagramSocket datagramSocketConn = null;
    private static final Logger log = LoggerFactory.getLogger(NetworkDriverAdapter.class);

    public NetworkDriverAdapter() {
        super(new MarklinSystemConnectionMemo());
        this.allowConnectionRecovery = true;
        this.manufacturerName = "Marklin";
        this.m_port = 15731;
    }

    @Override
    public void setPort(int p) {
    }

    @Override
    public void setPort(String p) {
    }

    @Override
    public void connect() {
        this.opened = false;
        if (this.m_HostName == null) {
            log.error("No host name or port set :{}:{}", (Object)this.m_HostName, (Object)this.m_port);
            return;
        }
        try {
            this.opened = true;
        }
        catch (Exception e) {
            log.error("a error opening network connection: {}", (Throwable)e);
            if (this.m_port != 0) {
                ConnectionStatus.instance().setConnectionState(null, String.valueOf(this.m_HostName) + ":" + this.m_port, "Not Connected");
            } else {
                ConnectionStatus.instance().setConnectionState(null, this.m_HostName, "Not Connected");
            }
            throw e;
        }
        if (this.opened && this.m_port != 0) {
            ConnectionStatus.instance().setConnectionState(null, String.valueOf(this.m_HostName) + ":" + this.m_port, "Connected");
        } else if (this.opened) {
            ConnectionStatus.instance().setConnectionState(null, this.m_HostName, "Connected");
        }
    }

    @Override
    public DataInputStream getInputStream() {
        if (!this.opened) {
            log.error("getInputStream called before load(), stream not available");
            if (this.m_port != 0) {
                ConnectionStatus.instance().setConnectionState(null, String.valueOf(this.m_HostName) + ":" + this.m_port, "Not Connected");
            } else {
                ConnectionStatus.instance().setConnectionState(null, this.m_HostName, "Not Connected");
            }
        }
        try {
            return new DataInputStream(new UDPInputStream(null, 15730));
        }
        catch (IOException ex1) {
            log.error("an Exception getting input stream", (Throwable)ex1);
            return null;
        }
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (!this.opened) {
            log.error("getOutputStream called before load(), stream not available");
        }
        try {
            return new DataOutputStream(new UDPOutputStream(this.m_HostName, 15731));
        }
        catch (IOException e) {
            log.error("getOutputStream exception", (Throwable)e);
            if (this.m_port != 0) {
                ConnectionStatus.instance().setConnectionState(null, String.valueOf(this.m_HostName) + ":" + this.m_port, "Not Connected");
            } else {
                ConnectionStatus.instance().setConnectionState(null, this.m_HostName, "Not Connected");
            }
            return null;
        }
    }

    @Override
    public void configure() {
        MarklinTrafficController control = new MarklinTrafficController();
        control.connectPort(this);
        control.setAdapterMemo(this.getSystemConnectionMemo());
        this.getSystemConnectionMemo().setMarklinTrafficController(control);
        this.getSystemConnectionMemo().configureManagers();
    }

    @Override
    public boolean status() {
        return this.opened;
    }
}

