/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.marklin;

import java.util.TimerTask;
import jmri.implementation.AbstractTurnout;
import jmri.jmrix.marklin.MarklinListener;
import jmri.jmrix.marklin.MarklinMessage;
import jmri.jmrix.marklin.MarklinReply;
import jmri.jmrix.marklin.MarklinTrafficController;
import jmri.util.TimerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarklinTurnout
extends AbstractTurnout
implements MarklinListener {
    String prefix;
    MarklinTrafficController tc;
    int _number;
    static final int UNKNOWN = 0;
    static final int DCC = 2;
    static final int MM2 = 8;
    static final int SFX = 4;
    int protocol = 0;
    static final int METERINTERVAL = 100;
    private static final Logger log = LoggerFactory.getLogger(MarklinTurnout.class);

    public MarklinTurnout(int number, String prefix, MarklinTrafficController etc) {
        super(String.valueOf(prefix) + "T" + number);
        this._number = number;
        this.prefix = prefix;
        this.tc = etc;
        this.tc.addMarklinListener(this);
    }

    @Override
    protected void forwardCommandChangeToLayout(int newState) {
        if ((newState & 2) != 0) {
            if ((newState & 4) != 0) {
                log.error("Cannot command both CLOSED and THROWN {}", (Object)newState);
                return;
            }
            this.sendMessage(!this.getInverted());
        } else {
            this.sendMessage(this.getInverted());
        }
    }

    synchronized void setCommandedStateFromCS(int state) {
        if (this.getFeedbackMode() != 1) {
            return;
        }
        this.newCommandedState(state);
    }

    synchronized void setKnownStateFromCS(int state) {
        this.newCommandedState(state);
        if (this.getFeedbackMode() == 1) {
            this.newKnownState(state);
        }
    }

    @Override
    public void turnoutPushbuttonLockout(boolean b) {
    }

    @Override
    public boolean canInvert() {
        return true;
    }

    protected void sendMessage(boolean newstate) {
        MarklinMessage m = MarklinMessage.getSetTurnout(this.getCANAddress(), newstate ? 1 : 0, 1);
        this.tc.sendMarklinMessage(m, this);
        TimerUtil.schedule(new TimerTask(newstate){
            boolean state;
            {
                this.state = bl;
            }

            @Override
            public void run() {
                try {
                    MarklinTurnout.this.sendOffMessage(this.state ? 1 : 0);
                }
                catch (Exception e) {
                    log.error("Exception occurred while sending delayed off to turnout: {}", (Throwable)e);
                }
            }
        }, 100L);
    }

    int getCANAddress() {
        switch (this.protocol) {
            case 2: {
                return this._number + 14336 - 1;
            }
        }
        return this._number + 12288 - 1;
    }

    @Override
    public void reply(MarklinReply m) {
        if (m.getPriority() == 0 && m.getCommand() >= 11 && m.getCommand() <= 13) {
            if (this.protocol == 0) {
                if (m.getAddress() == (long)(this._number + 12288 - 1)) {
                    this.protocol = 8;
                } else if (m.getAddress() == (long)(this._number + 14336 - 1)) {
                    this.protocol = 2;
                } else {
                    return;
                }
            }
            if (m.getAddress() == (long)this.getCANAddress()) {
                switch (m.getElement(9)) {
                    case 0: {
                        this.setKnownStateFromCS(4);
                        break;
                    }
                    case 1: {
                        this.setKnownStateFromCS(2);
                        break;
                    }
                    default: {
                        log.warn("Unknown state command {}", (Object)m.getElement(9));
                    }
                }
            }
        }
    }

    @Override
    public void message(MarklinMessage m) {
    }

    protected void sendOffMessage(int state) {
        MarklinMessage m = MarklinMessage.getSetTurnout(this.getCANAddress(), state, 0);
        this.tc.sendMarklinMessage(m, this);
    }
}

