/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.marklin;

import java.util.EnumSet;
import jmri.DccThrottle;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.ThrottleListener;
import jmri.jmrix.AbstractThrottleManager;
import jmri.jmrix.marklin.MarklinListener;
import jmri.jmrix.marklin.MarklinMessage;
import jmri.jmrix.marklin.MarklinReply;
import jmri.jmrix.marklin.MarklinSystemConnectionMemo;
import jmri.jmrix.marklin.MarklinThrottle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarklinThrottleManager
extends AbstractThrottleManager
implements MarklinListener {
    private static final Logger log = LoggerFactory.getLogger(MarklinThrottleManager.class);

    public MarklinThrottleManager(MarklinSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    public void reply(MarklinReply m) {
    }

    @Override
    public void message(MarklinMessage m) {
    }

    @Override
    public void requestThrottleSetup(LocoAddress address, boolean control) {
        log.debug("new MarklinThrottle for {}", (Object)address);
        this.notifyThrottleKnown(new MarklinThrottle((MarklinSystemConnectionMemo)this.adapterMemo, address), address);
    }

    @Override
    public boolean hasDispatchFunction() {
        return false;
    }

    @Override
    public boolean canBeLongAddress(int address) {
        return MarklinThrottleManager.isLongAddress(address);
    }

    @Override
    public boolean canBeShortAddress(int address) {
        return !MarklinThrottleManager.isLongAddress(address);
    }

    @Override
    public boolean addressTypeUnique() {
        return false;
    }

    @Override
    protected boolean singleUse() {
        return false;
    }

    @Override
    public String[] getAddressTypes() {
        return new String[]{LocoAddress.Protocol.DCC.getPeopleName(), LocoAddress.Protocol.MFX.getPeopleName(), LocoAddress.Protocol.MOTOROLA.getPeopleName()};
    }

    @Override
    public LocoAddress.Protocol[] getAddressProtocolTypes() {
        return new LocoAddress.Protocol[]{LocoAddress.Protocol.DCC, LocoAddress.Protocol.MFX, LocoAddress.Protocol.MOTOROLA};
    }

    static boolean isLongAddress(int num) {
        return num >= 100;
    }

    @Override
    public EnumSet<SpeedStepMode> supportedSpeedModes() {
        return EnumSet.of(SpeedStepMode.NMRA_DCC_128, SpeedStepMode.NMRA_DCC_28);
    }

    @Override
    public boolean disposeThrottle(DccThrottle t, ThrottleListener l) {
        if (super.disposeThrottle(t, l) && t instanceof MarklinThrottle) {
            MarklinThrottle lnt = (MarklinThrottle)t;
            lnt.throttleDispose();
            return true;
        }
        return false;
    }
}

