/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.marklin;

import java.util.Hashtable;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.Sensor;
import jmri.jmrix.marklin.Bundle;
import jmri.jmrix.marklin.MarklinListener;
import jmri.jmrix.marklin.MarklinMessage;
import jmri.jmrix.marklin.MarklinReply;
import jmri.jmrix.marklin.MarklinSensor;
import jmri.jmrix.marklin.MarklinSystemConnectionMemo;
import jmri.jmrix.marklin.MarklinTrafficController;
import jmri.managers.AbstractSensorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarklinSensorManager
extends AbstractSensorManager
implements MarklinListener {
    MarklinTrafficController tc;
    private Hashtable<Integer, Hashtable<Integer, MarklinSensor>> _tmarklin = new Hashtable();
    private int board = 0;
    private int port = 0;
    private static final Logger log = LoggerFactory.getLogger(MarklinSensorManager.class);

    public MarklinSensorManager(MarklinSystemConnectionMemo memo) {
        super(memo);
        this.tc = memo.getTrafficController();
        this.tc.addMarklinListener(this);
    }

    @Override
    @Nonnull
    public MarklinSystemConnectionMemo getMemo() {
        return (MarklinSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Sensor createNewSensor(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        MarklinSensor s = new MarklinSensor(systemName, userName);
        if (systemName.contains(":")) {
            int board = 0;
            int channel = 0;
            String curAddress = systemName.substring(this.getSystemPrefix().length() + 1, systemName.length());
            int seperator = curAddress.indexOf(":");
            try {
                board = Integer.parseInt(curAddress.substring(0, seperator));
                if (!this._tmarklin.containsKey(board)) {
                    this._tmarklin.put(board, new Hashtable());
                    MarklinMessage m = MarklinMessage.sensorPollMessage(board);
                    this.tc.sendMarklinMessage(m, this);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Unable to convert " + curAddress + " into the Module and port format of nn:xx");
            }
            Hashtable<Integer, MarklinSensor> sensorList = this._tmarklin.get(board);
            try {
                channel = Integer.parseInt(curAddress.substring(seperator + 1));
                if (!sensorList.containsKey(channel)) {
                    sensorList.put(channel, s);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Unable to convert " + curAddress + " into the Module and port format of nn:xx");
            }
        }
        return s;
    }

    @Override
    @Nonnull
    public String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        if (!curAddress.contains(":")) {
            throw new JmriException("Hardware Address " + curAddress + "should be passed in the form 'Module:port'");
        }
        int seperator = curAddress.indexOf(":");
        try {
            this.board = Integer.parseInt(curAddress.substring(0, seperator));
        }
        catch (NumberFormatException numberFormatException) {
            throw new JmriException("First part of " + curAddress + " in front of : should be a number");
        }
        try {
            this.port = Integer.parseInt(curAddress.substring(seperator + 1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new JmriException("Second part of " + curAddress + " after : should be a number");
        }
        if (this.port == 0 || this.port > 16) {
            throw new JmriException("Port number " + this.port + " in " + curAddress + " must be between 1 and 16");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getSystemPrefix());
        sb.append("S");
        sb.append(this.board);
        sb.append(":");
        this.padPortNumber(this.port, sb);
        return sb.toString();
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    public String getNextValidAddress(@Nonnull String curAddress, @Nonnull String prefix, boolean ignoreInitialExisting) throws JmriException {
        String tmpSName = this.createSystemName(curAddress, prefix);
        Sensor s = this.getBySystemName(tmpSName);
        if (s != null || ignoreInitialExisting) {
            ++this.port;
            while (this.port < 17) {
                tmpSName = this.createSystemName(String.valueOf(this.board) + ":" + this.port, prefix);
                s = this.getBySystemName(tmpSName);
                if (s == null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(this.board);
                    sb.append(":");
                    this.padPortNumber(this.port, sb);
                    return sb.toString();
                }
                ++this.port;
            }
            throw new JmriException(Bundle.getMessage("InvalidNextValidTenInUse", this.getBeanTypeHandled(true), curAddress, tmpSName));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.board);
        sb.append(":");
        this.padPortNumber(this.port, sb);
        return sb.toString();
    }

    void padPortNumber(int portNo, StringBuilder sb) {
        if (portNo < 10) {
            sb.append("0");
        }
        sb.append(portNo);
    }

    @Override
    public void reply(MarklinReply r) {
        if (r.getPriority() == 0 && r.getCommand() >= 16 && r.getCommand() <= 18) {
            if (r.getCommand() == 17) {
                MarklinSensor ms;
                int module = r.getElement(5);
                module = (module << 8) + r.getElement(6);
                int contact = r.getElement(7);
                contact = (contact << 8) + r.getElement(8);
                String sensorprefix = String.valueOf(this.getSystemPrefix()) + "S" + module + ":";
                Hashtable<Integer, MarklinSensor> sensorList = this._tmarklin.get(module);
                if (sensorList == null) {
                    sensorList = new Hashtable();
                    this._tmarklin.put(module, sensorList);
                    MarklinMessage m = MarklinMessage.sensorPollMessage(module);
                    this.tc.sendMarklinMessage(m, this);
                    if (log.isDebugEnabled()) {
                        log.debug("New module added {}", (Object)module);
                    }
                }
                if ((ms = sensorList.get(contact)) == null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(sensorprefix);
                    this.padPortNumber(contact, sb);
                    if (log.isDebugEnabled()) {
                        log.debug("New sensor added {} : {}", (Object)contact, (Object)sb.toString());
                    }
                    ms = (MarklinSensor)this.provideSensor(sb.toString());
                }
                if (r.getElement(9) == 1) {
                    ms.setOwnState(4);
                    return;
                }
                if (r.getElement(10) == 1) {
                    ms.setOwnState(2);
                    return;
                }
                log.error("state not found {} {} {}", new Object[]{ms.getDisplayName(), r.getElement(9), r.getElement(10)});
                log.error(r.toString());
            } else {
                int s88Module = r.getElement(9);
                if (this._tmarklin.containsKey(s88Module)) {
                    int status = r.getElement(10);
                    status = (status << 8) + r.getElement(11);
                    this.decodeSensorState(s88Module, status);
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug("State s88Module not registered {}", (Object)s88Module);
                }
            }
        }
    }

    @Override
    public void message(MarklinMessage m) {
    }

    private void decodeSensorState(int board, int intState) {
        int k = 1;
        String sensorprefix = String.valueOf(this.getSystemPrefix()) + "S" + board + ":";
        Hashtable<Integer, MarklinSensor> sensorList = this._tmarklin.get(board);
        int portNo = 1;
        while (portNo < 17) {
            int result = intState & k;
            MarklinSensor ms = sensorList.get(portNo);
            if (ms == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(sensorprefix);
                this.padPortNumber(portNo, sb);
                ms = (MarklinSensor)this.provideSensor(sb.toString());
            }
            if (result == 0) {
                ms.setOwnState(4);
            } else {
                ms.setOwnState(2);
            }
            k *= 2;
            ++portNo;
        }
    }
}

