/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.marklin;

import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.marklin.swing.monitor.MarklinMon;

public class MarklinReply
extends AbstractMRReply {
    public MarklinReply() {
    }

    public MarklinReply(String s) {
        super(s);
    }

    public MarklinReply(MarklinReply l) {
        super(l);
    }

    public MarklinReply(int[] d) {
        this();
        this._nDataChars = d.length;
        System.arraycopy(d, 0, this._dataChars, 0, d.length);
    }

    @Override
    public int maxSize() {
        return 13;
    }

    @Override
    protected int skipPrefix(int index) {
        return index;
    }

    @Override
    public int value() {
        if (this.isBinary()) {
            return this.getElement(0);
        }
        return super.value();
    }

    @Override
    public int getElement(int n) {
        return super.getElement(n) & 0xFF;
    }

    @Override
    public boolean isUnsolicited() {
        return !this.isResponse();
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("0x").append(Integer.toHexString(this._dataChars[0]));
        int i = 1;
        while (i < this._nDataChars) {
            buf.append(", 0x").append(Integer.toHexString(this._dataChars[i]));
            ++i;
        }
        return buf.toString();
    }

    @Override
    public String toMonitorString() {
        return MarklinMon.displayReply(this);
    }

    public boolean isResponse() {
        return (this.getElement(1) & 1) == 1;
    }

    public int getCanDataLength() {
        return this.getElement(4);
    }

    public int[] getCanData() {
        int[] arr = new int[this.maxSize() - 5];
        int i = 5;
        while (i < this.maxSize()) {
            arr[i - 5] = this.getElement(i);
            ++i;
        }
        return arr;
    }

    public int[] getCanAddress() {
        int[] arr = new int[4];
        int i = 5;
        while (i < 9) {
            arr[i - 5] = this.getElement(i);
            ++i;
        }
        return arr;
    }

    public long getAddress() {
        long addr = this.getElement(5);
        addr = (addr << 8) + (long)this.getElement(6);
        addr = (addr << 8) + (long)this.getElement(7);
        addr = (addr << 8) + (long)this.getElement(8);
        return addr;
    }

    public int getPriority() {
        return this.getElement(0) >> 4;
    }

    public int getCommand() {
        int result = this.getElement(0) << 7;
        result = result + this.getElement(1) >> 1;
        return result;
    }

    public int[] getHash() {
        int[] arr = new int[]{this.getElement(2), this.getElement(3)};
        return arr;
    }
}

