/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.marklin;

import jmri.JmriException;
import jmri.jmrix.marklin.MarklinListener;
import jmri.jmrix.marklin.MarklinMessage;
import jmri.jmrix.marklin.MarklinReply;
import jmri.jmrix.marklin.MarklinSystemConnectionMemo;
import jmri.jmrix.marklin.MarklinTrafficController;
import jmri.managers.AbstractPowerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarklinPowerManager
extends AbstractPowerManager<MarklinSystemConnectionMemo>
implements MarklinListener {
    MarklinTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(MarklinPowerManager.class);

    public MarklinPowerManager(MarklinTrafficController etc) {
        super(etc.adaptermemo);
        this.tc = etc;
        this.tc.addMarklinListener(this);
    }

    @Override
    public void setPower(int v) throws JmriException {
        int old = this.power;
        this.power = 1;
        this.checkTC();
        if (v == 2) {
            MarklinMessage l = MarklinMessage.getEnableMain();
            this.tc.sendMarklinMessage(l, this);
        } else if (v == 4) {
            MarklinMessage l = MarklinMessage.getKillMain();
            this.tc.sendMarklinMessage(l, this);
        }
        this.firePowerPropertyChange(old, this.power);
    }

    @Override
    public void dispose() throws JmriException {
        this.tc.removeMarklinListener(this);
        this.tc = null;
    }

    private void checkTC() throws JmriException {
        if (this.tc == null) {
            throw new JmriException("attempt to use MarklinPowerManager after dispose");
        }
    }

    @Override
    public void reply(MarklinReply m) {
        int old = this.power;
        if (m.getPriority() == 0 && m.getCommand() == 0 && m.getAddress() == 0L) {
            switch (m.getElement(9)) {
                case 1: {
                    this.power = 2;
                    break;
                }
                case 0: 
                case 2: {
                    this.power = 4;
                    break;
                }
                default: {
                    log.warn("Unknown sub command {}", (Object)m.getElement(9));
                }
            }
            this.firePowerPropertyChange(old, this.power);
        }
    }

    @Override
    public void message(MarklinMessage m) {
    }
}

