/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.maple.simulator;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import javax.swing.Timer;
import jmri.jmrix.maple.MapleSystemConnectionMemo;
import jmri.jmrix.maple.SerialMessage;
import jmri.jmrix.maple.SerialPortController;
import jmri.jmrix.maple.SerialReply;
import jmri.jmrix.maple.simulator.Bundle;
import jmri.util.ImmediatePipedOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulatorAdapter
extends SerialPortController
implements Runnable {
    private boolean opened = false;
    private Thread sourceThread;
    private boolean outputBufferEmpty = true;
    private boolean checkBuffer = true;
    int signalBankSize = 16;
    int sensorBankSize = 64;
    Timer timer;
    private DataOutputStream pout = null;
    private DataInputStream pin = null;
    private DataOutputStream outpipe = null;
    private DataInputStream inpipe = null;
    private static final Logger log = LoggerFactory.getLogger(SimulatorAdapter.class);

    public SimulatorAdapter() {
        super(new MapleSystemConnectionMemo("K", Bundle.getMessage("MapleSimulatorName")));
        this.setManufacturer("Maple Systems");
    }

    @Override
    public String openPort(String portName, String appName) {
        try {
            ImmediatePipedOutputStream tempPipeI = new ImmediatePipedOutputStream();
            log.debug("tempPipeI created");
            this.pout = new DataOutputStream(tempPipeI);
            this.inpipe = new DataInputStream(new PipedInputStream(tempPipeI));
            log.debug("inpipe created {}", (Object)(this.inpipe != null ? 1 : 0));
            ImmediatePipedOutputStream tempPipeO = new ImmediatePipedOutputStream();
            this.outpipe = new DataOutputStream(tempPipeO);
            this.pin = new DataInputStream(new PipedInputStream(tempPipeO));
        }
        catch (IOException e) {
            log.error("init (pipe): Exception: {}", (Object)e.toString());
        }
        this.opened = true;
        return null;
    }

    public synchronized void setOutputBufferEmpty(boolean s) {
        this.outputBufferEmpty = s;
    }

    public boolean okToSend() {
        if (this.checkBuffer) {
            log.debug("Buffer Empty: {}", (Object)this.outputBufferEmpty);
            return this.outputBufferEmpty;
        }
        log.debug("No Flow Control or Buffer Check");
        return true;
    }

    @Override
    public void configure() {
        log.debug("set tc for memo {}", (Object)this.getSystemConnectionMemo().getUserName());
        ((MapleSystemConnectionMemo)this.getSystemConnectionMemo()).getTrafficController().connectPort(this);
        ((MapleSystemConnectionMemo)this.getSystemConnectionMemo()).configureManagers();
        this.sourceThread = new Thread(this);
        this.sourceThread.setName("Maple Simulator");
        this.sourceThread.setPriority(1);
        this.sourceThread.start();
    }

    @Override
    public void connect() throws IOException {
        log.debug("connect called");
        super.connect();
    }

    @Override
    public DataInputStream getInputStream() {
        if (!this.opened || this.pin == null) {
            log.error("getInputStream called before load(), stream not available");
        }
        log.debug("DataInputStream pin returned");
        return this.pin;
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (!this.opened || this.pout == null) {
            log.error("getOutputStream called before load(), stream not available");
        }
        log.debug("DataOutputStream pout returned");
        return this.pout;
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        log.debug("validBaudRates should not have been invoked");
        return new String[0];
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[0];
    }

    @Override
    public String getCurrentBaudRate() {
        return "";
    }

    @Override
    public String getCurrentPortName() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.info("Maple Simulator Started");
        while (true) {
            SerialReply r;
            int i;
            StringBuffer buf;
            try {
                SimulatorAdapter simulatorAdapter = this;
                synchronized (simulatorAdapter) {
                    this.wait(50L);
                }
            }
            catch (InterruptedException interruptedException) {
                log.debug("interrupted, ending");
                return;
            }
            SerialMessage m = this.readMessage();
            if (log.isDebugEnabled()) {
                buf = new StringBuffer();
                buf.append("Maple Simulator Thread received message: ");
                if (m != null) {
                    i = 0;
                    while (i < m.getNumDataElements()) {
                        buf.append(String.valueOf(Integer.toHexString(0xFF & m.getElement(i))) + " ");
                        ++i;
                    }
                } else {
                    buf.append("null message buffer");
                }
                log.trace(buf.toString());
            }
            if (m == null || (r = this.generateReply(m)) == null) continue;
            this.writeReply(r);
            if (!log.isDebugEnabled()) continue;
            buf = new StringBuffer();
            buf.append("Maple Simulator Thread sent reply: ");
            i = 0;
            while (i < r.getNumDataElements()) {
                buf.append(String.valueOf(Integer.toHexString(0xFF & r.getElement(i))) + " ");
                ++i;
            }
            log.debug(buf.toString());
        }
    }

    private SerialMessage readMessage() {
        SerialMessage msg = null;
        try {
            if (this.inpipe != null && this.inpipe.available() > 0) {
                msg = this.loadChars();
            }
        }
        catch (IOException iOException) {}
        this.setOutputBufferEmpty(true);
        return msg;
    }

    private SerialReply generateReply(SerialMessage msg) {
        log.debug("Generate Reply to message from node {} (string = {})", (Object)msg.getAddress(), (Object)msg.toString());
        SerialReply reply = new SerialReply();
        int nodeAddress = msg.getUA();
        char cmd1 = (char)msg.getElement(3);
        char cmd2 = (char)msg.getElement(4);
        log.debug("Message nodeaddress={} cmd={}{}, Start={}, Num={}", new Object[]{nodeAddress, Character.valueOf(cmd1), Character.valueOf(cmd2), this.getStartAddress(msg), this.getNumberOfCoils(msg)});
        switch ("" + cmd1 + cmd2) {
            case "RC": {
                log.debug("Read Coils (poll) message detected");
                int i = 1;
                log.debug("RC Reply from node {}", (Object)nodeAddress);
                reply.setElement(0, 2);
                reply.setElement(1, msg.getElement(1));
                reply.setElement(2, msg.getElement(2));
                reply.setElement(3, 82);
                reply.setElement(4, 67);
                i = 1;
                while (i < this.getNumberOfCoils(msg)) {
                    reply.setElement(i + 4, 0);
                    ++i;
                }
                reply.setElement(i + 5, 3);
                reply = this.setChecksum(reply, i + 6);
                break;
            }
            case "WC": {
                log.debug("Write Coils message detected");
                log.debug("WC Reply from node {}", (Object)nodeAddress);
                reply.setElement(0, 6);
                reply.setElement(1, msg.getElement(1));
                reply.setElement(2, msg.getElement(2));
                reply.setElement(3, 87);
                reply.setElement(4, 67);
                break;
            }
            default: {
                log.debug("command ignored");
                reply = null;
            }
        }
        log.debug(reply == null ? "Message ignored" : "Reply generated " + reply.toString());
        return reply;
    }

    private int getStartAddress(SerialMessage msg) {
        int a1 = msg.getElement(5) - 48;
        int a2 = msg.getElement(6) - 48;
        int a3 = msg.getElement(7) - 48;
        int a4 = msg.getElement(8) - 48;
        return 1000 * a1 + 100 * a2 + 10 * a3 + a4;
    }

    private int getNumberOfCoils(SerialMessage msg) {
        int n1 = msg.getElement(9) - 48;
        int n2 = msg.getElement(10) - 48;
        return 10 * n1 + n2;
    }

    private void writeReply(SerialReply r) {
        if (r == null) {
            return;
        }
        int i = 0;
        while (i < r.getNumDataElements()) {
            try {
                this.outpipe.writeByte((byte)r.getElement(i));
            }
            catch (IOException iOException) {}
            ++i;
        }
        try {
            this.outpipe.flush();
        }
        catch (IOException iOException) {}
    }

    private SerialMessage loadChars() throws IOException {
        SerialReply reply = new SerialReply();
        ((MapleSystemConnectionMemo)this.getSystemConnectionMemo()).getTrafficController().loadChars(reply, this.inpipe);
        SerialMessage msg = new SerialMessage(reply.getNumDataElements());
        int i = 0;
        while (i < msg.getNumDataElements()) {
            msg.setElement(i, reply.getElement(i));
            ++i;
        }
        log.debug("new message received");
        return msg;
    }

    public SerialReply setChecksum(SerialReply r, int index) {
        int sum = 0;
        int i = 1;
        while (i < index) {
            sum += r.getElement(i);
            ++i;
        }
        int firstVal = (sum &= 0xFF) / 16 & 0xF;
        char firstChar = firstVal > 9 ? (char)(55 + firstVal) : (char)(48 + firstVal);
        r.setElement(index, firstChar);
        int secondVal = sum & 0xF;
        char secondChar = secondVal > 9 ? (char)(55 + secondVal) : (char)(48 + secondVal);
        r.setElement(index + 1, secondChar);
        return r;
    }
}

