/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.maple.serialdriver.configurexml;

import java.util.List;
import jmri.jmrix.configurexml.AbstractSerialConnectionConfigXml;
import jmri.jmrix.maple.InputBits;
import jmri.jmrix.maple.MapleSystemConnectionMemo;
import jmri.jmrix.maple.OutputBits;
import jmri.jmrix.maple.SerialNode;
import jmri.jmrix.maple.serialdriver.ConnectionConfig;
import jmri.jmrix.maple.serialdriver.SerialDriverAdapter;
import org.jdom2.Content;
import org.jdom2.Element;

public class ConnectionConfigXml
extends AbstractSerialConnectionConfigXml {
    @Override
    protected void extendElement(Element e) {
        SerialNode node = (SerialNode)((MapleSystemConnectionMemo)this.adapter.getSystemConnectionMemo()).getTrafficController().getNode(0);
        int index = 1;
        while (node != null) {
            Element n = new Element("node");
            n.setAttribute("name", "" + node.getNodeAddress());
            e.addContent((Content)n);
            n.addContent((Content)this.makeParameter("transmissiondelay", "" + InputBits.getTimeoutTime()));
            n.addContent((Content)this.makeParameter("inputbits", "" + InputBits.getNumInputBits()));
            n.addContent((Content)this.makeParameter("senddelay", "" + OutputBits.getSendDelay()));
            n.addContent((Content)this.makeParameter("outputbits", "" + OutputBits.getNumOutputBits()));
            node = (SerialNode)((MapleSystemConnectionMemo)this.adapter.getSystemConnectionMemo()).getTrafficController().getNode(index);
            ++index;
        }
    }

    protected Element makeParameter(String name, String value) {
        Element p = new Element("parameter");
        p.setAttribute("name", name);
        p.addContent(value);
        return p;
    }

    @Override
    protected void getInstance() {
        if (this.adapter == null) {
            this.adapter = new SerialDriverAdapter();
        }
    }

    @Override
    protected void unpackElement(Element shared, Element perNode) {
        List l = shared.getChildren("node");
        int i = 0;
        while (i < l.size()) {
            Element n = (Element)l.get(i);
            int addr = Integer.parseInt(n.getAttributeValue("name"));
            int delay = Integer.parseInt(this.findParmValue(n, "transmissiondelay"));
            int senddelay = Integer.parseInt(this.findParmValue(n, "senddelay"));
            int numinput = Integer.parseInt(this.findParmValue(n, "inputbits"));
            int numoutput = Integer.parseInt(this.findParmValue(n, "outputbits"));
            SerialNode node = new SerialNode(addr, 0, ((MapleSystemConnectionMemo)this.adapter.getSystemConnectionMemo()).getTrafficController());
            InputBits.setTimeoutTime(delay);
            InputBits.setNumInputBits(numinput);
            OutputBits.setSendDelay(senddelay);
            OutputBits.setNumOutputBits(numoutput);
            ((MapleSystemConnectionMemo)this.adapter.getSystemConnectionMemo()).getTrafficController().initializeSerialNode(node);
            ++i;
        }
    }

    @Override
    protected void register() {
        this.register(new ConnectionConfig(this.adapter));
    }

    @Override
    protected void getInstance(Object object) {
        this.adapter = ((ConnectionConfig)object).getAdapter();
    }
}

