/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.maple.packetgen;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import jmri.jmrix.maple.InputBits;
import jmri.jmrix.maple.MapleSystemConnectionMemo;
import jmri.jmrix.maple.SerialListener;
import jmri.jmrix.maple.SerialMessage;
import jmri.jmrix.maple.SerialReply;
import jmri.jmrix.maple.packetgen.Bundle;
import jmri.util.JmriJFrame;
import jmri.util.StringUtil;

public class SerialPacketGenFrame
extends JmriJFrame
implements SerialListener {
    private MapleSystemConnectionMemo _memo = null;
    JLabel jLabel1 = new JLabel();
    JButton sendButton = new JButton();
    JTextField packetTextField = new JTextField(12);
    JButton pollButton = new JButton(Bundle.getMessage("LabelPoll"));
    protected JSpinner nodeAddrSpinner;

    public SerialPacketGenFrame(MapleSystemConnectionMemo memo) {
        this._memo = memo;
    }

    @Override
    public void initComponents() {
        this.jLabel1.setText(Bundle.getMessage("CommandLabel"));
        this.jLabel1.setVisible(true);
        this.sendButton.setText(Bundle.getMessage("ButtonSend"));
        this.sendButton.setVisible(true);
        this.sendButton.setToolTipText(Bundle.getMessage("TooltipSendPacket"));
        this.packetTextField.setText("");
        this.packetTextField.setToolTipText(Bundle.getMessage("EnterHexToolTip"));
        this.packetTextField.setMaximumSize(new Dimension(this.packetTextField.getMaximumSize().width, this.packetTextField.getPreferredSize().height));
        this.setTitle(Bundle.getMessage("SendXCommandTitle", "Maple"));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.jLabel1);
        this.getContentPane().add(this.packetTextField);
        this.getContentPane().add(this.sendButton);
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SerialPacketGenFrame.this.sendButtonActionPerformed(e);
            }
        });
        this.getContentPane().add(new JSeparator(0));
        JPanel pane3 = new JPanel();
        pane3.setLayout(new FlowLayout());
        pane3.add(new JLabel(Bundle.getMessage("LabelNodeAddress")));
        this.nodeAddrSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 99, 1));
        this.nodeAddrSpinner.setToolTipText(Bundle.getMessage("TooltipNodeAddress"));
        pane3.add(this.nodeAddrSpinner);
        pane3.add(this.pollButton);
        this.getContentPane().add(pane3);
        this.pollButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SerialPacketGenFrame.this.pollButtonActionPerformed(e);
            }
        });
        this.pollButton.setToolTipText(Bundle.getMessage("PollToolTipMulti"));
        this.pack();
    }

    public void pollButtonActionPerformed(ActionEvent e) {
        int endAddr = InputBits.getNumInputBits();
        if (endAddr > 99) {
            endAddr = 99;
        }
        SerialMessage msg = SerialMessage.getPoll((Integer)this.nodeAddrSpinner.getValue(), 1, endAddr);
        this._memo.getTrafficController().sendSerialMessage(msg, this);
    }

    public void sendButtonActionPerformed(ActionEvent e) {
        String input = this.packetTextField.getText();
        this._memo.getTrafficController().sendSerialMessage(this.createPacket(input), this);
    }

    SerialMessage createPacket(String s) {
        byte[] b = StringUtil.bytesFromHexString(s);
        if (b.length == 0) {
            return null;
        }
        SerialMessage m = new SerialMessage(b.length);
        int i = 0;
        while (i < b.length) {
            m.setElement(i, b[i]);
            ++i;
        }
        return m;
    }

    @Override
    public void message(SerialMessage m) {
    }

    @Override
    public void reply(SerialReply r) {
    }
}

