/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.maple;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.swing.JOptionPane;
import jmri.Manager;
import jmri.Turnout;
import jmri.jmrix.maple.Bundle;
import jmri.jmrix.maple.MapleSystemConnectionMemo;
import jmri.jmrix.maple.SerialAddress;
import jmri.jmrix.maple.SerialTurnout;
import jmri.managers.AbstractTurnoutManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialTurnoutManager
extends AbstractTurnoutManager {
    private static final Logger log = LoggerFactory.getLogger(SerialTurnoutManager.class);

    public SerialTurnoutManager(MapleSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public MapleSystemConnectionMemo getMemo() {
        return (MapleSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Turnout createNewTurnout(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        String sName = SerialAddress.normalizeSystemName(systemName, this.getSystemPrefix());
        if (sName.isEmpty()) {
            throw new IllegalArgumentException("Cannot create System Name from " + systemName);
        }
        Turnout t = (Turnout)this.getBySystemName(sName);
        if (t != null) {
            return t;
        }
        int bitNum = SerialAddress.getBitFromSystemName(sName, this.getSystemPrefix());
        if (bitNum == 0) {
            throw new IllegalArgumentException("Cannot get Bit from System Name " + systemName + " " + sName);
        }
        String conflict = SerialAddress.isOutputBitFree(bitNum, this.getSystemPrefix());
        if (!conflict.isEmpty() && !conflict.equals(sName)) {
            log.error("{} assignment conflict with {}.", (Object)sName, (Object)conflict);
            throw new IllegalArgumentException("The output bit " + bitNum + ", is currently assigned to " + conflict + ".");
        }
        t = new SerialTurnout(sName, userName, this.getMemo());
        if (!SerialAddress.validSystemNameConfig(sName, 'T', this.getMemo())) {
            log.warn("Turnout '{}' refers to an unconfigured output bit.", (Object)sName);
            JOptionPane.showMessageDialog(null, "WARNING - The Turnout just added, " + sName + ", refers to an unconfigured output bit.", "Configuration Warning", 1, null);
        }
        return t;
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Deprecated
    public void notifyTurnoutCreationError(String conflict, int bitNum) {
        JOptionPane.showMessageDialog(null, "ERROR - The output bit, " + bitNum + ", is currently assigned to " + conflict + ". Turnout can not be " + "created as you specified.", " Assignment Conflict", 1, null);
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) {
        return SerialAddress.validateSystemNameFormat(name, this, locale);
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return SerialAddress.validSystemNameFormat(systemName, this.typeLetter(), this.getSystemPrefix());
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddOutputEntryToolTip");
    }
}

