/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.maple;

import javax.swing.Timer;
import jmri.implementation.AbstractTurnout;
import jmri.jmrix.maple.MapleSystemConnectionMemo;
import jmri.jmrix.maple.SerialAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialTurnout
extends AbstractTurnout {
    private MapleSystemConnectionMemo _memo = null;
    String tSystemName;
    protected int tBit;
    protected Timer mPulseClosedTimer = null;
    protected Timer mPulseThrownTimer = null;
    protected boolean mPulseTimerOn = false;
    private static final Logger log = LoggerFactory.getLogger(SerialTurnout.class);

    public SerialTurnout(String systemName, String userName, MapleSystemConnectionMemo memo) {
        super(systemName, userName);
        this.tSystemName = systemName;
        this._memo = memo;
        this.tBit = SerialAddress.getBitFromSystemName(systemName, this._memo.getSystemPrefix());
    }

    public SerialTurnout(String systemName, MapleSystemConnectionMemo memo) {
        super(systemName);
        this.tSystemName = systemName;
        this._memo = memo;
        this.tBit = SerialAddress.getBitFromSystemName(systemName, this._memo.getSystemPrefix());
    }

    @Override
    protected void forwardCommandChangeToLayout(int newState) {
        try {
            this.sendMessage(this.stateChangeCheck(newState));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error("new state invalid, Turnout not set");
        }
    }

    @Override
    public boolean canInvert() {
        return true;
    }

    @Override
    protected void turnoutPushbuttonLockout(boolean _pushButtonLockout) {
        if (log.isDebugEnabled()) {
            log.debug("Send command to {} Pushbutton", (Object)(_pushButtonLockout ? "Lock" : "Unlock"));
        }
    }

    protected void sendMessage(boolean closed) {
        if (!this.mPulseTimerOn && this.getNumberOutputBits() == 1 && this.getControlType() == 0) {
            if ((this._memo.getTrafficController().outputBits().getOutputBit(this.tBit) ^ this.getInverted()) != closed) {
                this._memo.getTrafficController().outputBits().setOutputBit(this.tBit, closed ^ this.getInverted());
            } else {
                int kState = this.getKnownState();
                if (closed) {
                    if ((kState & 4) != 0) {
                        this._memo.getTrafficController().outputBits().setOutputBit(this.tBit, this.getInverted());
                    }
                } else if ((kState & 2) != 0) {
                    this._memo.getTrafficController().outputBits().setOutputBit(this.tBit, true ^ this.getInverted());
                }
            }
        }
    }
}

