/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.maple;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.swing.JOptionPane;
import jmri.JmriException;
import jmri.Manager;
import jmri.Sensor;
import jmri.jmrix.maple.Bundle;
import jmri.jmrix.maple.MapleSystemConnectionMemo;
import jmri.jmrix.maple.SerialAddress;
import jmri.jmrix.maple.SerialListener;
import jmri.jmrix.maple.SerialMessage;
import jmri.jmrix.maple.SerialNode;
import jmri.jmrix.maple.SerialReply;
import jmri.jmrix.maple.SerialSensor;
import jmri.managers.AbstractSensorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialSensorManager
extends AbstractSensorManager
implements SerialListener {
    static final int SENSORSPERUA = 1000;
    private int sysNode = 0;
    private int address = 0;
    private int iName = 0;
    private static final Logger log = LoggerFactory.getLogger(SerialSensorManager.class);

    public SerialSensorManager(MapleSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public MapleSystemConnectionMemo getMemo() {
        return (MapleSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Sensor createNewSensor(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        String sName = SerialAddress.normalizeSystemName(systemName, this.getSystemPrefix());
        if (sName.isEmpty()) {
            throw new IllegalArgumentException("Invalid Maple Sensor system name - " + systemName);
        }
        Sensor s = this.getBySystemName(sName);
        if (s != null) {
            throw new IllegalArgumentException("Maple Sensor with this name already exists - " + systemName);
        }
        int bit = SerialAddress.getBitFromSystemName(sName, this.getSystemPrefix());
        if (bit <= 0 || bit > 1000) {
            log.warn("Sensor bit number '{}' is outside the supported range, 1-1000", (Object)Integer.toString(bit));
            throw new IllegalArgumentException("Sensor bit number " + Integer.toString(bit) + " is outside the supported range 1-1000");
        }
        s = userName == null ? new SerialSensor(sName) : new SerialSensor(sName, userName);
        if (!SerialAddress.validSystemNameConfig(sName, 'S', this.getMemo())) {
            log.warn("Sensor system Name '{}' does not address configured hardware.", (Object)sName);
            JOptionPane.showMessageDialog(null, "WARNING - The Sensor just added, " + sName + ", refers to an unconfigured input bit.", "Configuration Warning", 1, null);
        }
        this.getMemo().getTrafficController().inputBits().registerSensor(s, bit - 1);
        return s;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) {
        return SerialAddress.validateSystemNameFormat(name, this, locale);
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return SerialAddress.validSystemNameFormat(systemName, this.typeLetter(), this.getSystemPrefix());
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddInputEntryToolTip");
    }

    @Override
    public void message(SerialMessage r) {
        log.warn("unexpected message");
    }

    @Override
    public void reply(SerialReply r) {
        this.getMemo().getTrafficController().inputBits().markChanges(r);
    }

    public void registerSensorsForNode(SerialNode node) {
        for (Sensor s : this.getNamedBeanSet()) {
            String sName = s.getSystemName();
            log.debug("system name is {}", (Object)sName);
            if (!sName.startsWith(this.getSystemNamePrefix())) continue;
            this.getMemo().getTrafficController().inputBits().registerSensor(s, SerialAddress.getBitFromSystemName(sName, this.getSystemPrefix()) - 1);
        }
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    @Nonnull
    public String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        if (curAddress.contains(":")) {
            int seperator = curAddress.indexOf(":");
            try {
                this.sysNode = Integer.parseInt(curAddress.substring(0, seperator));
                this.address = Integer.parseInt(curAddress.substring(seperator + 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new JmriException("Unable to convert " + curAddress + " into the cab and address format of nn:xx");
            }
            this.iName = this.sysNode * 1000 + this.address;
        } else {
            try {
                this.iName = Integer.parseInt(curAddress);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JmriException("Hardware Address passed " + curAddress + " should be a number or the cab and address format of nn:xx");
            }
        }
        return String.valueOf(prefix) + this.typeLetter() + this.iName;
    }

    @Override
    public String getNextValidAddress(@Nonnull String curAddress, @Nonnull String prefix, boolean ignoreInitialExisting) throws JmriException {
        String tmpSName = this.createSystemName(curAddress, prefix);
        Sensor s = this.getBySystemName(tmpSName);
        if (s != null || ignoreInitialExisting) {
            int x = 1;
            while (x < 10) {
                ++this.iName;
                s = this.getBySystemName(String.valueOf(prefix) + this.typeLetter() + this.iName);
                if (s == null) {
                    return Integer.toString(this.iName);
                }
                ++x;
            }
            throw new JmriException(Bundle.getMessage("InvalidNextValidTenInUse", this.getBeanTypeHandled(true), curAddress, this.iName));
        }
        return Integer.toString(this.iName);
    }
}

