/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.maple;

import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractNode;
import jmri.jmrix.maple.SerialTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialNode
extends AbstractNode {
    static final int MAXSENSORS = 1000;
    private int _address = 0;
    boolean warned = false;
    int timeout = 0;
    private static final Logger log = LoggerFactory.getLogger(SerialNode.class);

    public SerialNode(SerialTrafficController tc) {
        this(1, 0, tc);
    }

    public SerialNode(int address, int type, SerialTrafficController tc) {
        this.setNodeAddress(address);
        this._address = address;
        tc.registerNode(this);
    }

    @Override
    public boolean getSensorsActive() {
        return true;
    }

    @Override
    protected boolean checkNodeAddress(int address) {
        return address > 0 && address <= 99;
    }

    public int getAddress() {
        return this._address;
    }

    @Override
    public AbstractMRMessage createInitPacket() {
        return null;
    }

    @Override
    public AbstractMRMessage createOutPacket() {
        return null;
    }

    void warn(String s) {
        if (this.warned) {
            return;
        }
        this.warned = true;
        log.warn(s);
    }

    @Override
    public boolean handleTimeout(AbstractMRMessage m, AbstractMRListener l) {
        ++this.timeout;
        log.warn("Poll of node {} timed out. Timeout count = {}", (Object)this._address, (Object)this.timeout);
        return false;
    }

    @Override
    public void resetTimeout(AbstractMRMessage m) {
        if (this.timeout > 0) {
            log.debug("Reset {} timeout count", (Object)this.timeout);
        }
        this.timeout = 0;
    }

    public int getTimeoutCount() {
        return this.timeout;
    }
}

