/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.maple;

import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.maple.InputBits;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialMessage
extends AbstractMRMessage {
    private boolean _replyExpected = true;
    private static final Logger log = LoggerFactory.getLogger(SerialMessage.class);

    public SerialMessage() {
    }

    public SerialMessage(int i) {
        super(i);
    }

    public SerialMessage(SerialMessage m) {
        super(m);
    }

    public SerialMessage(String m) {
        super(m);
    }

    public SerialMessage(byte[] a) {
        super(String.valueOf(a));
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("");
        int i = 0;
        while (i < this.getNumDataElements()) {
            if (i != 0) {
                s.append(" ");
            }
            s.append(StringUtil.twoHexFromInt(this.getElement(i)));
            ++i;
        }
        return s.toString();
    }

    protected void setNoReply() {
        this._replyExpected = false;
    }

    @Override
    public boolean replyExpected() {
        return this._replyExpected;
    }

    public boolean isPoll() {
        return this.getElement(3) == 82 && this.getElement(4) == 67;
    }

    public boolean isXmt() {
        return this.getElement(3) == 87 && this.getElement(4) == 67;
    }

    public boolean isInit() {
        return false;
    }

    public int getUA() {
        return (this.getElement(1) - 48) * 10 + (this.getElement(2) - 48);
    }

    public int getAddress() {
        return (this.getElement(5) - 48) * 1000 + (this.getElement(6) - 48) * 100 + (this.getElement(7) - 48) * 10 + (this.getElement(8) - 48);
    }

    public int getNumItems() {
        return (this.getElement(9) - 48) * 10 + (this.getElement(10) - 48);
    }

    public static SerialMessage getPoll(int UA, int startAdd, int count) {
        if (count <= 0 || count > 99) {
            log.error("Illegal count in Maple poll message - {}", (Object)count);
            return null;
        }
        SerialMessage m = new SerialMessage(14);
        m.setElement(0, 2);
        m.setElement(1, 48 + UA / 10);
        m.setElement(2, 48 + (UA - UA / 10 * 10));
        m.setElement(3, 82);
        m.setElement(4, 67);
        m.setElement(5, 48 + startAdd / 1000);
        m.setElement(6, 48 + (startAdd - startAdd / 1000 * 1000) / 100);
        m.setElement(7, 48 + (startAdd - startAdd / 100 * 100) / 10);
        m.setElement(8, 48 + (startAdd - startAdd / 10 * 10));
        m.setElement(9, 48 + count / 10);
        m.setElement(10, 48 + (count - count / 10 * 10));
        m.setElement(11, 3);
        m.setChecksum(12);
        m.setTimeout(InputBits.getTimeoutTime());
        return m;
    }

    void setChecksum(int index) {
        int sum = 0;
        int i = 1;
        while (i < index) {
            sum += this.getElement(i);
            ++i;
        }
        int firstVal = (sum &= 0xFF) / 16 & 0xF;
        char firstChar = firstVal > 9 ? (char)(55 + firstVal) : (char)(48 + firstVal);
        this.setElement(index, firstChar);
        int secondVal = sum & 0xF;
        char secondChar = secondVal > 9 ? (char)(55 + secondVal) : (char)(48 + secondVal);
        this.setElement(index + 1, secondChar);
    }
}

