/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.maple;

import jmri.implementation.AbstractLight;
import jmri.jmrix.maple.MapleSystemConnectionMemo;
import jmri.jmrix.maple.SerialAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialLight
extends AbstractLight {
    private MapleSystemConnectionMemo _memo = null;
    int mBit = 0;
    private static final Logger log = LoggerFactory.getLogger(SerialLight.class);

    public SerialLight(String systemName, MapleSystemConnectionMemo memo) {
        super(systemName);
        this._memo = memo;
        this.initializeLight(systemName);
    }

    public SerialLight(String systemName, String userName, MapleSystemConnectionMemo memo) {
        super(systemName, userName);
        this._memo = memo;
        this.initializeLight(systemName);
    }

    private void initializeLight(String systemName) {
        this.mBit = SerialAddress.getBitFromSystemName(systemName, this._memo.getSystemPrefix());
        this.setState(4);
    }

    @Override
    protected void doNewState(int oldState, int newState) {
        if (newState == 2) {
            this._memo.getTrafficController().outputBits().setOutputBit(this.mBit, false);
        } else if (newState == 4) {
            this._memo.getTrafficController().outputBits().setOutputBit(this.mBit, true);
        } else {
            log.warn("illegal state requested for Light: {}", (Object)this.getSystemName());
        }
    }
}

