/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.maple;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.Light;
import jmri.Manager;
import jmri.Sensor;
import jmri.Turnout;
import jmri.jmrix.maple.InputBits;
import jmri.jmrix.maple.MapleSystemConnectionMemo;
import jmri.jmrix.maple.OutputBits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialAddress {
    private static final Logger log = LoggerFactory.getLogger(SerialAddress.class);

    public static int getBitFromSystemName(String systemName, String prefix) {
        if (prefix.length() < 1) {
            return 0;
        }
        log.debug("systemName = {}", (Object)systemName);
        log.debug("prefix = {}", (Object)prefix);
        if (!systemName.startsWith(prefix) || systemName.charAt(prefix.length()) != 'L' && systemName.charAt(prefix.length()) != 'S' && systemName.charAt(prefix.length()) != 'T') {
            log.debug("invalid character in header field of system name: {}", (Object)systemName);
            return 0;
        }
        int num = 0;
        try {
            num = Integer.parseInt(systemName.substring(prefix.length() + 1));
        }
        catch (NumberFormatException numberFormatException) {
            log.warn("invalid character in number field of system name: {}", (Object)systemName);
            return 0;
        }
        if (num <= 0) {
            log.debug("invalid Maple system name: {}", (Object)systemName);
            return 0;
        }
        return num;
    }

    public static String validateSystemNameFormat(String name, Manager<?> manager, Locale locale) throws IllegalArgumentException {
        int max = manager.typeLetter() == 'S' ? 1000 : 8000;
        return manager.validateIntegerSystemNameFormat(name, 0, max, locale);
    }

    public static Manager.NameValidity validSystemNameFormat(@Nonnull String systemName, char type, String prefix) {
        if (!systemName.startsWith(prefix) || systemName.charAt(prefix.length()) != type) {
            log.error("invalid character in header field of system name: {}", (Object)systemName);
            return Manager.NameValidity.INVALID;
        }
        if (systemName.length() <= prefix.length() + 1) {
            log.warn("missing numerical node address in system name: {}", (Object)systemName);
            return Manager.NameValidity.INVALID;
        }
        int bit = SerialAddress.getBitFromSystemName(systemName, prefix);
        if (bit <= 0 || type == 'S' && bit > 1000 || bit > 8000) {
            log.warn("node address field out of range in system name - {}", (Object)systemName);
            return Manager.NameValidity.INVALID;
        }
        return Manager.NameValidity.VALID;
    }

    public static boolean validSystemNameConfig(String systemName, char type, MapleSystemConnectionMemo memo) {
        if (SerialAddress.validSystemNameFormat(systemName, type, memo.getSystemPrefix()) != Manager.NameValidity.VALID) {
            return false;
        }
        int bit = SerialAddress.getBitFromSystemName(systemName, memo.getSystemPrefix());
        switch (type) {
            case 'L': 
            case 'T': {
                if (bit <= 0 || bit > OutputBits.getNumOutputBits()) break;
                return true;
            }
            case 'S': {
                if (bit <= 0 || bit > InputBits.getNumInputBits()) break;
                return true;
            }
            default: {
                log.error("Invalid type specification in validSystemNameConfig call");
                return false;
            }
        }
        log.warn("Maple hardware address out of range in system name: {}", (Object)systemName);
        return false;
    }

    public static String normalizeSystemName(String systemName, String prefix) {
        if (prefix.length() < 1) {
            log.error("invalid system name prefix: {}", (Object)prefix);
            return "";
        }
        if (systemName.length() < prefix.length() + 1 || !systemName.startsWith(prefix) || SerialAddress.validSystemNameFormat(systemName, systemName.charAt(prefix.length()), prefix) != Manager.NameValidity.VALID) {
            return "";
        }
        int bitNum = SerialAddress.getBitFromSystemName(systemName, prefix);
        char type = systemName.charAt(prefix.length());
        if (bitNum <= 0 || type == 'S' && bitNum > 1000 || bitNum > 8000) {
            log.warn("node address field out of range in system name - {}", (Object)systemName);
            return "";
        }
        String nName = "";
        nName = String.valueOf(prefix) + type + bitNum;
        return nName;
    }

    public static String makeSystemName(String type, int bitNum, String prefix) {
        if (prefix.length() < 1) {
            log.error("invalid system name prefix: {}", (Object)prefix);
            return "";
        }
        String nName = "";
        if (!(type.equals("S") || type.equals("L") || type.equals("T"))) {
            log.error("illegal type character proposed for system name - {}", (Object)type);
            return nName;
        }
        if (bitNum < 1 || type.equals("S") && bitNum > 1000 || bitNum > 8000) {
            log.warn("illegal address range proposed for system name - {}", (Object)bitNum);
            return nName;
        }
        nName = String.valueOf(prefix) + type + Integer.toString(bitNum);
        return nName;
    }

    public static String isOutputBitFree(int bitNum, String prefix) {
        if (prefix.length() < 1) {
            log.error("invalid system name prefix: {}", (Object)prefix);
            return "";
        }
        if (bitNum < 1 || bitNum > 8000) {
            log.error("illegal bit number in free bit test - {}", (Object)bitNum);
            return "";
        }
        Turnout t = null;
        String sysName = "";
        sysName = SerialAddress.makeSystemName("T", bitNum, prefix);
        t = InstanceManager.turnoutManagerInstance().getBySystemName(sysName);
        if (t != null) {
            return sysName;
        }
        if (bitNum > 1) {
            sysName = SerialAddress.makeSystemName("T", bitNum - 1, prefix);
            t = InstanceManager.turnoutManagerInstance().getBySystemName(sysName);
            if (t != null && t.getNumberOutputBits() == 2) {
                return sysName;
            }
        }
        Light lgt = null;
        sysName = SerialAddress.makeSystemName("L", bitNum, prefix);
        lgt = InstanceManager.lightManagerInstance().getBySystemName(sysName);
        if (lgt != null) {
            return sysName;
        }
        return "";
    }

    public static String isInputBitFree(int bitNum, String prefix) {
        if (prefix.length() < 1) {
            log.error("invalid system name prefix: {}", (Object)prefix);
            return "";
        }
        if (bitNum < 1 || bitNum > 1000) {
            log.error("illegal bit number in free bit test");
            return "";
        }
        Sensor s = null;
        String sysName = "";
        sysName = SerialAddress.makeSystemName("S", bitNum, prefix);
        s = InstanceManager.sensorManagerInstance().getBySystemName(sysName);
        if (s != null) {
            return sysName;
        }
        return "";
    }

    public static String getUserNameFromSystemName(String systemName, String prefix) {
        if (prefix.length() < 1) {
            log.error("invalid system name prefix: {}", (Object)prefix);
            return "";
        }
        if (systemName.length() < prefix.length() + 2 || !systemName.startsWith(prefix)) {
            return "";
        }
        if (systemName.charAt(prefix.length()) == 'S') {
            Sensor s = null;
            s = InstanceManager.sensorManagerInstance().getBySystemName(systemName);
            if (s != null) {
                return s.getUserName();
            }
            return "";
        }
        if (systemName.charAt(prefix.length()) == 'T') {
            Turnout t = null;
            t = InstanceManager.turnoutManagerInstance().getBySystemName(systemName);
            if (t != null) {
                return t.getUserName();
            }
            return "";
        }
        if (systemName.charAt(prefix.length()) == 'L') {
            Light lgt = null;
            lgt = InstanceManager.lightManagerInstance().getBySystemName(systemName);
            if (lgt != null) {
                return lgt.getUserName();
            }
            return "";
        }
        return "";
    }
}

