/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.uhlenbrock;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.EOFException;
import java.io.IOException;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import javax.swing.SwingUtilities;
import jmri.jmrix.loconet.LnPacketizer;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetMessageException;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.util.WaitHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UhlenbrockPacketizer
extends LnPacketizer {
    public static final int NOTIFIEDSTATE = 15;
    public static final int WAITMSGREPLYSTATE = 25;
    static int defaultWaitTimer = 10000;
    public LinkedList<LocoNetMessage> xmtLocoNetList = new LinkedList();
    LocoNetMessage lastMessage;
    protected volatile int mCurrentState;
    private static final Logger log = LoggerFactory.getLogger(UhlenbrockPacketizer.class);

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="Only used during system initialization")
    public UhlenbrockPacketizer() {
        super(new LocoNetSystemConnectionMemo());
        log.debug("UhlenbrockPacketizer instantiated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendLocoNetMessage(LocoNetMessage m) {
        log.debug("add to queue message {}", (Object)m.toString());
        ++this.transmittedMsgCount;
        m.setParity();
        int len = m.getNumDataElements();
        byte[] msg = new byte[len];
        int i2 = 0;
        while (i2 < len) {
            msg[i2] = (byte)m.getElement(i2);
            ++i2;
        }
        if (log.isDebugEnabled()) {
            log.debug("queue LocoNet packet: {}", (Object)m.toString());
        }
        try {
            Runnable i2 = this.xmtHandler;
            synchronized (i2) {
                this.xmtLocoNetList.addLast(m);
                this.xmtList.addLast(msg);
                this.xmtHandler.notify();
            }
        }
        catch (RuntimeException e) {
            log.warn("passing to xmit: unexpected exception: ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transmitWait(int waitTime, int state) {
        long currentTime = Calendar.getInstance().getTimeInMillis();
        long endTime = currentTime + (long)waitTime;
        while (endTime > (currentTime = Calendar.getInstance().getTimeInMillis())) {
            long wait = endTime - currentTime;
            try {
                Runnable runnable = this.xmtHandler;
                synchronized (runnable) {
                    if (this.mCurrentState != state) {
                        return;
                    }
                    this.xmtHandler.wait(wait);
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                log.error("transmitLoop interrupted");
            }
        }
        log.debug("Timeout in transmitWait, mCurrentState: {}", (Object)this.mCurrentState);
    }

    @Override
    public void startThreads() {
        int xmtpriority;
        int priority = Thread.currentThread().getPriority();
        log.debug("startThreads current priority = {} max available = 10 default = 5 min available = 1", (Object)priority);
        int n = xmtpriority = 9 > priority ? 9 : 10;
        if (this.xmtHandler == null) {
            this.xmtHandler = new XmtHandler();
        }
        Thread xmtThread = new Thread(this.xmtHandler, "LocoNet Uhlenbrock transmit handler");
        log.debug("Xmt thread starts at priority {}", (Object)xmtpriority);
        xmtThread.setDaemon(true);
        xmtThread.setPriority(9);
        xmtThread.start();
        if (this.rcvHandler == null) {
            this.rcvHandler = new RcvHandler(this);
        }
        Thread rcvThread = new Thread(this.rcvHandler, "LocoNet Uhlenbrock receive handler");
        rcvThread.setDaemon(true);
        rcvThread.setPriority(10);
        rcvThread.start();
    }

    class RcvHandler
    implements Runnable {
        LnPacketizer trafficController;

        public RcvHandler(LnPacketizer lt) {
            this.trafficController = lt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        int opCode;
                        int inbyte = UhlenbrockPacketizer.this.readByteProtected(UhlenbrockPacketizer.this.istream) & 0xFF;
                        while (((opCode = inbyte) & 0x80) == 0) {
                            log.debug("Skipping: {}", (Object)Integer.toHexString(opCode));
                            inbyte = UhlenbrockPacketizer.this.readByteProtected(UhlenbrockPacketizer.this.istream) & 0xFF;
                        }
                        log.debug("Start message with opcode: {}", (Object)Integer.toHexString(opCode));
                        LocoNetMessage msg = null;
                        while (msg == null) {
                            try {
                                int byte2 = UhlenbrockPacketizer.this.readByteProtected(UhlenbrockPacketizer.this.istream) & 0xFF;
                                if ((byte2 & 0x80) != 0) {
                                    log.warn("LocoNet message with opCode: {} ended early. Byte2 is also an opcode: {}", (Object)Integer.toHexString(opCode), (Object)Integer.toHexString(byte2));
                                    opCode = byte2;
                                    throw new LocoNetMessageException();
                                }
                                switch ((opCode & 0x60) >> 5) {
                                    case 0: {
                                        msg = new LocoNetMessage(2);
                                        break;
                                    }
                                    case 1: {
                                        msg = new LocoNetMessage(4);
                                        break;
                                    }
                                    case 2: {
                                        msg = new LocoNetMessage(6);
                                        break;
                                    }
                                    case 3: {
                                        if (byte2 < 2) {
                                            log.error("LocoNet message length invalid: {} opcode: {}", (Object)byte2, (Object)Integer.toHexString(opCode));
                                        }
                                        msg = new LocoNetMessage(byte2);
                                        break;
                                    }
                                    default: {
                                        throw new LocoNetMessageException("decode failure " + byte2);
                                    }
                                }
                                msg.setOpCode(opCode);
                                msg.setElement(1, byte2);
                                int len = msg.getNumDataElements();
                                int i = 2;
                                while (i < len) {
                                    int b = UhlenbrockPacketizer.this.readByteProtected(UhlenbrockPacketizer.this.istream) & 0xFF;
                                    if ((b & 0x80) != 0) {
                                        log.warn("LocoNet message with opCode: {} ended early. Expected length: {} seen length: {} unexpected byte: {}", new Object[]{Integer.toHexString(opCode), len, i, Integer.toHexString(b)});
                                        opCode = b;
                                        throw new LocoNetMessageException();
                                    }
                                    msg.setElement(i, b);
                                    ++i;
                                }
                            }
                            catch (LocoNetMessageException locoNetMessageException) {
                                msg = null;
                            }
                        }
                        if (!msg.checkParity()) {
                            log.warn("Ignore LocoNet packet with bad checksum: {}", (Object)msg.toString());
                            throw new LocoNetMessageException();
                        }
                        if (msg.equals(UhlenbrockPacketizer.this.lastMessage)) {
                            log.debug("We have our returned message and can send back out our next instruction");
                            UhlenbrockPacketizer.this.mCurrentState = 15;
                            Runnable byte2 = UhlenbrockPacketizer.this.xmtHandler;
                            synchronized (byte2) {
                                UhlenbrockPacketizer.this.xmtHandler.notify();
                            }
                        }
                        log.debug("queue message for notification");
                        LocoNetMessage thisMsg = msg;
                        LnPacketizer thisTc = this.trafficController;
                        Runnable r = new Runnable(thisMsg, thisTc){
                            LocoNetMessage msgForLater;
                            LnPacketizer myTc;
                            {
                                this.msgForLater = locoNetMessage;
                                this.myTc = lnPacketizer;
                            }

                            @Override
                            public void run() {
                                this.myTc.notify(this.msgForLater);
                            }
                        };
                        SwingUtilities.invokeLater(r);
                    }
                }
                catch (LocoNetMessageException e) {
                    log.warn("run: unexpected LocoNetMessageException: ", (Throwable)e);
                    continue;
                }
                catch (EOFException eOFException) {
                    log.debug("EOFException, is LocoNet serial I/O using timeouts?");
                    continue;
                }
                catch (IOException e) {
                    log.debug("IOException, should only happen with HexFile: {}", (Throwable)e);
                    log.debug("End of file");
                    UhlenbrockPacketizer.this.disconnectPort(UhlenbrockPacketizer.this.controller);
                    return;
                }
                catch (RuntimeException e) {
                    log.warn("run: unexpected Exception", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    class XmtHandler
    implements Runnable {
        XmtHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        log.debug("check for input");
                        byte[] msg = null;
                        UhlenbrockPacketizer.this.lastMessage = null;
                        XmtHandler xmtHandler = this;
                        synchronized (xmtHandler) {
                            UhlenbrockPacketizer.this.lastMessage = UhlenbrockPacketizer.this.xmtLocoNetList.removeFirst();
                            msg = (byte[])UhlenbrockPacketizer.this.xmtList.removeFirst();
                        }
                        try {
                            if (UhlenbrockPacketizer.this.ostream != null) {
                                if (!UhlenbrockPacketizer.this.controller.okToSend()) {
                                    log.debug("LocoNet port not ready to receive");
                                }
                                log.debug("start write to stream");
                                while (!UhlenbrockPacketizer.this.controller.okToSend()) {
                                    Thread.yield();
                                }
                                UhlenbrockPacketizer.this.ostream.write(msg);
                                UhlenbrockPacketizer.this.ostream.flush();
                                log.debug("end write to stream");
                                UhlenbrockPacketizer.this.messageTransmitted(msg);
                                UhlenbrockPacketizer.this.mCurrentState = 25;
                                UhlenbrockPacketizer.this.transmitWait(defaultWaitTimer, 25);
                                continue;
                            }
                            log.warn("sendLocoNetMessage: no connection established");
                        }
                        catch (IOException e) {
                            log.warn("sendLocoNetMessage: IOException: {}", (Object)e.toString());
                        }
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    log.debug("start wait");
                    new WaitHandler(this);
                    log.debug("end wait");
                    continue;
                }
                break;
            }
        }
    }
}

