/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.uhlenbrock;

import java.util.Hashtable;
import jmri.DccLocoAddress;
import jmri.LocoAddress;
import jmri.ThrottleListener;
import jmri.jmrix.loconet.LnThrottleManager;
import jmri.jmrix.loconet.LocoNetSlot;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.LocoNetThrottle;
import jmri.jmrix.loconet.SlotListener;
import jmri.jmrix.loconet.uhlenbrock.UhlenbrockSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UhlenbrockLnThrottleManager
extends LnThrottleManager {
    Hashtable<Integer, Thread> waitingForNotification = new Hashtable(5);
    private static final Logger log = LoggerFactory.getLogger(UhlenbrockLnThrottleManager.class);

    public UhlenbrockLnThrottleManager(UhlenbrockSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    public void requestThrottleSetup(LocoAddress address, boolean control) {
        if (!(address instanceof DccLocoAddress)) {
            log.error("{} is not a DCCLocoAddress", (Object)address);
            this.failedThrottleRequest(address, "Address" + address + " is not a DccLocoAddress");
            return;
        }
        this.slotManager.slotFromLocoAddress(((DccLocoAddress)address).getNumber(), this);
        class RetrySetup
        implements Runnable {
            DccLocoAddress address;
            SlotListener list;

            RetrySetup(DccLocoAddress address, SlotListener list) {
                this.address = address;
                this.list = list;
            }

            @Override
            public void run() {
                int count = 0;
                while (count < 3) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    UhlenbrockLnThrottleManager.this.slotManager.slotFromLocoAddress(this.address.getNumber(), this.list);
                    log.warn("No response to requesting loco {}, will try again {}", (Object)this.address, (Object)count);
                    ++count;
                }
                log.error("No response to requesting loco {} after {} attempts; will cancel the request", (Object)this.address, (Object)count);
                UhlenbrockLnThrottleManager.this.failedThrottleRequest(this.address, "Failed to get response from command station");
            }
        }
        Thread thr = new Thread(new RetrySetup((DccLocoAddress)address, this));
        thr.start();
        this.waitingForNotification.put(((DccLocoAddress)address).getNumber(), thr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyChangedSlot(LocoNetSlot s) {
        LocoNetThrottle throttle = new LocoNetThrottle((LocoNetSystemConnectionMemo)this.adapterMemo, s);
        this.notifyThrottleKnown(throttle, new DccLocoAddress(s.locoAddr(), UhlenbrockLnThrottleManager.isLongAddress(s.locoAddr())));
        if (this.waitingForNotification.containsKey(s.locoAddr())) {
            Thread r;
            Thread thread = r = this.waitingForNotification.get(s.locoAddr());
            synchronized (thread) {
                r.interrupt();
            }
            this.waitingForNotification.remove(s.locoAddr());
        }
    }

    @Override
    public void failedThrottleRequest(LocoAddress address, String reason) {
        if (this.waitingForNotification.containsKey(address.getNumber())) {
            this.waitingForNotification.get(address.getNumber()).interrupt();
            this.waitingForNotification.remove(address.getNumber());
        }
        super.failedThrottleRequest(address, reason);
    }

    @Override
    public void cancelThrottleRequest(LocoAddress address, ThrottleListener l) {
        int loconumber = address.getNumber();
        if (this.waitingForNotification.containsKey(loconumber)) {
            this.waitingForNotification.get(loconumber).interrupt();
            this.waitingForNotification.remove(loconumber);
        }
        super.cancelThrottleRequest(address, l);
    }
}

