/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.uhlenbrock;

import java.util.Arrays;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.loconet.LnCommandStationType;
import jmri.jmrix.loconet.locobuffer.LocoBufferAdapter;
import jmri.jmrix.loconet.uhlenbrock.Bundle;
import jmri.jmrix.loconet.uhlenbrock.UhlenbrockPacketizer;
import jmri.jmrix.loconet.uhlenbrock.UhlenbrockSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;

public class UhlenbrockAdapter
extends LocoBufferAdapter {
    private static final Logger log = LoggerFactory.getLogger(UhlenbrockAdapter.class);

    public UhlenbrockAdapter() {
        super(new UhlenbrockSystemConnectionMemo());
        this.options.remove(this.option2Name);
        this.options.put(this.option2Name, new AbstractPortController.Option(Bundle.getMessage("CommandStationTypeLabel"), this.commandStationOptions(), false));
        this.validSpeeds = new String[]{Bundle.getMessage("Baud19200"), Bundle.getMessage("Baud38400"), Bundle.getMessage("Baud57600"), Bundle.getMessage("Baud115200")};
        this.validSpeedValues = new int[]{19200, 38400, 57600, 115200};
        this.configureBaudRate(this.validSpeeds[3]);
    }

    @Override
    public void configure() {
        this.setCommandStationType(this.getOptionState(this.option2Name));
        this.setTurnoutHandling(this.getOptionState(this.option3Name));
        UhlenbrockPacketizer packets = new UhlenbrockPacketizer();
        packets.connectPort(this);
        this.getSystemConnectionMemo().setLnTrafficController(packets);
        this.getSystemConnectionMemo().configureCommandStation(this.commandStationType, this.mTurnoutNoRetry, this.mTurnoutExtraSpace, this.mTranspondingAvailable);
        this.getSystemConnectionMemo().configureManagers();
        packets.startThreads();
    }

    @Override
    public String[] validBaudRates() {
        return Arrays.copyOf(this.validSpeeds, this.validSpeeds.length);
    }

    @Override
    public int[] validBaudNumbers() {
        return Arrays.copyOf(this.validSpeedValues, this.validSpeedValues.length);
    }

    @Override
    public int defaultBaudIndex() {
        return 3;
    }

    @Override
    public boolean okToSend() {
        return true;
    }

    @Override
    protected void setSerialPort(SerialPort activeSerialPort) throws UnsupportedCommOperationException {
        int baud = this.currentBaudNumber(this.mBaudRate);
        activeSerialPort.setSerialPortParams(baud, 8, 1, 0);
        this.configureLeadsAndFlowControl(activeSerialPort, 0);
        log.info("Uhlenbrock adapter{}{} RTSCTS_OUT=2 RTSCTS_IN=1", (Object)(activeSerialPort.getFlowControlMode() == 2 ? " set hardware flow control, mode=" : " set no flow control, mode="), (Object)activeSerialPort.getFlowControlMode());
    }

    public String[] commandStationOptions() {
        String[] retval = new String[]{LnCommandStationType.COMMAND_STATION_IBX_TYPE_2.getName()};
        return retval;
    }
}

