/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.uhlenbrock;

import java.util.Locale;
import java.util.Objects;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.uhlenbrock.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LncvMessageContents {
    private final int opc;
    private final int src;
    private final int dst_l;
    private final int dst_h;
    private final int dst;
    private final int cmd;
    private final int art_l;
    private final int art_h;
    private final int art;
    private final String sArt;
    private final int cvn_l;
    private final int cvn_h;
    private final int cvn;
    private final String sCvn;
    private final int mod_l;
    private final int mod_h;
    private final int mod;
    private final String sMod;
    private final int cmd_data;
    private final LncvCommand command;
    public static final int LNCV_LENGTH_ELEMENT_VALUE = 15;
    public static final int LNCV_LNMODULE_VALUE = 5;
    public static final int LNCV_CS_SRC_VALUE = 1;
    public static final int LNCV_PC_SRC_VALUE = 8;
    public static final int LNCV_CSDEST_VALUE = 19273;
    public static final int LNCV_ALL = 65535;
    public static final int LNCV_ALL_MASK = 65280;
    public static final int LNCV_MIN_MODULEADDR = 0;
    public static final int LNCV_MAX_MODULEADDR = 65534;
    public static final int LNCV_LENGTH_ELEMENT_INDEX = 1;
    public static final int LNCV_SRC_ELEMENT_INDEX = 2;
    public static final int LNCV_DST_L_ELEMENT_INDEX = 3;
    public static final int LNCV_DST_H_ELEMENT_INDEX = 4;
    public static final int LNCV_CMD_ELEMENT_INDEX = 5;
    public static final int PXCT1_ELEMENT_INDEX = 6;
    public static final int LNCV_ART_L_ELEMENT_INDEX = 7;
    public static final int LNCV_ART_H_ELEMENT_INDEX = 8;
    public static final int LNCV_CVN_L_ELEMENT_INDEX = 9;
    public static final int LNCV_CVN_H_ELEMENT_INDEX = 10;
    public static final int LNCV_MOD_L_ELEMENT_INDEX = 11;
    public static final int LNCV_MOD_H_ELEMENT_INDEX = 12;
    public static final int LNCV_CMDDATA_ELEMENT_INDEX = 13;
    public static final int LNCV_SRC_ELEMENT_MASK = 127;
    public static final int PXCT1_ELEMENT_VALIDITY_CHECK_MASK = 112;
    public static final int LNCV_ART_L_ARTL7_CHECK_MASK = 1;
    public static final int LNCV_ART_H_ARTH7_CHECK_MASK = 2;
    public static final int LNCV_CVN_L_CVNL7_CHECK_MASK = 4;
    public static final int LNCV_CVN_H_CVNH7_CHECK_MASK = 8;
    public static final int LNCV_MOD_L_MODL7_CHECK_MASK = 16;
    public static final int LNCV_MOD_H_MODH7_CHECK_MASK = 32;
    public static final int LNCV_CMDDATA_DAT7_CHECK_MASK = 64;
    public static final int LNCV_DATA_PROFF_MASK = 64;
    public static final int LNCV_DATA_PRON_MASK = 128;
    public static final int LNCV_DATA_LED1_MASK = 255;
    public static final int LNCV_DATA_LED2_MASK = 254;
    public static final int LNCV_DATA_RO_MASK = 1;
    public static final int LNCV_CMD_WRITE = 32;
    public static final int LNCV_CMD_READ = 33;
    public static final int LNCV_CMD_READ_REPLY = 31;
    private static final Logger log = LoggerFactory.getLogger(LncvMessageContents.class);

    public LncvMessageContents(LocoNetMessage m) throws IllegalArgumentException {
        if (!LncvMessageContents.isSupportedLncvMessage(m)) {
            throw new IllegalArgumentException("LocoNet message is not an LNCV message");
        }
        this.command = LncvMessageContents.extractMessageType(m);
        this.opc = m.getOpCode();
        this.src = m.getElement(2);
        this.dst_l = m.getElement(3);
        this.dst_h = m.getElement(4);
        this.dst = this.dst_l + 256 * this.dst_h;
        log.debug("src={}, dst={}{}", new Object[]{this.src, this.dst, this.dst == 19273 ? "=IK" : ""});
        this.cmd = m.getElement(5);
        int pxct1 = m.getElement(6);
        String svx1bin = String.format("%8s", Integer.toBinaryString(pxct1)).replace(' ', '0');
        log.debug("PXCT1 HIBITS = {}", (Object)svx1bin);
        this.art_l = m.getElement(7) + ((pxct1 & 1) == 1 ? 128 : 0);
        this.art_h = m.getElement(8) + ((pxct1 & 2) == 2 ? 128 : 0);
        this.art = this.art_l + 256 * this.art_h;
        this.sArt = String.valueOf(this.art);
        this.cvn_l = m.getElement(9) + ((pxct1 & 4) == 4 ? 128 : 0);
        this.cvn_h = m.getElement(10) + ((pxct1 & 8) == 8 ? 128 : 0);
        this.cvn = this.cvn_l + 256 * this.cvn_h;
        this.sCvn = String.valueOf(this.cvn);
        this.mod_l = m.getElement(11) + ((pxct1 & 0x10) == 16 ? 128 : 0);
        this.mod_h = m.getElement(12) + ((pxct1 & 0x20) == 32 ? 128 : 0);
        this.mod = this.mod_l + 256 * this.mod_h;
        this.sMod = String.valueOf(this.mod);
        this.cmd_data = m.getElement(13) + ((pxct1 & 0x40) == 64 ? 128 : 0);
    }

    public static boolean isSupportedLncvMessage(LocoNetMessage m) {
        if (m.getOpCode() != 229 && m.getOpCode() != 237) {
            return false;
        }
        if (m.getElement(1) != 15) {
            return false;
        }
        if (m.getElement(2) != 1 && m.getElement(2) != 5 && m.getElement(2) != 8) {
            return false;
        }
        int msgData = m.getElement(13) | ((m.getElement(6) & 0x40) == 64 ? 128 : 0);
        return LncvMessageContents.isSupportedLncvCommand(m.getElement(5), m.getOpCode(), msgData);
    }

    public static boolean isLnMessageASpecificLncvCommand(LocoNetMessage m, LncvCommand lncvCmd) {
        if (!LncvMessageContents.isSupportedLncvMessage(m)) {
            log.debug("rejected in isLnMessageASpecificLncvCommand");
            return false;
        }
        return Objects.equals((Object)LncvMessageContents.extractMessageType(m), (Object)lncvCmd);
    }

    public static LncvCommand extractMessageType(LocoNetMessage m) {
        if (LncvMessageContents.isSupportedLncvMessage(m)) {
            int msgCmd = m.getElement(5);
            int msgData = m.getElement(13) | ((m.getElement(6) & 0x40) == 64 ? 128 : 0);
            LncvCommand[] lncvCommandArray = LncvCommand.values();
            int n = lncvCommandArray.length;
            int n2 = 0;
            while (n2 < n) {
                LncvCommand c = lncvCommandArray[n2];
                if (c.matches(msgCmd, m.getOpCode(), msgData).booleanValue()) {
                    log.debug("LncvCommand match found");
                    return c;
                }
                ++n2;
            }
        }
        return null;
    }

    public String toString() {
        Locale l = Locale.getDefault();
        return this.toString(l);
    }

    public String toString(Locale locale) {
        String returnString;
        switch (this.command) {
            case LNCV_PROG_START: {
                if ((this.art & 0xFF00) == 65280) {
                    returnString = Bundle.getMessage(locale, "LNCV_ALL_PROG_START_INTERPRETED", new Object[0]);
                    break;
                }
                if ((this.mod & 0xFF00) == 65280) {
                    returnString = Bundle.getMessage(locale, "LNCV_ART_PROG_START_INTERPRETED", this.sArt);
                    break;
                }
                returnString = Bundle.getMessage(locale, "LNCV_MOD_PROG_START_INTERPRETED", this.sArt, this.sMod);
                break;
            }
            case LNCV_PROG_END: {
                if ((this.art & 0xFF00) == 65280) {
                    returnString = Bundle.getMessage(locale, "LNCV_ALL_PROG_END_INTERPRETED", new Object[0]);
                    break;
                }
                if ((this.mod & 0xFF00) == 65280) {
                    returnString = Bundle.getMessage(locale, "LNCV_ART_PROG_END_INTERPRETED", this.sArt);
                    break;
                }
                returnString = Bundle.getMessage(locale, "LNCV_MOD_PROG_END_INTERPRETED", this.sArt, this.sMod);
                break;
            }
            case LNCV_WRITE: {
                returnString = Bundle.getMessage(locale, "LNCV_WRITE_INTERPRETED", this.sArt, this.sCvn, this.sMod);
                break;
            }
            case LNCV_READ: {
                returnString = Bundle.getMessage(locale, "LNCV_READ_INTERPRETED", this.sArt, this.sMod, this.sCvn);
                break;
            }
            case LNCV_READ_REPLY: {
                returnString = Bundle.getMessage(locale, "LNCV_READ_REPLY_INTERPRETED", this.sArt, this.sCvn, this.sMod);
                break;
            }
            case LNCV_DIRECT_LED1: {
                String modBin = String.format("%8s", Integer.toBinaryString(this.mod)).replace(' ', '0');
                returnString = Bundle.getMessage(locale, "LNCV_DIRECT_INTERPRETED", "1", modBin, this.sCvn);
                break;
            }
            case LNCV_DIRECT_LED2: {
                String modBin = String.format("%8s", Integer.toBinaryString(this.mod)).replace(' ', '0');
                returnString = Bundle.getMessage(locale, "LNCV_DIRECT_INTERPRETED", "2", modBin, this.sCvn);
                break;
            }
            case LNCV_DIRECT_REPLY: {
                returnString = Bundle.getMessage(locale, "LNCV_DIRECT_REPLY_INTERPRETED", this.sCvn, this.sMod);
                break;
            }
            default: {
                return String.valueOf(Bundle.getMessage(locale, "LNCV_UNDEFINED_MESSAGE", new Object[0])) + "\n";
            }
        }
        return String.valueOf(returnString) + "\n";
    }

    public static boolean isSupportedLncvCommand(int command, int opc, int cmdData) {
        LncvCommand[] lncvCommandArray = LncvCommand.values();
        int n = lncvCommandArray.length;
        int n2 = 0;
        while (n2 < n) {
            LncvCommand commandToCheck = lncvCommandArray[n2];
            if (commandToCheck.matches(command, opc, cmdData).booleanValue()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isSupportedLncvCommand() {
        return LncvMessageContents.isSupportedLncvCommand(this.cmd, this.opc, this.cmd_data);
    }

    public boolean isSupportedLncvReadReply() {
        return this.cmd == 31;
    }

    public static LocoNetMessage createLncvMessage(int opc, int source, int destination, int command, int articleNum, int cvNum, int moduleNum, int cmdData) throws IllegalArgumentException {
        if (!LncvMessageContents.isSupportedLncvCommand(command, opc, cmdData)) {
            throw new IllegalArgumentException("Command is not a supported LNCV command");
        }
        LocoNetMessage m = new LocoNetMessage(15);
        m.setOpCode(opc);
        m.setElement(1, 15);
        m.setElement(2, source);
        m.setElement(3, destination & 0xFF);
        m.setElement(4, destination >> 8);
        m.setElement(5, command);
        int svx1 = 0;
        svx1 += (articleNum & 0x80) == 128 ? 1 : 0;
        svx1 += (articleNum & 0x8000) == 32768 ? 2 : 0;
        svx1 += (cvNum & 0x80) == 128 ? 4 : 0;
        svx1 += (cvNum & 0x8000) == 32768 ? 8 : 0;
        svx1 += (moduleNum & 0x80) == 128 ? 16 : 0;
        svx1 += (moduleNum & 0x8000) == 32768 ? 32 : 0;
        m.setElement(6, svx1 += (cmdData & 0x80) == 128 ? 64 : 0);
        m.setElement(7, articleNum & 0x7F);
        m.setElement(8, articleNum >> 8 & 0x7F);
        m.setElement(9, cvNum & 0x7F);
        m.setElement(10, cvNum >> 8 & 0x7F);
        m.setElement(11, moduleNum & 0x7F);
        m.setElement(12, moduleNum >> 8 & 0x7F);
        m.setElement(13, cmdData & 0x7F);
        return m;
    }

    public static LocoNetMessage createLncvMessage(int source, int destination, LncvCommand command, int articleNum, int cvNum, int moduleNum) {
        return LncvMessageContents.createLncvMessage(command.getOpc(), source, destination, command.getCmd(), articleNum, cvNum, moduleNum, command.getCmdData());
    }

    public int getCmd() {
        return this.cmd;
    }

    public int getCvNum() {
        if (this.cmd == LncvCommand.LNCV_READ.cmd || this.cmd == LncvCommand.LNCV_WRITE.cmd || this.cmd == LncvCommand.LNCV_READ_REPLY.cmd) {
            return this.cvn;
        }
        return -1;
    }

    public int getCvValue() {
        if (this.cmd == LncvCommand.LNCV_READ_REPLY.cmd || this.cmd == LncvCommand.LNCV_WRITE.cmd) {
            return this.mod;
        }
        return -1;
    }

    public int getLncvArticleNum() {
        if (this.cmd == LncvCommand.LNCV_READ.cmd || this.cmd == LncvCommand.LNCV_WRITE.cmd || this.cmd == LncvCommand.LNCV_READ_REPLY.cmd || this.cmd == LncvCommand.LNCV_PROG_START.cmd && this.art != 65535 || this.cmd == LncvCommand.LNCV_PROG_END.cmd && this.art != 65535) {
            return this.art;
        }
        return -1;
    }

    public int getLncvModuleNum() {
        if (this.cmd == LncvCommand.LNCV_READ.cmd || this.cmd == LncvCommand.LNCV_PROG_START.cmd && this.art != 65535 || this.cmd == LncvCommand.LNCV_PROG_END.cmd && this.art != 65535) {
            return this.mod;
        }
        return -1;
    }

    public static LocoNetMessage createAllProgStartRequest(int articleNum) {
        return LncvMessageContents.createLncvMessage(1, 5, LncvCommand.LNCV_PROG_START, articleNum > -1 ? articleNum : 65535, 0, 65535);
    }

    public static LocoNetMessage createAllProgEndRequest(int articleNum) {
        return LncvMessageContents.createLncvMessage(1, 5, LncvCommand.LNCV_PROG_END, articleNum > -1 ? articleNum : 65535, 0, 65535);
    }

    public static LocoNetMessage createModProgStartRequest(int articleNum, int moduleAddress) {
        return LncvMessageContents.createLncvMessage(1, 5, LncvCommand.LNCV_PROG_START, articleNum, 0, moduleAddress);
    }

    public static LocoNetMessage createModProgEndRequest(int articleNum, int moduleAddress) {
        return LncvMessageContents.createLncvMessage(1, 5, LncvCommand.LNCV_PROG_END, articleNum, 0, moduleAddress);
    }

    public static LocoNetMessage createCvWriteRequest(int articleNum, int cvNum, int newValue) {
        return LncvMessageContents.createLncvMessage(1, 5, LncvCommand.LNCV_WRITE, articleNum, cvNum, newValue);
    }

    public static LocoNetMessage createCvReadRequest(int articleNum, int moduleAddress, int cvNum) {
        return LncvMessageContents.createLncvMessage(1, 5, LncvCommand.LNCV_READ, articleNum, cvNum, moduleAddress);
    }

    public static LocoNetMessage createLncvReadReply(LocoNetMessage m) {
        if (!LncvMessageContents.isLnMessageASpecificLncvCommand(m, LncvCommand.LNCV_READ)) {
            return null;
        }
        LocoNetMessage reply = new LocoNetMessage(m);
        reply.setOpCode(229);
        reply.setElement(1, 15);
        reply.setElement(3, reply.getElement(2) == 1 ? 73 : reply.getElement(2));
        reply.setElement(4, reply.getElement(2) == 1 ? 75 : 0);
        reply.setElement(2, 5);
        reply.setElement(5, 31);
        reply.setElement(7, reply.getElement(7));
        reply.setElement(8, reply.getElement(8));
        reply.setElement(9, reply.getElement(9));
        reply.setElement(10, reply.getElement(10));
        if (reply.getElement(9) != 0 || reply.getElement(10) != 0) {
            reply.setElement(11, 8);
            reply.setElement(12, 1);
            reply.setElement(6, reply.getElement(6) ^ 0x60);
        }
        reply.setElement(13, 0);
        return reply;
    }

    public static LocoNetMessage createLncvProgStartReply(LocoNetMessage m) {
        if (!LncvMessageContents.isLnMessageASpecificLncvCommand(m, LncvCommand.LNCV_PROG_START)) {
            return null;
        }
        LncvMessageContents lmc = new LncvMessageContents(m);
        log.debug("request to article {}", (Object)lmc.getLncvArticleNum());
        LocoNetMessage forward = new LocoNetMessage(m);
        forward.setElement(13, 0);
        forward.setElement(6, m.getElement(6) ^ 0x40);
        if (lmc.getLncvArticleNum() == 65535) {
            log.debug("art ALL");
            forward.setElement(7, 41);
            forward.setElement(8, 19);
            forward.setElement(6, 1);
        }
        if (lmc.getLncvModuleNum() == 65535) {
            log.debug("mod ALL");
            forward.setElement(11, 3);
            forward.setElement(12, 0);
        }
        return LncvMessageContents.createLncvReadReply(forward);
    }

    public static LocoNetMessage createDirectWriteRequest(int moduleAddress, int ledValue, boolean range2) {
        return LncvMessageContents.createLncvMessage(8, 5, range2 ? LncvCommand.LNCV_DIRECT_LED2 : LncvCommand.LNCV_DIRECT_LED1, 6900, moduleAddress, ledValue);
    }

    public static enum LncvCommand {
        LNCV_WRITE(32, 237, 0),
        LNCV_READ(33, 237, 0),
        LNCV_READ_REPLY(31, 229, 0),
        LNCV_PROG_START(33, 237, 128),
        LNCV_PROG_END(33, 229, 64),
        LNCV_DIRECT_LED1(32, 237, 255),
        LNCV_DIRECT_LED2(32, 237, 254),
        LNCV_DIRECT_REPLY(31, 229, 255);

        private final int cmd;
        private final int opc;
        private final int cmddata;

        private LncvCommand(int cmd, int opc, int cmddata) {
            this.cmd = cmd;
            this.opc = opc;
            this.cmddata = cmddata;
        }

        int getCmd() {
            return this.cmd;
        }

        int getOpc() {
            return this.opc;
        }

        int getCmdData() {
            return this.cmddata;
        }

        public static int getCmd(LncvCommand mt) {
            return mt.getCmd();
        }

        public Boolean matches(int matchCommand, int matchOpc, int matchData) {
            if (matchCommand == this.cmd && matchOpc == this.opc && matchData == this.cmddata) {
                return true;
            }
            return false;
        }
    }
}

