/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.uhlenbrock;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import jmri.jmrix.loconet.uhlenbrock.LncvDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LncvDevices {
    @GuardedBy(value="this")
    private final List<LncvDevice> deviceList = new ArrayList<LncvDevice>();
    private static final Logger log = LoggerFactory.getLogger(LncvDevices.class);

    public synchronized boolean addDevice(LncvDevice d) {
        if (!this.deviceExists(d)) {
            this.deviceList.add(d);
            log.debug("added device with prod {}, addr {}", (Object)d.getProductID(), (Object)d.getDestAddr());
            return true;
        }
        log.debug("device already in list: prod {}, addr {}", (Object)d.getProductID(), (Object)d.getDestAddr());
        return false;
    }

    public synchronized void removeAllDevices() {
        this.deviceList.clear();
    }

    public synchronized int isDeviceExistant(LncvDevice deviceToBeFound) {
        log.debug("Looking for a known LNCV device which matches characteristics: article {}, addr {}.", (Object)deviceToBeFound.getProductID(), (Object)deviceToBeFound.getDestAddr());
        int i = 0;
        while (i < this.deviceList.size()) {
            LncvDevice dev = this.deviceList.get(i);
            log.trace("Comparing against known device: article {}, addr {}.", (Object)dev.getProductID(), (Object)deviceToBeFound.getDestAddr());
            if (!(deviceToBeFound.getProductID() != -1 && dev.getProductID() != deviceToBeFound.getProductID() || deviceToBeFound.getDestAddr() != -1 && dev.getDestAddr() != deviceToBeFound.getDestAddr())) {
                log.debug("Match Found! Searched device matched against known device: article {}, addr {}.", (Object)dev.getProductID(), (Object)dev.getDestAddr());
                return i;
            }
            ++i;
        }
        log.debug("No matching known device was found!");
        return -1;
    }

    public boolean deviceExists(LncvDevice d) {
        int i = this.isDeviceExistant(d);
        log.debug("deviceExists found {}", (Object)i);
        return i >= 0;
    }

    public synchronized LncvDevice getDevice(int index) {
        return this.deviceList.get(index);
    }

    public synchronized LncvDevice[] getDevices() {
        LncvDevice[] d = new LncvDevice[]{};
        return this.deviceList.toArray(d);
    }

    public synchronized int size() {
        return this.deviceList.size();
    }
}

