/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.swing.lncvprog;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jmri.InstanceManager;
import jmri.Programmer;
import jmri.jmrit.decoderdefn.DecoderFile;
import jmri.jmrit.decoderdefn.DecoderIndexFile;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.symbolicprog.tabbedframe.PaneOpsProgFrame;
import jmri.jmrix.ProgrammingTool;
import jmri.jmrix.loconet.LncvDevicesManager;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.swing.lncvprog.Bundle;
import jmri.jmrix.loconet.swing.lncvprog.LncvProgPane;
import jmri.jmrix.loconet.uhlenbrock.LncvDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LncvProgTableModel
extends AbstractTableModel
implements PropertyChangeListener,
ProgrammingTool {
    public static final int COUNT_COLUMN = 0;
    public static final int ARTICLE_COLUMN = 1;
    public static final int MODADDR_COLUMN = 2;
    public static final int CV_COLUMN = 3;
    public static final int VALUE_COLUMN = 4;
    public static final int DEVICENAMECOLUMN = 5;
    public static final int ROSTERENTRYCOLUMN = 6;
    public static final int OPENPRGMRBUTTONCOLUMN = 7;
    public static final int NUMCOLUMNS = 8;
    private final LncvProgPane parent;
    private final transient LocoNetSystemConnectionMemo memo;
    protected Roster _roster;
    protected LncvDevicesManager lncvdm;
    private static final Logger log = LoggerFactory.getLogger(LncvProgTableModel.class);

    LncvProgTableModel(LncvProgPane parent, @Nonnull LocoNetSystemConnectionMemo memo) {
        this.parent = parent;
        this.memo = memo;
        this.lncvdm = memo.getLncvDevicesManager();
        this._roster = Roster.getDefault();
        this.lncvdm.addPropertyChangeListener(this);
    }

    public void initTable(JTable lncvModulesTable) {
        TableColumnModel assignmentColumnModel = lncvModulesTable.getColumnModel();
        TableColumn idColumn = assignmentColumnModel.getColumn(0);
        idColumn.setMaxWidth(8);
    }

    @Override
    public String getColumnName(int c) {
        switch (c) {
            case 1: {
                return Bundle.getMessage("HeadingArticle");
            }
            case 2: {
                return Bundle.getMessage("HeadingAddress");
            }
            case 3: {
                return Bundle.getMessage("HeadingCvLastRead");
            }
            case 4: {
                return Bundle.getMessage("HeadingValue");
            }
            case 5: {
                return Bundle.getMessage("HeadingDeviceModel");
            }
            case 6: {
                return Bundle.getMessage("HeadingDeviceId");
            }
            case 7: {
                return Bundle.getMessage("ButtonProgram");
            }
        }
        return "#";
    }

    @Override
    public Class<?> getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return Integer.class;
            }
            case 7: {
                return JButton.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return c == 7;
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public int getRowCount() {
        if (this.lncvdm == null) {
            return 0;
        }
        return this.lncvdm.getDeviceCount();
    }

    @Override
    public Object getValueAt(int r, int c) {
        LncvDevice dev = this.memo.getLncvDevicesManager().getDeviceList().getDevice(r);
        try {
            switch (c) {
                case 1: {
                    assert (dev != null);
                    return dev.getProductID();
                }
                case 2: {
                    assert (dev != null);
                    return dev.getDestAddr();
                }
                case 3: {
                    assert (dev != null);
                    return dev.getCvNum();
                }
                case 4: {
                    assert (dev != null);
                    return dev.getCvValue();
                }
                case 5: {
                    assert (dev != null);
                    if (dev.getDeviceName().length() == 0) {
                        List<DecoderFile> l = InstanceManager.getDefault(DecoderIndexFile.class).matchingDecoderList(null, null, null, null, String.valueOf(dev.getProductID()), null, null, null, null);
                        String lastModelName = "";
                        if (l.size() > 0) {
                            for (DecoderFile d : l) {
                                if (d.getModel().equals("")) {
                                    log.warn("Empty model(name) in decoderfile {}", (Object)d.getFileName());
                                    continue;
                                }
                                lastModelName = d.getModel();
                            }
                            dev.setDevName(lastModelName);
                            dev.setDecoderFile(l.get(l.size() - 1));
                        }
                        return lastModelName;
                    }
                    return dev.getDeviceName();
                }
                case 6: {
                    assert (dev != null);
                    return dev.getRosterName();
                }
                case 7: {
                    assert (dev != null);
                    if (dev.getDeviceName().length() != 0) {
                        if (dev.getRosterName() != null && dev.getRosterName().length() == 0) {
                            return Bundle.getMessage("ButtonCreateEntry");
                        }
                        return Bundle.getMessage("ButtonProgram");
                    }
                    return Bundle.getMessage("ButtonNoMatchInRoster");
                }
            }
            return r + 1;
        }
        catch (NullPointerException nullPointerException) {
            log.warn("Caught NPE reading Module {}", (Object)r);
            return "";
        }
    }

    @Override
    public void setValueAt(Object value, int r, int c) {
        if (this.getRowCount() < r + 1) {
            return;
        }
        LncvDevice dev = this.memo.getLncvDevicesManager().getDeviceList().getDevice(r);
        if (c == 7) {
            if (((String)this.getValueAt(r, c)).compareTo(Bundle.getMessage("ButtonCreateEntry")) == 0) {
                this.createRosterEntry(dev);
                if (dev.getRosterEntry() != null) {
                    this.setValueAt(dev.getRosterName(), r, c);
                } else {
                    log.warn("Failed to connect RosterEntry to device {}", (Object)dev.getRosterName());
                }
            } else if (((String)this.getValueAt(r, c)).compareTo(Bundle.getMessage("ButtonProgram")) == 0) {
                this.openProgrammer(r);
            }
        } else {
            return;
        }
        if (this.getRowCount() >= 1) {
            this.fireTableRowsUpdated(r, r);
        }
    }

    private void openProgrammer(int r) {
        LncvDevice dev = this.memo.getLncvDevicesManager().getDeviceList().getDevice(r);
        LncvDevicesManager.ProgrammingResult result = this.lncvdm.prepareForSymbolicProgrammer(dev, this);
        switch (result) {
            case SUCCESS_PROGRAMMER_OPENED: {
                return;
            }
            case FAIL_NO_SUCH_DEVICE: {
                JOptionPane.showMessageDialog(this.parent, Bundle.getMessage("FAIL_NO_SUCH_DEVICE"), Bundle.getMessage("TitleOpenRosterEntry"), 0);
                return;
            }
            case FAIL_NO_APPROPRIATE_PROGRAMMER: {
                JOptionPane.showMessageDialog(this.parent, Bundle.getMessage("FAIL_NO_APPROPRIATE_PROGRAMMER"), Bundle.getMessage("TitleOpenRosterEntry"), 0);
                return;
            }
            case FAIL_NO_MATCHING_ROSTER_ENTRY: {
                JOptionPane.showMessageDialog(this.parent, Bundle.getMessage("FAIL_NO_MATCHING_ROSTER_ENTRY"), Bundle.getMessage("TitleOpenRosterEntry"), 0);
                return;
            }
            case FAIL_DESTINATION_ADDRESS_IS_ZERO: {
                JOptionPane.showMessageDialog(this.parent, Bundle.getMessage("FAIL_DESTINATION_ADDRESS_IS_ZERO"), Bundle.getMessage("TitleOpenRosterEntry"), 0);
                return;
            }
            case FAIL_MULTIPLE_DEVICES_SAME_DESTINATION_ADDRESS: {
                JOptionPane.showMessageDialog(this.parent, Bundle.getMessage("FAIL_MULTIPLE_DEVICES_SAME_DESTINATION_ADDRESS", dev.getDestAddr()), Bundle.getMessage("TitleOpenRosterEntry"), 0);
                return;
            }
            case FAIL_NO_ADDRESSED_PROGRAMMER: {
                JOptionPane.showMessageDialog(this.parent, Bundle.getMessage("FAIL_NO_ADDRESSED_PROGRAMMER"), Bundle.getMessage("TitleOpenRosterEntry"), 0);
                return;
            }
            case FAIL_NO_LNCV_PROGRAMMER: {
                JOptionPane.showMessageDialog(this.parent, Bundle.getMessage("FAIL_NO_LNCV_PROGRAMMER"), Bundle.getMessage("TitleOpenRosterEntry"), 0);
                return;
            }
        }
        JOptionPane.showMessageDialog(this.parent, Bundle.getMessage("FAIL_UNKNOWN"), Bundle.getMessage("TitleOpenRosterEntry"), 0);
    }

    @Override
    public void openPaneOpsProgFrame(RosterEntry re, String name, String programmerFile, Programmer p) {
        log.debug("attempting to open programmer, re={}, name={}, programmerFile={}, programmer={}", new Object[]{re, name, programmerFile, p});
        DecoderFile decoderFile = InstanceManager.getDefault(DecoderIndexFile.class).fileFromTitle(re.getDecoderModel());
        PaneOpsProgFrame progFrame = new PaneOpsProgFrame(decoderFile, re, name, programmerFile, p);
        progFrame.pack();
        progFrame.setVisible(true);
    }

    private void createRosterEntry(LncvDevice dev) {
        if (dev.getDestAddr() == 0) {
            JOptionPane.showMessageDialog(this.parent, Bundle.getMessage("FAIL_ADD_ENTRY_0"), Bundle.getMessage("ButtonCreateEntry"), 0);
        } else {
            String s = null;
            while (s == null) {
                s = JOptionPane.showInputDialog(this.parent, Bundle.getMessage("DialogEnterEntryName"), "");
                if (s != null) continue;
                return;
            }
            RosterEntry re = new RosterEntry(dev.getDecoderFile().getFileName());
            re.setDccAddress(Integer.toString(dev.getDestAddr()));
            re.setDecoderModel(dev.getDecoderFile().getModel());
            re.setProductID(Integer.toString(dev.getProductID()));
            re.setId(s);
            this._roster.addEntry(re);
            dev.setRosterEntry(re);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.fireTableDataChanged();
    }

    public void dispose() {
        if (this.memo != null && this.memo.getLncvDevicesManager() != null) {
            this.memo.getLncvDevicesManager().removePropertyChangeListener(this);
        }
    }
}

