/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.swing;

import javax.swing.JMenu;
import javax.swing.JSeparator;
import jmri.jmrix.loconet.LnCommandStationType;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.loconetovertcp.LnTcpServerAction;
import jmri.jmrix.loconet.locormi.LnMessageServerAction;
import jmri.jmrix.loconet.swing.Bundle;
import jmri.jmrix.loconet.swing.LnNamedPaneAction;
import jmri.util.swing.sdi.JmriJFrameInterface;

public class LocoNetMenu
extends JMenu {
    Item[] panelItems;

    public LocoNetMenu(LocoNetSystemConnectionMemo memo) {
        Item[] itemArray = new Item[21];
        itemArray[0] = new Item("MenuItemLocoNetMonitor", "jmri.jmrix.loconet.locomon.LocoMonPane", false);
        itemArray[1] = new Item("MenuItemSlotMonitor", "jmri.jmrix.loconet.slotmon.SlotMonPane", false);
        itemArray[2] = new Item("MenuItemClockMon", "jmri.jmrix.loconet.clockmon.ClockMonPane", true);
        itemArray[3] = new Item("MenuItemLocoStats", "jmri.jmrix.loconet.locostats.swing.LocoStatsPanel", false);
        itemArray[5] = new Item("MenuItemBDL16Programmer", "jmri.jmrix.loconet.bdl16.BDL16Panel", true);
        itemArray[6] = new Item("MenuItemPM4Programmer", "jmri.jmrix.loconet.pm4.PM4Panel", true);
        itemArray[7] = new Item("MenuItemSE8cProgrammer", "jmri.jmrix.loconet.se8.SE8Panel", true);
        itemArray[8] = new Item("MenuItemDS64Programmer", "jmri.jmrix.loconet.ds64.Ds64TabbedPanel", true);
        itemArray[9] = new Item("MenuItemCmdStnConfig", "jmri.jmrix.loconet.cmdstnconfig.CmdStnConfigPane", true);
        itemArray[10] = new Item("MenuItemSetID", "jmri.jmrix.loconet.locoid.LocoIdPanel", true);
        itemArray[11] = new Item("MenuItemDuplex", "jmri.jmrix.loconet.duplexgroup.swing.DuplexGroupTabbedPanel", true);
        itemArray[13] = new Item("MenuItemThrottleMessages", "jmri.jmrix.loconet.swing.throttlemsg.MessagePanel", true);
        itemArray[14] = new Item("MenuItemSendPacket", "jmri.jmrix.loconet.locogen.LocoGenPanel", false);
        itemArray[15] = new Item("MenuItemLncvProg", "jmri.jmrix.loconet.swing.lncvprog.LncvProgPane", true);
        itemArray[16] = new Item("MenuItemPr3ModeSelect", "jmri.jmrix.loconet.pr3.swing.Pr3SelectPane", false);
        itemArray[18] = new Item("MenuItemDownload", "jmri.jmrix.loconet.downloader.LoaderPane", false);
        itemArray[19] = new Item("MenuItemSoundload", "jmri.jmrix.loconet.soundloader.LoaderPane", false);
        itemArray[20] = new Item("MenuItemSoundEditor", "jmri.jmrix.loconet.soundloader.EditorPane", false);
        this.panelItems = itemArray;
        LnCommandStationType cmdStation = null;
        if (memo != null) {
            this.setText(memo.getUserName());
            cmdStation = memo.getSlotManager().getCommandStationType();
        } else {
            this.setText(Bundle.getMessage("MenuLocoNet"));
        }
        JmriJFrameInterface wi = new JmriJFrameInterface();
        boolean isLocoNetInterface = cmdStation == null || !cmdStation.equals((Object)LnCommandStationType.COMMAND_STATION_PR2_ALONE) && !cmdStation.equals((Object)LnCommandStationType.COMMAND_STATION_PR3_ALONE) && !cmdStation.equals((Object)LnCommandStationType.COMMAND_STATION_PR4_ALONE) && !cmdStation.equals((Object)LnCommandStationType.COMMAND_STATION_USB_DCS240_ALONE) && !cmdStation.equals((Object)LnCommandStationType.COMMAND_STATION_USB_DCS52_ALONE);
        boolean lastWasSeparator = true;
        Item[] itemArray2 = this.panelItems;
        int n = this.panelItems.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray2[n2];
            if (item == null) {
                if (!lastWasSeparator) {
                    this.add(new JSeparator());
                    lastWasSeparator = true;
                }
            } else if (!item.interfaceOnly || isLocoNetInterface) {
                this.add(new LnNamedPaneAction(Bundle.getMessage(item.name), wi, item.load, memo));
                lastWasSeparator = false;
            }
            ++n2;
        }
        if (isLocoNetInterface) {
            this.add(new JSeparator());
            this.add(new LnMessageServerAction(Bundle.getMessage("MenuItemStartLocoNetServer")));
            this.add(new LnTcpServerAction(Bundle.getMessage("MenuItemLocoNetOverTCPServer")));
        }
    }

    static class Item {
        String name;
        String load;
        boolean interfaceOnly;

        Item(String name, String load, boolean interfaceOnly) {
            this.name = name;
            this.load = load;
            this.interfaceOnly = interfaceOnly;
        }
    }
}

